/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.backtrace;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleStackTrace;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.SuppressFBWarnings;
import org.truffleruby.core.VMPrimitiveNodes;
import org.truffleruby.core.array.ArrayHelpers;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.exception.ExceptionOperations;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.string.StringOperations;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.backtrace.Backtrace;
import org.truffleruby.language.backtrace.BacktraceInterleaver;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.methods.TranslateExceptionNode;
import org.truffleruby.parser.RubySource;

public final class BacktraceFormatter {
    public static final EnumSet<FormattingFlags> USER_BACKTRACE_FLAGS = EnumSet.of(FormattingFlags.OMIT_FROM_PREFIX, FormattingFlags.OMIT_EXCEPTION);
    private final RubyContext context;
    private final RubyLanguage language;
    private final EnumSet<FormattingFlags> flags;

    @CompilerDirectives.TruffleBoundary
    public static BacktraceFormatter createDefaultFormatter(RubyContext context, RubyLanguage language) {
        EnumSet<FormattingFlags> flags = EnumSet.noneOf(FormattingFlags.class);
        if (context.getOptions().BACKTRACES_INTERLEAVE_JAVA) {
            flags.add(FormattingFlags.INTERLEAVE_JAVA);
        }
        return new BacktraceFormatter(context, language, flags);
    }

    public static String printableRubyBacktrace(Object maybeNode) {
        Node n;
        Node node = maybeNode instanceof Node && (n = (Node)maybeNode).isAdoptable() ? (Node)maybeNode : null;
        RubyContext context = RubyLanguage.getCurrentContext();
        BacktraceFormatter backtraceFormatter = new BacktraceFormatter(context, RubyLanguage.getCurrentLanguage(), EnumSet.noneOf(FormattingFlags.class));
        String backtrace = backtraceFormatter.formatBacktrace(null, context.getCallStack().getBacktrace(node));
        if (backtrace.isEmpty()) {
            return "<empty backtrace>";
        }
        if (node == null) {
            return "# the first entry line is imprecise because 'this' is not an adopted Node, select caller Java frames in the debugger until 'this' is an adopted Node to fix this\n" + backtrace;
        }
        return backtrace;
    }

    public static boolean isApplicationCode(RubyLanguage language, SourceSection sourceSection) {
        return BacktraceFormatter.isUserSourceSection(language, sourceSection) && !language.getSourcePath(sourceSection.getSource()).contains("/lib/stdlib/rubygems");
    }

    public BacktraceFormatter(RubyContext context, RubyLanguage language, EnumSet<FormattingFlags> flags) {
        this.context = context;
        this.language = language;
        this.flags = flags;
    }

    @CompilerDirectives.TruffleBoundary
    public void printTopLevelRubyExceptionOnEnvStderr(AbstractTruffleException exception) {
        Backtrace backtrace;
        RubyException rubyException = exception instanceof RaiseException ? ((RaiseException)exception).getException() : null;
        Backtrace backtrace2 = backtrace = rubyException != null ? rubyException.backtrace : null;
        if (backtrace != null && backtrace.getStackTrace().length == 0) {
            this.printRubyExceptionOnEnvStderr("truffleruby: ", exception);
        } else {
            this.printRubyExceptionOnEnvStderr("", exception);
        }
    }

    @CompilerDirectives.TruffleBoundary
    @SuppressFBWarnings(value={"OS"})
    public void printRubyExceptionOnEnvStderr(String info, AbstractTruffleException exception) {
        Object exceptionObject = ExceptionOperations.getExceptionObject(exception);
        if (VMPrimitiveNodes.InitStackOverflowClassesEagerlyNode.ignore(exceptionObject)) {
            return;
        }
        if (exception != null) {
            TruffleStackTrace.fillIn((Throwable)exception);
        }
        PrintStream printer = this.context.getEnvErrStream();
        if (!info.isEmpty()) {
            printer.print(info);
        }
        try {
            Object fullMessage = DispatchNode.getUncached().call((Object)this.context.getCoreLibrary().truffleExceptionOperationsModule, "get_formatted_backtrace", exceptionObject);
            String formatted = RubyStringLibrary.getTStringUncached(fullMessage).toJavaStringUncached();
            if (formatted.endsWith("\n")) {
                printer.print(formatted);
            } else {
                printer.println(formatted);
            }
        }
        catch (Throwable error) {
            printer.println("Error while formatting Ruby exception:");
            if (error instanceof RaiseException) {
                RubyException errorRubyException = ((RaiseException)((Object)error)).getException();
                printer.println(this.formatBacktrace(errorRubyException, errorRubyException.backtrace));
            } else {
                error.printStackTrace(printer);
            }
            if (exceptionObject instanceof RubyException) {
                RubyException rubyException = (RubyException)exceptionObject;
                printer.println("Original Ruby exception:");
                printer.println(this.formatBacktrace(rubyException, rubyException.backtrace));
            } else {
                printer.println("Original foreign exception:");
                exception.printStackTrace(printer);
            }
            printer.println();
        }
    }

    public void printBacktraceOnEnvStderr(Node currentNode) {
        this.printBacktraceOnEnvStderr("", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    @SuppressFBWarnings(value={"OS"})
    public void printBacktraceOnEnvStderr(String info, Node currentNode) {
        Backtrace backtrace = this.context.getCallStack().getBacktrace(currentNode);
        PrintStream printer = this.context.getEnvErrStream();
        if (!info.isEmpty()) {
            printer.print(info);
        }
        printer.println(this.formatBacktrace(null, backtrace));
    }

    public String formatBacktrace(RubyException exception, Backtrace backtrace) {
        return this.formatBacktrace(exception, backtrace, Integer.MAX_VALUE);
    }

    @CompilerDirectives.TruffleBoundary
    public String formatBacktrace(RubyException exception, Backtrace backtrace, int length) {
        return String.join((CharSequence)"\n", this.formatBacktraceAsStringArray(exception, backtrace, length));
    }

    public RubyArray formatBacktraceAsRubyStringArray(RubyException exception, Backtrace backtrace) {
        return this.formatBacktraceAsRubyStringArray(exception, backtrace, Integer.MAX_VALUE);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyArray formatBacktraceAsRubyStringArray(RubyException exception, Backtrace backtrace, int length) {
        String[] lines = this.formatBacktraceAsStringArray(exception, backtrace, length);
        Object[] array = new Object[lines.length];
        for (int n = 0; n < lines.length; ++n) {
            array[n] = StringOperations.createUTF8String(this.context, this.language, lines[n]);
        }
        return ArrayHelpers.createArray(this.context, this.language, array);
    }

    @CompilerDirectives.TruffleBoundary
    private String[] formatBacktraceAsStringArray(RubyException exception, Backtrace backtrace, int length) {
        if (backtrace == null) {
            backtrace = this.context.getCallStack().getBacktrace(null);
        }
        TruffleStackTraceElement[] stackTrace = backtrace.getStackTrace();
        length = Math.min(length, stackTrace.length);
        ArrayList<String> lines = new ArrayList<String>(length);
        if (length == 0 && !this.flags.contains((Object)FormattingFlags.OMIT_EXCEPTION) && exception != null) {
            lines.add(this.formatException(exception));
            return lines.toArray(StringUtils.EMPTY_STRING_ARRAY);
        }
        for (int n = 0; n < length; ++n) {
            lines.add(this.formatLine(stackTrace, n, exception));
        }
        if (backtrace.getJavaThrowable() != null && this.flags.contains((Object)FormattingFlags.INTERLEAVE_JAVA)) {
            List<String> interleaved = BacktraceInterleaver.interleave(lines, backtrace.getJavaThrowable().getStackTrace(), backtrace.getOmitted());
            return interleaved.toArray(StringUtils.EMPTY_STRING_ARRAY);
        }
        return lines.toArray(StringUtils.EMPTY_STRING_ARRAY);
    }

    @CompilerDirectives.TruffleBoundary
    public String formatLine(TruffleStackTraceElement[] stackTrace, int n, RubyException exception) {
        try {
            return this.formatLineInternal(stackTrace, n, exception);
        }
        catch (Exception e) {
            TranslateExceptionNode.logJavaException(this.context, null, e);
            String firstFrame = e.getStackTrace().length > 0 ? e.getStackTrace()[0].toString() : "";
            return StringUtils.format("(exception %s %s %s", e.getClass().getName(), e.getMessage(), firstFrame);
        }
    }

    private String formatLineInternal(TruffleStackTraceElement[] stackTrace, int n, RubyException exception) {
        TruffleStackTraceElement element = stackTrace[n];
        StringBuilder builder = new StringBuilder();
        if (!this.flags.contains((Object)FormattingFlags.OMIT_FROM_PREFIX) && n > 0) {
            builder.append("\tfrom ");
        }
        Node callNode = element.getLocation();
        RootNode rootNode = element.getTarget().getRootNode();
        SourceSection sourceSection = callNode == null ? rootNode.getSourceSection() : callNode.getEncapsulatingSourceSection();
        String methodName = Backtrace.labelFor(element);
        if (rootNode instanceof RubyRootNode) {
            SourceSection reportedSourceSection;
            if (BacktraceFormatter.isAvailable(sourceSection)) {
                reportedSourceSection = sourceSection;
            } else {
                SourceSection nextUserSourceSection = BacktraceFormatter.nextAvailableSourceSection(stackTrace, n);
                SourceSection sourceSection2 = reportedSourceSection = nextUserSourceSection != null ? nextUserSourceSection : sourceSection;
            }
            if (reportedSourceSection == null) {
                builder.append("???");
            } else {
                builder.append(this.language.getSourcePath(reportedSourceSection.getSource()));
                builder.append(":");
                builder.append(RubySource.getStartLineAdjusted(this.context, reportedSourceSection));
            }
        } else if (sourceSection == null) {
            builder.append("???");
        } else {
            builder.append(this.context.fileLine(sourceSection));
        }
        builder.append(":in `");
        builder.append(methodName);
        builder.append("'");
        if (!this.flags.contains((Object)FormattingFlags.OMIT_EXCEPTION) && exception != null && n == 0) {
            builder.append(": ");
            builder.append(this.formatException(exception));
        }
        return builder.toString();
    }

    public static String formatStackTraceElement(StackTraceElement element) {
        StringBuilder builder = new StringBuilder();
        builder.append(element.getClassName()).append(".").append(element.getMethodName());
        builder.append("(").append(element.getFileName()).append(":").append(element.getLineNumber()).append(")");
        return builder.toString();
    }

    private String formatException(RubyException exception) {
        StringBuilder builder = new StringBuilder();
        String message = ExceptionOperations.messageToString(exception);
        String exceptionClass = exception.getLogicalClass().fields.getName();
        int firstLn = message.indexOf(10);
        if (firstLn >= 0) {
            builder.append(message, 0, firstLn);
            builder.append(" (").append(exceptionClass).append(")");
            builder.append(message.substring(firstLn));
        } else {
            builder.append(message);
            builder.append(" (").append(exceptionClass).append(")");
        }
        return builder.toString();
    }

    public static SourceSection nextAvailableSourceSection(TruffleStackTraceElement[] stackTrace, int n) {
        while (n < stackTrace.length) {
            SourceSection sourceSection;
            Node callNode = stackTrace[n].getLocation();
            if (callNode != null && BacktraceFormatter.isAvailable(sourceSection = callNode.getEncapsulatingSourceSection())) {
                return sourceSection;
            }
            ++n;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isAvailable(SourceSection sourceSection) {
        return sourceSection != null && sourceSection.isAvailable();
    }

    public static boolean isUserSourceSection(RubyLanguage language, SourceSection sourceSection) {
        return BacktraceFormatter.isAvailable(sourceSection) && !BacktraceFormatter.isRubyCore(language, sourceSection.getSource());
    }

    public static boolean isRubyCore(RubyLanguage language, Source source) {
        String path = RubyLanguage.getPath(source);
        return path.startsWith(language.coreLoadPath);
    }

    public static String formatJavaThrowableMessage(Throwable t) {
        String message = t.getMessage();
        return (message != null ? message : "<no message>") + " (" + t.getClass().getCanonicalName() + ")";
    }

    @CompilerDirectives.TruffleBoundary
    public static void printInternalError(RubyContext context, Throwable throwable, String from) {
        PrintStream stream = context.getEnvErrStream();
        BacktraceFormatter formatter = context.getDefaultBacktraceFormatter();
        stream.println();
        stream.println("truffleruby: " + from + ",");
        stream.println("please report it to https://github.com/oracle/truffleruby/issues");
        stream.println();
        stream.println("```");
        boolean firstException = true;
        for (Throwable t = throwable; t != null && !t.getClass().getSimpleName().equals("LazyStackTrace"); t = t.getCause()) {
            if (!firstException) {
                stream.println("Caused by:");
            }
            if (t instanceof RaiseException) {
                RubyException rubyException = ((RaiseException)((Object)t)).getException();
                String formattedBacktrace = formatter.formatBacktrace(rubyException, rubyException.backtrace);
                stream.println(formattedBacktrace);
            } else {
                stream.println(BacktraceFormatter.formatJavaThrowableMessage(t));
                if (t instanceof AbstractTruffleException) {
                    stream.println(formatter.formatBacktrace(null, new Backtrace((AbstractTruffleException)t)));
                } else {
                    String formatted;
                    BacktraceFormatter.printJavaStackTrace(stream, t);
                    if (TruffleStackTrace.getStackTrace((Throwable)t) != null && !(formatted = formatter.formatBacktrace(null, new Backtrace(t))).isEmpty()) {
                        stream.println(formatted);
                    }
                }
            }
            firstException = false;
        }
        stream.println("```");
    }

    public static void appendJavaStackTrace(Throwable t, StringBuilder builder) {
        StackTraceElement[] stackTrace;
        for (StackTraceElement stackTraceElement : stackTrace = t.getStackTrace()) {
            if (BacktraceInterleaver.isCallBoundary(stackTraceElement)) break;
            builder.append("\tfrom ").append(BacktraceFormatter.formatStackTraceElement(stackTraceElement)).append('\n');
        }
    }

    private static void printJavaStackTrace(PrintStream stream, Throwable t) {
        StringBuilder stringBuilder = new StringBuilder();
        BacktraceFormatter.appendJavaStackTrace(t, stringBuilder);
        stream.print(stringBuilder.toString());
    }

    public static enum FormattingFlags {
        OMIT_EXCEPTION,
        OMIT_FROM_PREFIX,
        INTERLEAVE_JAVA;

    }
}

