/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.arguments;

import java.util.Arrays;
import org.truffleruby.collections.WeakValueCache;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.language.arguments.KeywordArgumentsDescriptor;

public final class KeywordArgumentsDescriptorManager {
    private final WeakValueCache<Key, KeywordArgumentsDescriptor> CANONICAL_KEYWORD_DESCRIPTORS = new WeakValueCache();

    public KeywordArgumentsDescriptorManager() {
        this.CANONICAL_KEYWORD_DESCRIPTORS.put(new Key(StringUtils.EMPTY_STRING_ARRAY), KeywordArgumentsDescriptor.EMPTY);
    }

    public KeywordArgumentsDescriptor getArgumentsDescriptor(String[] keywords) {
        Key key = new Key(keywords);
        KeywordArgumentsDescriptor descriptor = new KeywordArgumentsDescriptor(keywords);
        return this.CANONICAL_KEYWORD_DESCRIPTORS.addInCacheIfAbsent(key, descriptor);
    }

    public static final class Key {
        private final String[] keywords;

        public Key(String[] keywords) {
            this.keywords = keywords;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            Key otherKey = (Key)other;
            return Arrays.equals(this.keywords, otherKey.keywords);
        }

        public int hashCode() {
            return Arrays.hashCode(this.keywords);
        }
    }
}

