/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import java.util.ArrayList;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.core.hash.library.HashStoreLibrary;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.arguments.ReadUserKeywordsHashNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.methods.Arity;

public final class CheckKeywordArityNode
extends RubyBaseNode {
    public final Arity arity;
    @Node.Child
    private ReadUserKeywordsHashNode readUserKeywordsHashNode;
    @Node.Child
    private CheckExtraKeywordArgumentsNode checkExtraKeywordArgumentsNode;

    public CheckKeywordArityNode(Arity arity) {
        assert (!arity.hasKeywordsRest()) : "no need to create this node";
        this.arity = arity;
        this.readUserKeywordsHashNode = new ReadUserKeywordsHashNode();
    }

    public void checkArity(VirtualFrame frame) {
        RubyHash keywordArguments = this.readUserKeywordsHashNode.execute(frame);
        if (keywordArguments != null) {
            this.checkKeywordArguments(keywordArguments);
        }
    }

    private void checkKeywordArguments(RubyHash keywordArguments) {
        if (this.checkExtraKeywordArgumentsNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.checkExtraKeywordArgumentsNode = (CheckExtraKeywordArgumentsNode)this.insert(new CheckExtraKeywordArgumentsNode(this.getLanguage(), this.arity));
        }
        this.checkExtraKeywordArgumentsNode.check(keywordArguments);
    }

    static RubySymbol[] keywordsAsSymbols(RubyLanguage language, Arity arity) {
        String[] names = arity.getKeywordArguments();
        if (names.length == 0) {
            return RubySymbol.EMPTY_ARRAY;
        }
        RubySymbol[] symbols = new RubySymbol[names.length];
        for (int i = 0; i < names.length; ++i) {
            symbols[i] = language.getSymbol(names[i]);
        }
        return symbols;
    }

    public CheckKeywordArityNode cloneUninitialized() {
        return new CheckKeywordArityNode(this.arity);
    }

    private static final class CheckExtraKeywordArgumentsNode
    extends RubyBaseNode
    implements HashStoreLibrary.EachEntryCallback {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final RubySymbol[] allowedKeywords;
        private final BranchProfile unknownKeywordProfile = BranchProfile.create();
        @Node.Child
        private HashStoreLibrary hashes;

        public CheckExtraKeywordArgumentsNode(RubyLanguage language, Arity arity) {
            assert (!arity.hasKeywordsRest());
            this.hashes = HashStoreLibrary.createDispatched();
            this.allowedKeywords = CheckKeywordArityNode.keywordsAsSymbols(language, arity);
        }

        public void check(RubyHash keywordArguments) {
            this.hashes.eachEntry(keywordArguments.store, keywordArguments, this, keywordArguments);
        }

        @Override
        public void accept(int index, Object key, Object value, Object state) {
            if (!this.keywordAllowed(key)) {
                this.unknownKeywordProfile.enter();
                RubyHash keywordArguments = (RubyHash)state;
                throw new RaiseException(this.getContext(), this.unknownKeywordsError(keywordArguments));
            }
        }

        @ExplodeLoop
        private boolean keywordAllowed(Object keyword) {
            for (RubySymbol allowedKeyword : this.allowedKeywords) {
                if (allowedKeyword != keyword) continue;
                return true;
            }
            return false;
        }

        @CompilerDirectives.TruffleBoundary
        private RubyException unknownKeywordsError(RubyHash keywordArguments) {
            Object[] keys = this.findExtraKeywordArguments(keywordArguments);
            return this.coreExceptions().argumentErrorUnknownKeywords(keys, this);
        }

        @CompilerDirectives.TruffleBoundary
        private Object[] findExtraKeywordArguments(RubyHash keywordArguments) {
            ArrayList actualKeywordsAsList = new ArrayList();
            this.hashes.eachEntry(keywordArguments.store, keywordArguments, (index, key, value, state) -> ((ArrayList)state).add(key), actualKeywordsAsList);
            return ArrayUtils.subtract(actualKeywordsAsList.toArray(), this.allowedKeywords);
        }
    }
}

