/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.Split;
import org.truffleruby.builtins.ReRaiseInlinedExceptionNode;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyBaseRootNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.control.ReturnID;
import org.truffleruby.language.methods.SharedMethodInfo;
import org.truffleruby.parser.BlockDescriptorInfo;

public class RubyRootNode
extends RubyBaseRootNode {
    private final SharedMethodInfo sharedMethodInfo;
    private Split split;
    public final ReturnID returnID;
    @Node.Child
    protected RubyNode body;
    protected final RubyNode bodyCopy;
    private static final Node[] EMPTY_NODE_ARRAY = new Node[0];

    public static RubyRootNode of(RootCallTarget callTarget) {
        return (RubyRootNode)callTarget.getRootNode();
    }

    public RubyRootNode(RubyLanguage language, SourceSection sourceSection, FrameDescriptor frameDescriptor, SharedMethodInfo sharedMethodInfo, RubyNode body, Split split, ReturnID returnID) {
        super(language, frameDescriptor, sourceSection);
        assert (sourceSection != null);
        assert (body != null);
        this.sharedMethodInfo = sharedMethodInfo;
        this.body = body;
        this.split = split;
        this.returnID = returnID;
        if (!body.hasSource()) {
            body.unsafeSetSourceSection(sourceSection);
        }
        body.unsafeSetIsCall();
        body.unsafeSetIsRoot();
        this.bodyCopy = language.options.CHECK_CLONE_UNINITIALIZED_CORRECTNESS ? (RubyNode)NodeUtil.cloneNode((Node)body) : null;
    }

    public Object execute(VirtualFrame frame) {
        return this.body.execute(frame);
    }

    public FrameDescriptor getParentFrameDescriptor() {
        Object info = this.getFrameDescriptor().getInfo();
        if (info instanceof BlockDescriptorInfo) {
            return ((BlockDescriptorInfo)info).getParentDescriptor();
        }
        return null;
    }

    public boolean isCloningAllowed() {
        return this.split != Split.NEVER;
    }

    public boolean shouldAlwaysClone() {
        assert (this.isCloningAllowed());
        if (this.getLanguage().options.ALWAYS_CLONE_ALL) {
            return this.split != Split.NEVER;
        }
        return this.split == Split.ALWAYS;
    }

    public Split getSplit() {
        return this.split;
    }

    public void setSplit(Split split) {
        this.split = split;
    }

    public String getName() {
        return this.sharedMethodInfo.getParseName();
    }

    public String toString() {
        return this.sharedMethodInfo.getParseName();
    }

    public SharedMethodInfo getSharedMethodInfo() {
        return this.sharedMethodInfo;
    }

    public NodeFactory<? extends RubyBaseNode> getAlwaysInlinedNodeFactory() {
        return ((ReRaiseInlinedExceptionNode)this.body).nodeFactory;
    }

    public RubyNode copyBody() {
        return (RubyNode)NodeUtil.cloneNode((Node)this.body);
    }

    protected boolean isCloneUninitializedSupported() {
        return true;
    }

    protected RubyRootNode cloneUninitializedRootNode() {
        return new RubyRootNode(this.getLanguage(), this.getSourceSection(), this.getFrameDescriptor(), this.sharedMethodInfo, this.body.cloneUninitialized(), this.split, this.returnID);
    }

    public final RootNode cloneUninitialized() {
        RubyRootNode clone = this.cloneUninitializedRootNode();
        if (this.getLanguage().options.CHECK_CLONE_UNINITIALIZED_CORRECTNESS) {
            this.ensureCloneUninitializedCorrectness(clone);
        }
        return clone;
    }

    private void ensureCloneUninitializedCorrectness(RubyRootNode clone) {
        if (this == clone) {
            throw CompilerDirectives.shouldNotReachHere((String)"clone same as this");
        }
        this.assertSame(((Object)((Object)this)).getClass(), ((Object)((Object)clone)).getClass());
        this.assertSame(this.getSourceSection(), clone.getSourceSection());
        this.assertSame(this.sharedMethodInfo, clone.sharedMethodInfo);
        this.assertSame(this.getSplit(), clone.getSplit());
        this.assertSame(this.returnID, clone.returnID);
        IdentityHashMap<Node, Boolean> specializedNodes = new IdentityHashMap<Node, Boolean>();
        this.body.accept(node -> {
            specializedNodes.put(node, true);
            return true;
        });
        try {
            this.ensureClonedCorrectly(this.bodyCopy, clone.body, specializedNodes);
        }
        catch (CloningError e) {
            System.err.println();
            System.err.println("#cloneUninitialized for RubyRootNode " + this.getName() + " created not identical AST");
            System.err.println(e.getMessage());
            System.err.println();
            System.err.println("Original node:");
            NodeUtil.printCompactTree((OutputStream)System.err, (Node)e.original);
            System.err.println("Cloned node:");
            NodeUtil.printCompactTree((OutputStream)System.err, (Node)e.clone);
            System.err.println();
            System.err.println("Original root node body:");
            NodeUtil.printCompactTree((OutputStream)System.err, (Node)this.bodyCopy);
            System.err.println("Cloned root node body:");
            NodeUtil.printCompactTree((OutputStream)System.err, (Node)clone.body);
            throw new Error("#cloneUninitialized for RubyRootNode " + this.getName() + " created not identical AST");
        }
    }

    private void assertSame(Object a, Object b) {
        if (a != b) {
            throw CompilerDirectives.shouldNotReachHere((String)("different " + String.valueOf(a) + " vs " + String.valueOf(b) + " for: " + String.valueOf((Object)this)));
        }
    }

    private void ensureClonedCorrectly(Node original, Node clone, IdentityHashMap<Node, Boolean> specializedNodes) {
        if (original == clone) {
            throw new CloningError("Clone is the same instance as the original node", original, clone);
        }
        if (specializedNodes.containsKey(clone)) {
            throw new CloningError("Clone is a node from the initialized AST", clone, clone);
        }
        if (original instanceof InstrumentableNode.WrapperNode) {
            InstrumentableNode.WrapperNode wrapperNode = (InstrumentableNode.WrapperNode)original;
            this.ensureClonedCorrectly(wrapperNode.getDelegateNode(), clone, specializedNodes);
            return;
        }
        if (original.getClass() != clone.getClass()) {
            throw new CloningError("Nodes are instances of different classes", original, clone);
        }
        if (original instanceof RubyNode) {
            RubyNode a = (RubyNode)original;
            RubyNode b = (RubyNode)clone;
            if (a.getFlags() != b.getFlags()) {
                throw new CloningError("flags not copied", original, clone);
            }
            if (a.getSourceCharIndex() != b.getSourceCharIndex()) {
                throw new CloningError("sourceCharIndex not copied", original, clone);
            }
            if (a.getSourceLength() != b.getSourceLength()) {
                throw new CloningError("sourceLength not copied", original, clone);
            }
        }
        Node[] originalChildren = this.childrenToArray(original);
        Node[] cloneChildren = this.childrenToArray(clone);
        if (cloneChildren.length != originalChildren.length) {
            throw new CloningError("Nodes have different number of children", original, clone);
        }
        for (int i = 0; i < cloneChildren.length; ++i) {
            this.ensureClonedCorrectly(originalChildren[i], cloneChildren[i], specializedNodes);
        }
    }

    private Node[] childrenToArray(Node node) {
        ArrayList<Node> childrenList = new ArrayList<Node>();
        for (Node child : node.getChildren()) {
            childrenList.add(child);
        }
        return childrenList.toArray(EMPTY_NODE_ARRAY);
    }

    private static final class CloningError
    extends Error {
        public final Node original;
        public final Node clone;

        CloningError(String message, Node original, Node clone) {
            super(message);
            this.original = original;
            this.clone = clone;
        }
    }
}

