/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyBaseRootNode;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.arguments.NoKeywordArgumentsDescriptor;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.backtrace.InternalRootNode;
import org.truffleruby.language.methods.DeclarationContext;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.methods.SharedMethodInfo;
import org.truffleruby.language.objects.shared.SharedObjects;
import org.truffleruby.parser.ParserContext;
import org.truffleruby.parser.RubySource;
import org.truffleruby.parser.YARPTranslatorDriver;
import org.truffleruby.shared.Metrics;

public final class RubyParsingRequestNode
extends RubyBaseRootNode
implements InternalRootNode {
    private final RootCallTarget callTarget;
    @Node.Child
    private DirectCallNode callNode;

    public RubyParsingRequestNode(RubyLanguage language, RubyContext context, Source source, String[] argumentNames) {
        super(language, null, null);
        RubySource rubySource = new RubySource(source, language.getSourcePath(source));
        YARPTranslatorDriver translator = new YARPTranslatorDriver(context);
        this.callTarget = translator.parse(rubySource, ParserContext.TOP_LEVEL, argumentNames, null, context.getRootLexicalScope(), null);
        this.callNode = (DirectCallNode)this.insert((Node)Truffle.getRuntime().createDirectCallNode((CallTarget)this.callTarget));
        this.callNode.forceInlining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(VirtualFrame frame) {
        RubyLanguage language = this.getLanguage();
        RubyContext context = this.getContext();
        SharedMethodInfo sharedMethodInfo = RubyRootNode.of(this.callTarget).getSharedMethodInfo();
        assert (sharedMethodInfo.getStaticLexicalScopeOrNull() == context.getRootLexicalScope() || sharedMethodInfo.getStaticLexicalScopeOrNull() == null);
        InternalMethod method = new InternalMethod(context, sharedMethodInfo, context.getRootLexicalScope(), DeclarationContext.topLevel(context), sharedMethodInfo.getMethodNameForNotBlock(), context.getCoreLibrary().objectClass, Visibility.PUBLIC, this.callTarget);
        this.printTimeMetric("before-script");
        try {
            Object value = this.callNode.call(RubyArguments.pack(null, null, method, null, (Object)context.getCoreLibrary().mainObject, Nil.INSTANCE, NoKeywordArgumentsDescriptor.INSTANCE, frame.getArguments()));
            if (language.options.SHARED_OBJECTS_ENABLED && context.getOptions().EMBEDDED) {
                SharedObjects.writeBarrier(language, value);
            }
            Object object = value;
            return object;
        }
        finally {
            this.printTimeMetric("after-script");
        }
    }

    public String getName() {
        return "parsing-request";
    }

    @CompilerDirectives.TruffleBoundary
    private void printTimeMetric(String id) {
        Metrics.printTime((String)id);
    }
}

