/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.CoreLibrary;

public abstract class RubyBaseRootNode
extends RootNode {
    private final SourceSection sourceSection;

    public RubyBaseRootNode(TruffleLanguage<?> language, FrameDescriptor frameDescriptor, SourceSection sourceSection) {
        super(language, frameDescriptor);
        this.sourceSection = sourceSection;
    }

    public final SourceSection getSourceSection() {
        return this.sourceSection;
    }

    public boolean isInternal() {
        if (this.sourceSection != null) {
            return this.sourceSection.getSource().isInternal();
        }
        return false;
    }

    public boolean isCaptureFramesForTrace(boolean compiledFrame) {
        return false;
    }

    public boolean countsTowardsStackTraceLimit() {
        return !this.isInternal() && this.sourceSection != CoreLibrary.JAVA_CORE_SOURCE_SECTION;
    }

    public final RubyLanguage getLanguage() {
        return RubyLanguage.get((Node)this);
    }

    public final RubyContext getContext() {
        return RubyContext.get((Node)this);
    }
}

