/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import com.oracle.truffle.api.profiles.LoopConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.MutableTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.math.BigInteger;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.CoreLibrary;
import org.truffleruby.core.array.ArrayHelpers;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.exception.CoreExceptions;
import org.truffleruby.core.numeric.BignumOperations;
import org.truffleruby.core.numeric.RubyBignum;
import org.truffleruby.core.string.CoreStrings;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.core.symbol.CoreSymbols;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.RubyTypes;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.objects.AllocationTracing;

@GenerateInline(value=false, inherit=true)
@TypeSystemReference(value=RubyTypes.class)
@ImportStatic(value={RubyGuards.class})
public abstract class RubyBaseNode
extends Node {
    public static final Object[] EMPTY_ARGUMENTS = ArrayUtils.EMPTY_ARRAY;
    public static final Nil nil = Nil.INSTANCE;
    public static final int MAX_EXPLODE_SIZE = 16;

    @Idempotent
    protected boolean isSingleContext() {
        return this.getLanguage().singleContext;
    }

    protected static Object nilToNull(Object value) {
        return value == nil ? null : value;
    }

    protected static Object nullToNil(Object value) {
        return value == null ? nil : value;
    }

    public static void profileAndReportLoopCount(Node node, LoopConditionProfile loopProfile, int count) {
        loopProfile.profileCounted((long)count);
        LoopNode.reportLoopCount((Node)node, (int)count);
    }

    protected void profileAndReportLoopCount(LoopConditionProfile loopProfile, int count) {
        RubyBaseNode.profileAndReportLoopCount((Node)this, loopProfile, count);
    }

    public static void profileAndReportLoopCount(Node node, InlinedLoopConditionProfile loopProfile, int count) {
        loopProfile.profileCounted(node, (long)count);
        LoopNode.reportLoopCount((Node)node, (int)count);
    }

    protected void profileAndReportLoopCount(LoopConditionProfile loopProfile, long count) {
        loopProfile.profileCounted(count);
        this.reportLongLoopCount(count);
    }

    protected static void profileAndReportLoopCount(Node node, InlinedLoopConditionProfile loopProfile, long count) {
        loopProfile.profileCounted(node, count);
        RubyBaseNode.reportLongLoopCount(node, count);
    }

    protected static void reportLongLoopCount(Node node, long count) {
        assert (count >= 0L);
        LoopNode.reportLoopCount((Node)node, (int)(count > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)count));
    }

    protected void reportLongLoopCount(long count) {
        assert (count >= 0L);
        LoopNode.reportLoopCount((Node)this, (int)(count > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)count));
    }

    protected static Node getAdoptedNode(Node node) {
        boolean adoptable = node != null && node.isAdoptable();
        CompilerAsserts.partialEvaluationConstant((boolean)adoptable);
        if (adoptable) {
            return node;
        }
        return EncapsulatingNodeReference.getCurrent().get();
    }

    protected final RubyLanguage getLanguage() {
        return RubyBaseNode.getLanguage(this);
    }

    protected static RubyLanguage getLanguage(Node node) {
        return RubyLanguage.get(node);
    }

    protected final RubyContext getContext() {
        return RubyBaseNode.getContext(this);
    }

    protected static RubyContext getContext(Node node) {
        return RubyContext.get(node);
    }

    protected final RubyEncoding getLocaleEncoding() {
        return this.getContext().getEncodingManager().getLocaleEncoding();
    }

    protected static RubyBignum createBignum(BigInteger value) {
        return BignumOperations.createBignum(value);
    }

    protected final RubySymbol getSymbol(String name) {
        return RubyBaseNode.getSymbol(this, name);
    }

    protected static RubySymbol getSymbol(Node node, String name) {
        return RubyBaseNode.getLanguage(node).getSymbol(name);
    }

    protected final RubySymbol getSymbol(AbstractTruffleString name, RubyEncoding encoding) {
        return RubyBaseNode.getSymbol(this, name, encoding);
    }

    protected static RubySymbol getSymbol(Node node, AbstractTruffleString name, RubyEncoding encoding) {
        return RubyBaseNode.getLanguage(node).getSymbol(name, encoding);
    }

    protected final RubySymbol getSymbol(AbstractTruffleString name, RubyEncoding encoding, boolean preserveSymbol) {
        return this.getLanguage().getSymbol(name, encoding, preserveSymbol);
    }

    protected static RubySymbol getSymbol(Node node, AbstractTruffleString name, RubyEncoding encoding, boolean preserveSymbol) {
        return RubyBaseNode.getLanguage(node).getSymbol(name, encoding, preserveSymbol);
    }

    protected final CoreStrings coreStrings() {
        return RubyBaseNode.coreStrings(this);
    }

    protected static CoreStrings coreStrings(Node node) {
        return RubyBaseNode.getLanguage((Node)node).coreStrings;
    }

    protected final CoreSymbols coreSymbols() {
        return RubyBaseNode.coreSymbols(this);
    }

    protected static CoreSymbols coreSymbols(Node node) {
        return RubyBaseNode.getLanguage((Node)node).coreSymbols;
    }

    protected final RubyArray createArray(Object store, int size) {
        return RubyBaseNode.createArray(this, store, size);
    }

    protected static RubyArray createArray(Node node, Object store, int size) {
        return ArrayHelpers.createArray(RubyBaseNode.getContext(node), RubyBaseNode.getLanguage(node), store, size);
    }

    protected final RubyArray createArray(int[] store) {
        return RubyBaseNode.createArray((Node)this, store);
    }

    protected static RubyArray createArray(Node node, int[] store) {
        return ArrayHelpers.createArray(RubyBaseNode.getContext(node), RubyBaseNode.getLanguage(node), store);
    }

    protected final RubyArray createArray(long[] store) {
        return RubyBaseNode.createArray((Node)this, store);
    }

    protected static RubyArray createArray(Node node, long[] store) {
        return ArrayHelpers.createArray(RubyBaseNode.getContext(node), RubyBaseNode.getLanguage(node), store);
    }

    protected final RubyArray createArray(Object[] store) {
        return RubyBaseNode.createArray((Node)this, store);
    }

    public static RubyArray createArray(Node node, Object[] store) {
        return ArrayHelpers.createArray(RubyBaseNode.getContext(node), RubyBaseNode.getLanguage(node), store);
    }

    protected final RubyArray createEmptyArray() {
        return RubyBaseNode.createEmptyArray(this);
    }

    protected static RubyArray createEmptyArray(Node node) {
        return ArrayHelpers.createEmptyArray(RubyBaseNode.getContext(node), RubyBaseNode.getLanguage(node));
    }

    protected final RubyString createString(TruffleString tstring, RubyEncoding encoding) {
        return RubyBaseNode.createString(this, tstring, encoding);
    }

    protected static RubyString createString(Node node, TruffleString tstring, RubyEncoding encoding) {
        RubyString instance = new RubyString(RubyBaseNode.coreLibrary((Node)node).stringClass, RubyBaseNode.getLanguage((Node)node).stringShape, false, (AbstractTruffleString)tstring, encoding);
        AllocationTracing.trace(instance, node);
        return instance;
    }

    protected final RubyString createStringCopy(TruffleString.AsTruffleStringNode asTruffleStringNode, AbstractTruffleString tstring, RubyEncoding encoding) {
        return RubyBaseNode.createStringCopy(this, asTruffleStringNode, tstring, encoding);
    }

    protected static RubyString createStringCopy(Node node, TruffleString.AsTruffleStringNode asTruffleStringNode, AbstractTruffleString tstring, RubyEncoding encoding) {
        TruffleString copy = asTruffleStringNode.execute(tstring, encoding.tencoding);
        RubyString instance = new RubyString(RubyBaseNode.coreLibrary((Node)node).stringClass, RubyBaseNode.getLanguage((Node)node).stringShape, false, (AbstractTruffleString)copy, encoding);
        AllocationTracing.trace(instance, node);
        return instance;
    }

    protected final RubyString createMutableString(MutableTruffleString tstring, RubyEncoding encoding) {
        RubyString instance = new RubyString(this.coreLibrary().stringClass, this.getLanguage().stringShape, false, (AbstractTruffleString)tstring, encoding);
        AllocationTracing.trace(instance, this);
        return instance;
    }

    protected final RubyString createString(TStringWithEncoding tStringWithEncoding) {
        return RubyBaseNode.createString(this, tStringWithEncoding);
    }

    protected static RubyString createString(Node node, TStringWithEncoding tStringWithEncoding) {
        return RubyBaseNode.createString(node, tStringWithEncoding.tstring, tStringWithEncoding.encoding);
    }

    protected final RubyString createString(TruffleString.FromByteArrayNode fromByteArrayNode, byte[] bytes, RubyEncoding encoding) {
        return RubyBaseNode.createString((Node)this, fromByteArrayNode, bytes, encoding);
    }

    protected static RubyString createString(Node node, TruffleString.FromByteArrayNode fromByteArrayNode, byte[] bytes, RubyEncoding encoding) {
        TruffleString tstring = fromByteArrayNode.execute(bytes, encoding.tencoding, false);
        return RubyBaseNode.createString(node, tstring, encoding);
    }

    protected final RubyString createString(TruffleString.FromJavaStringNode fromJavaStringNode, String javaString, RubyEncoding encoding) {
        return RubyBaseNode.createString((Node)this, fromJavaStringNode, javaString, encoding);
    }

    public static RubyString createString(Node node, TruffleString.FromJavaStringNode fromJavaStringNode, String javaString, RubyEncoding encoding) {
        TruffleString tstring = fromJavaStringNode.execute(javaString, encoding.tencoding);
        return RubyBaseNode.createString(node, tstring, encoding);
    }

    protected final RubyString createSubString(TruffleString.SubstringByteIndexNode substringNode, RubyStringLibrary strings, Object source, int byteOffset, int byteLength) {
        return this.createSubString(substringNode, strings.getTString(this, source), strings.getEncoding(this, source), byteOffset, byteLength);
    }

    protected final RubyString createSubString(TruffleString.SubstringByteIndexNode substringNode, AbstractTruffleString tstring, RubyEncoding encoding, int byteOffset, int byteLength) {
        return RubyBaseNode.createSubString(this, substringNode, tstring, encoding, byteOffset, byteLength);
    }

    protected static RubyString createSubString(Node node, TruffleString.SubstringByteIndexNode substringNode, AbstractTruffleString tstring, RubyEncoding encoding, int byteOffset, int byteLength) {
        TruffleString substring = substringNode.execute(tstring, byteOffset, byteLength, encoding.tencoding, true);
        return RubyBaseNode.createString(node, substring, encoding);
    }

    protected final RubyString createSubString(TruffleString.SubstringNode substringNode, AbstractTruffleString tstring, RubyEncoding encoding, int codePointOffset, int codePointLength) {
        TruffleString substring = substringNode.execute(tstring, codePointOffset, codePointLength, encoding.tencoding, true);
        return this.createString(substring, encoding);
    }

    protected final CoreLibrary coreLibrary() {
        return RubyBaseNode.coreLibrary(this);
    }

    protected static CoreLibrary coreLibrary(Node node) {
        return RubyBaseNode.getContext(node).getCoreLibrary();
    }

    protected final CoreExceptions coreExceptions() {
        return RubyBaseNode.coreExceptions(this);
    }

    protected static CoreExceptions coreExceptions(Node node) {
        return RubyBaseNode.getContext(node).getCoreExceptions();
    }

    protected final int getDefaultCacheLimit() {
        return this.getLanguage().options.DEFAULT_CACHE;
    }

    protected final int getDynamicObjectCacheLimit() {
        return this.getLanguage().options.INSTANCE_VARIABLE_CACHE;
    }

    protected final int getInteropCacheLimit() {
        return this.getLanguage().options.METHOD_LOOKUP_CACHE;
    }
}

