/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language;

import com.oracle.truffle.api.CompilerDirectives;
import org.truffleruby.core.module.RubyModule;

public final class LexicalScope {
    public static final LexicalScope NONE = null;
    public static final LexicalScope IGNORE = new LexicalScope(null, null);
    private final LexicalScope parent;
    public final boolean ignoreForClassVariablesLookup;
    @CompilerDirectives.CompilationFinal
    private volatile RubyModule liveModule;

    public LexicalScope(LexicalScope parent, RubyModule liveModule) {
        this(parent, liveModule, false);
    }

    public LexicalScope(LexicalScope parent, RubyModule liveModule, boolean ignoreForClassVariablesLookup) {
        this.parent = parent;
        this.liveModule = liveModule;
        this.ignoreForClassVariablesLookup = ignoreForClassVariablesLookup;
    }

    public LexicalScope(LexicalScope parent) {
        this(parent, null);
    }

    public LexicalScope getParent() {
        return this.parent;
    }

    public RubyModule getLiveModule() {
        return this.liveModule;
    }

    public void unsafeSetLiveModule(RubyModule liveModule) {
        RubyModule previous = this.liveModule;
        if (previous == null) {
            this.liveModule = liveModule;
        } else if (previous != liveModule) {
            throw CompilerDirectives.shouldNotReachHere((String)("Overriding module for static LexicalScope, old=" + LexicalScope.moduleToDebugString(previous) + ", new=" + LexicalScope.moduleToDebugString(liveModule)));
        }
    }

    private static String moduleToDebugString(RubyModule module) {
        return String.valueOf(module) + "@" + Integer.toHexString(module.hashCode());
    }

    public String toString() {
        return " :: " + String.valueOf(this.liveModule) + (this.parent == null ? "" : this.parent.toString());
    }
}

