/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.truffleruby.RubyContext;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringOperations;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.parser.RubyDeferredWarnings;

public final class EmitWarningsNode
extends RubyContextSourceNode {
    public final RubyDeferredWarnings warnings;

    public EmitWarningsNode(RubyDeferredWarnings warnings) {
        this.warnings = warnings;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        RubyContext context = this.getContext();
        this.printWarnings(context);
        return nil;
    }

    public void printWarnings(RubyContext context) {
        EmitWarningsNode.printWarnings(context, this.warnings);
    }

    @CompilerDirectives.TruffleBoundary
    public static void printWarnings(RubyContext context, RubyDeferredWarnings warnings) {
        if (context == null) {
            for (RubyDeferredWarnings.WarningMessage warningMessage : warnings.warnings) {
                System.err.println(warningMessage.getWarningMessage());
            }
        } else {
            boolean isVerbose = context.getCoreLibrary().isVerbose();
            boolean warningsEnabled = context.getCoreLibrary().warningsEnabled();
            for (RubyDeferredWarnings.WarningMessage warningMessage : warnings.warnings) {
                if (warningMessage.verbosity == RubyDeferredWarnings.Verbosity.VERBOSE) {
                    if (!isVerbose) continue;
                    EmitWarningsNode.printWarning(context, warningMessage.getWarningMessage());
                    continue;
                }
                if (!warningsEnabled) continue;
                EmitWarningsNode.printWarning(context, warningMessage.getWarningMessage());
            }
        }
    }

    private static void printWarning(RubyContext context, String message) {
        if (context.getCoreLibrary().isLoaded()) {
            RubyModule warning = context.getCoreLibrary().warningModule;
            RubyString messageString = StringOperations.createUTF8String(context, context.getLanguageSlow(), message);
            DispatchNode.getUncached().call((Object)warning, "warn", (Object)messageString);
        } else {
            try {
                context.getEnvErrStream().write(message.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new RaiseException(context, context.getCoreExceptions().ioError(e, null));
            }
        }
    }

    @Override
    public RubyNode cloneUninitialized() {
        EmitWarningsNode copy = new EmitWarningsNode(this.warnings);
        return copy.copyFlags(this);
    }
}

