/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import java.util.concurrent.locks.ReentrantLock;
import org.truffleruby.RubyContext;
import org.truffleruby.core.mutex.MutexOperations;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.library.RubyStringLibrary;

public final class AutoloadConstant {
    private final Object feature;
    private final String autoloadPath;
    private volatile ReentrantLock autoloadLock;

    AutoloadConstant(Object feature) {
        assert (RubyStringLibrary.isRubyStringUncached(feature));
        this.feature = feature;
        this.autoloadPath = RubyGuards.getJavaString(this.feature);
    }

    public String getAutoloadPath() {
        return this.autoloadPath;
    }

    public Object getFeature() {
        return this.feature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReentrantLock getAutoloadLock() {
        AutoloadConstant autoloadConstant = this;
        synchronized (autoloadConstant) {
            if (this.autoloadLock == null) {
                this.autoloadLock = new ReentrantLock();
            }
        }
        return this.autoloadLock;
    }

    @CompilerDirectives.TruffleBoundary
    public void startAutoLoad(RubyContext context, Node currentNode) {
        MutexOperations.lockInternal(context, this.getAutoloadLock(), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public void stopAutoLoad() {
        this.getAutoloadLock().unlock();
    }

    public boolean isAutoloading() {
        return this.autoloadLock != null && this.autoloadLock.isLocked();
    }

    public boolean isAutoloadingThread() {
        return this.autoloadLock != null && this.autoloadLock.isHeldByCurrentThread();
    }
}

