/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.interop;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.interop.TranslateInteropExceptionNode;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.control.RaiseException;

@GenerateUncached
@GenerateCached(value=false)
@GenerateInline
public abstract class ToJavaStringNode
extends RubyBaseNode {
    public abstract String execute(Node var1, Object var2);

    @Specialization(guards={"interopLibrary.isString(value)"}, limit="getLimit()")
    static String interopString(Node node, Object value, @CachedLibrary(value="value") InteropLibrary interopLibrary, @Cached TranslateInteropExceptionNode translateInteropException) {
        try {
            return interopLibrary.asString(value);
        }
        catch (UnsupportedMessageException e) {
            throw translateInteropException.execute(node, (InteropException)((Object)e));
        }
    }

    @Specialization(guards={"!interopLibrary.isString(value)"}, limit="getLimit()")
    static String notInteropString(Node node, Object value, @CachedLibrary(value="value") InteropLibrary interopLibrary) {
        throw new RaiseException(ToJavaStringNode.getContext(node), ToJavaStringNode.coreExceptions(node).typeError("This interop message requires a String or Symbol for the member name", node));
    }

    protected int getLimit() {
        return this.getLanguage().options.INTEROP_CONVERT_CACHE;
    }
}

