/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.thread.ThreadBacktraceLocationNodes;
import org.truffleruby.interop.RubySourceLocation;

@CoreModule(value="Truffle::Interop::SourceLocation", isClass=true)
public abstract class SourceLocationNodes {

    @CoreMethod(names={"language"})
    public static abstract class LanguageNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyString language(RubySourceLocation location, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            return this.createString(fromJavaStringNode, location.sourceSection.getSource().getLanguage(), Encodings.UTF_8);
        }
    }

    @CoreMethod(names={"internal?"})
    public static abstract class IsInternalNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        boolean isInternal(RubySourceLocation location) {
            return location.sourceSection.getSource().isInternal();
        }
    }

    @CoreMethod(names={"available?"})
    public static abstract class IsAvailableNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        boolean isAvailable(RubySourceLocation location) {
            return location.sourceSection.isAvailable();
        }
    }

    @CoreMethod(names={"last_column"})
    public static abstract class LastColumnNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        int lastCol(RubySourceLocation location) {
            return location.sourceSection.getEndColumn();
        }
    }

    @CoreMethod(names={"first_column"})
    public static abstract class FirstColumnNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        int firstCol(RubySourceLocation location) {
            return location.sourceSection.getStartColumn();
        }
    }

    @CoreMethod(names={"last_lineno"})
    public static abstract class LastLinenoNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        int lastLine(RubySourceLocation location) {
            return location.sourceSection.getEndLine();
        }
    }

    @CoreMethod(names={"first_lineno", "lineno"})
    public static abstract class LinenoNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        int lineno(RubySourceLocation location) {
            return location.sourceSection.getStartLine();
        }
    }

    @CoreMethod(names={"path"})
    public static abstract class PathNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyString path(RubySourceLocation location) {
            SourceSection sourceSection = location.sourceSection;
            if (!sourceSection.isAvailable()) {
                return this.coreStrings().UNKNOWN.createInstance(this.getContext());
            }
            TruffleString path = this.getLanguage().getPathToTStringCache().getCachedPath(sourceSection.getSource());
            return this.createString(path, Encodings.UTF_8);
        }
    }

    @CoreMethod(names={"absolute_path"})
    public static abstract class AbsolutePathNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object absolutePath(RubySourceLocation location) {
            SourceSection sourceSection = location.sourceSection;
            if (!sourceSection.isAvailable()) {
                return this.coreStrings().UNKNOWN.createInstance(this.getContext());
            }
            return ThreadBacktraceLocationNodes.AbsolutePathNode.getAbsolutePath(sourceSection, this);
        }
    }
}

