/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.extra;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.collections.ConcurrentOperations;
import org.truffleruby.collections.SimpleEntry;
import org.truffleruby.core.basicobject.ReferenceEqualNode;
import org.truffleruby.core.hash.HashingNodes;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.extra.RubyConcurrentMap;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.objects.AllocationTracing;
import org.truffleruby.language.objects.shared.PropagateSharingNode;
import org.truffleruby.language.yield.CallBlockNode;

@CoreModule(value="TruffleRuby::ConcurrentMap", isClass=true)
public abstract class ConcurrentMapNodes {
    @CompilerDirectives.TruffleBoundary
    private static Object get(ConcurrentHashMap<RubyConcurrentMap.Key, Object> map, RubyConcurrentMap.Key key) {
        return map.get(key);
    }

    @CoreMethod(names={"each_pair"}, needsBlock=true)
    public static abstract class EachPairNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object eachPair(RubyConcurrentMap self, RubyProc block, @Cached CallBlockNode yieldNode) {
            SimpleEntry<RubyConcurrentMap.Key, Object> pair;
            Iterator<Map.Entry<RubyConcurrentMap.Key, Object>> iterator = EachPairNode.iterator(self.getMap());
            while ((pair = EachPairNode.next(iterator)) != null) {
                yieldNode.yield(this, block, pair.getKey().key, pair.getValue());
            }
            return self;
        }

        @CompilerDirectives.TruffleBoundary
        private static Iterator<Map.Entry<RubyConcurrentMap.Key, Object>> iterator(ConcurrentHashMap<RubyConcurrentMap.Key, Object> map) {
            return map.entrySet().iterator();
        }

        @CompilerDirectives.TruffleBoundary
        private static SimpleEntry<RubyConcurrentMap.Key, Object> next(Iterator<Map.Entry<RubyConcurrentMap.Key, Object>> iterator) {
            if (iterator.hasNext()) {
                Map.Entry<RubyConcurrentMap.Key, Object> entry = iterator.next();
                return new SimpleEntry<RubyConcurrentMap.Key, Object>(entry.getKey(), entry.getValue());
            }
            return null;
        }
    }

    @CoreMethod(names={"get_or_default"}, required=2)
    public static abstract class GetOrDefaultNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object getOrDefault(RubyConcurrentMap self, Object key, Object defaultValue, @Cached HashingNodes.ToHashByHashCode hashNode) {
            int hashCode = hashNode.execute(this, key);
            return GetOrDefaultNode.getOrDefault(self.getMap(), new RubyConcurrentMap.Key(key, hashCode), defaultValue);
        }

        @CompilerDirectives.TruffleBoundary
        private static Object getOrDefault(ConcurrentHashMap<RubyConcurrentMap.Key, Object> map, RubyConcurrentMap.Key key, Object defaultValue) {
            return map.getOrDefault(key, defaultValue);
        }
    }

    @CoreMethod(names={"size"})
    public static abstract class SizeNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        int size(RubyConcurrentMap self) {
            return self.getMap().size();
        }
    }

    @CoreMethod(names={"clear"})
    public static abstract class ClearNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyConcurrentMap clear(RubyConcurrentMap self) {
            self.getMap().clear();
            return self;
        }
    }

    @CoreMethod(names={"delete"}, required=1)
    public static abstract class DeleteNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object delete(RubyConcurrentMap self, Object key, @Cached HashingNodes.ToHashByHashCode hashNode) {
            int hashCode = hashNode.execute(this, key);
            return DeleteNode.nullToNil(DeleteNode.remove(self.getMap(), new RubyConcurrentMap.Key(key, hashCode)));
        }

        @CompilerDirectives.TruffleBoundary
        private static Object remove(ConcurrentHashMap<RubyConcurrentMap.Key, Object> map, RubyConcurrentMap.Key key) {
            return map.remove(key);
        }
    }

    @CoreMethod(names={"key?"}, required=1)
    public static abstract class KeyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean key(RubyConcurrentMap self, Object key, @Cached HashingNodes.ToHashByHashCode hashNode) {
            int hashCode = hashNode.execute(this, key);
            return KeyNode.containsKey(self.getMap(), new RubyConcurrentMap.Key(key, hashCode));
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean containsKey(ConcurrentHashMap<RubyConcurrentMap.Key, Object> map, RubyConcurrentMap.Key key) {
            return map.containsKey(key);
        }
    }

    @CoreMethod(names={"get_and_set"}, required=2)
    public static abstract class GetAndSetNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object getAndSet(RubyConcurrentMap self, Object key, Object value, @Cached HashingNodes.ToHashByHashCode hashNode, @Cached PropagateSharingNode propagateSharingKey, @Cached PropagateSharingNode propagateSharingValue) {
            int hashCode = hashNode.execute(this, key);
            propagateSharingKey.execute(this, self, key);
            propagateSharingValue.execute(this, self, value);
            return GetAndSetNode.nullToNil(GetAndSetNode.put(self.getMap(), new RubyConcurrentMap.Key(key, hashCode), value));
        }

        @CompilerDirectives.TruffleBoundary
        private static Object put(ConcurrentHashMap<RubyConcurrentMap.Key, Object> map, RubyConcurrentMap.Key key, Object value) {
            return map.put(key, value);
        }
    }

    @CoreMethod(names={"replace_if_exists"}, required=2)
    public static abstract class ReplaceIfExistsNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object replaceIfExists(RubyConcurrentMap self, Object key, Object newValue, @Cached HashingNodes.ToHashByHashCode hashNode, @Cached PropagateSharingNode propagateSharingValue) {
            int hashCode = hashNode.execute(this, key);
            propagateSharingValue.execute(this, self, newValue);
            return ReplaceIfExistsNode.nullToNil(ReplaceIfExistsNode.replace(self.getMap(), new RubyConcurrentMap.Key(key, hashCode), newValue));
        }

        @CompilerDirectives.TruffleBoundary
        private static Object replace(ConcurrentHashMap<RubyConcurrentMap.Key, Object> map, RubyConcurrentMap.Key key, Object newValue) {
            return map.replace(key, newValue);
        }
    }

    @CoreMethod(names={"delete_pair"}, required=2)
    public static abstract class DeletePairNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean deletePair(RubyConcurrentMap self, Object key, Object expectedValue, @Cached HashingNodes.ToHashByHashCode hashNode, @Cached ReferenceEqualNode equalNode, @Cached InlinedConditionProfile isPrimitiveProfile) {
            int hashCode = hashNode.execute(this, key);
            if (isPrimitiveProfile.profile((Node)this, RubyGuards.isPrimitive(expectedValue))) {
                return this.deletePairPrimitive(self, key, expectedValue, hashCode, equalNode);
            }
            return DeletePairNode.remove(self.getMap(), new RubyConcurrentMap.Key(key, hashCode), expectedValue);
        }

        private boolean deletePairPrimitive(RubyConcurrentMap self, Object key, Object expectedValue, int hashCode, ReferenceEqualNode equalNode) {
            Object currentValue;
            RubyConcurrentMap.Key keyWrapper = new RubyConcurrentMap.Key(key, hashCode);
            while (RubyGuards.isPrimitive(currentValue = ConcurrentMapNodes.get(self.getMap(), keyWrapper)) && equalNode.execute(this, expectedValue, currentValue)) {
                if (!DeletePairNode.remove(self.getMap(), keyWrapper, currentValue)) continue;
                return true;
            }
            return false;
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean remove(ConcurrentHashMap<RubyConcurrentMap.Key, Object> map, RubyConcurrentMap.Key key, Object expectedValue) {
            return map.remove(key, expectedValue);
        }
    }

    @CoreMethod(names={"replace_pair"}, required=3)
    public static abstract class ReplacePairNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean replacePair(RubyConcurrentMap self, Object key, Object expectedValue, Object newValue, @Cached HashingNodes.ToHashByHashCode hashNode, @Cached PropagateSharingNode propagateSharingValue, @Cached ReferenceEqualNode equalNode, @Cached InlinedConditionProfile isPrimitiveProfile) {
            int hashCode = hashNode.execute(this, key);
            if (isPrimitiveProfile.profile((Node)this, RubyGuards.isPrimitive(expectedValue))) {
                return this.replacePairPrimitive(self, key, expectedValue, newValue, hashCode, equalNode);
            }
            propagateSharingValue.execute(this, self, newValue);
            return ReplacePairNode.replace(self.getMap(), new RubyConcurrentMap.Key(key, hashCode), expectedValue, newValue);
        }

        private boolean replacePairPrimitive(RubyConcurrentMap self, Object key, Object expectedValue, Object newValue, int hashCode, ReferenceEqualNode equalNode) {
            Object currentValue;
            RubyConcurrentMap.Key keyWrapper = new RubyConcurrentMap.Key(key, hashCode);
            while (RubyGuards.isPrimitive(currentValue = ConcurrentMapNodes.get(self.getMap(), keyWrapper)) && equalNode.execute(this, expectedValue, currentValue)) {
                if (!ReplacePairNode.replace(self.getMap(), keyWrapper, currentValue, newValue)) continue;
                return true;
            }
            return false;
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean replace(ConcurrentHashMap<RubyConcurrentMap.Key, Object> map, RubyConcurrentMap.Key key, Object oldValue, Object newValue) {
            return map.replace(key, oldValue, newValue);
        }
    }

    @CoreMethod(names={"merge_pair"}, required=2, needsBlock=true)
    public static abstract class MergePairNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object mergePair(RubyConcurrentMap self, Object key, Object value, RubyProc block, @Cached HashingNodes.ToHashByHashCode hashNode, @Cached CallBlockNode yieldNode, @Cached PropagateSharingNode propagateSharingKey, @Cached PropagateSharingNode propagateSharingValue) {
            int hashCode = hashNode.execute(this, key);
            propagateSharingKey.execute(this, self, key);
            propagateSharingKey.execute(this, self, value);
            return MergePairNode.nullToNil(MergePairNode.merge(self.getMap(), new RubyConcurrentMap.Key(key, hashCode), value, (existingValue, newValue) -> MergePairNode.nilToNull(propagateSharingValue.propagate(this, self, yieldNode.yield(this, block, existingValue)))));
        }

        @CompilerDirectives.TruffleBoundary
        private static Object merge(ConcurrentHashMap<RubyConcurrentMap.Key, Object> map, RubyConcurrentMap.Key key, Object value, BiFunction<Object, Object, Object> remappingFunction) {
            return map.merge(key, value, remappingFunction);
        }
    }

    @CoreMethod(names={"compute"}, required=1, needsBlock=true)
    public static abstract class ComputeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object compute(RubyConcurrentMap self, Object key, RubyProc block, @Cached HashingNodes.ToHashByHashCode hashNode, @Cached CallBlockNode yieldNode, @Cached PropagateSharingNode propagateSharingKey, @Cached PropagateSharingNode propagateSharingValue) {
            int hashCode = hashNode.execute(this, key);
            propagateSharingKey.execute(this, self, key);
            return ComputeNode.nullToNil(ComputeNode.compute(self.getMap(), new RubyConcurrentMap.Key(key, hashCode), (k, v) -> {
                Object value = yieldNode.yield(this, block, ComputeNode.nullToNil(v));
                return ComputeNode.nilToNull(propagateSharingValue.propagate(this, self, value));
            }));
        }

        @CompilerDirectives.TruffleBoundary
        private static Object compute(ConcurrentHashMap<RubyConcurrentMap.Key, Object> map, RubyConcurrentMap.Key key, BiFunction<RubyConcurrentMap.Key, Object, Object> remappingFunction) {
            return map.compute(key, remappingFunction);
        }
    }

    @CoreMethod(names={"compute_if_present"}, required=1, needsBlock=true)
    public static abstract class ComputeIfPresentNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object computeIfPresent(RubyConcurrentMap self, Object key, RubyProc block, @Cached HashingNodes.ToHashByHashCode hashNode, @Cached CallBlockNode yieldNode, @Cached PropagateSharingNode propagateSharingValue) {
            int hashCode = hashNode.execute(this, key);
            return ComputeIfPresentNode.nullToNil(ComputeIfPresentNode.computeIfPresent(self.getMap(), new RubyConcurrentMap.Key(key, hashCode), (k, v) -> {
                Object value = yieldNode.yield(this, block, v);
                return ComputeIfPresentNode.nilToNull(propagateSharingValue.propagate(this, self, value));
            }));
        }

        @CompilerDirectives.TruffleBoundary
        private static Object computeIfPresent(ConcurrentHashMap<RubyConcurrentMap.Key, Object> map, RubyConcurrentMap.Key key, BiFunction<RubyConcurrentMap.Key, Object, Object> remappingFunction) {
            return map.computeIfPresent(key, remappingFunction);
        }
    }

    @CoreMethod(names={"compute_if_absent"}, required=1, needsBlock=true)
    public static abstract class ComputeIfAbsentNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object computeIfAbsent(RubyConcurrentMap self, Object key, RubyProc block, @Cached HashingNodes.ToHashByHashCode hashNode, @Cached CallBlockNode yieldNode, @Cached PropagateSharingNode propagateSharingKey, @Cached PropagateSharingNode propagateSharingValue) {
            int hashCode = hashNode.execute(this, key);
            propagateSharingKey.execute(this, self, key);
            Object returnValue = ConcurrentOperations.getOrCompute(self.getMap(), new RubyConcurrentMap.Key(key, hashCode), k -> propagateSharingValue.propagate(this, self, yieldNode.yield(this, block, new Object[0])));
            assert (returnValue != null);
            return returnValue;
        }
    }

    @CoreMethod(names={"[]="}, required=2)
    public static abstract class SetIndexNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object setIndex(RubyConcurrentMap self, Object key, Object value, @Cached HashingNodes.ToHashByHashCode hashNode, @Cached PropagateSharingNode propagateSharingKey, @Cached PropagateSharingNode propagateSharingValue) {
            int hashCode = hashNode.execute(this, key);
            propagateSharingKey.execute(this, self, key);
            propagateSharingValue.execute(this, self, value);
            SetIndexNode.put(self.getMap(), new RubyConcurrentMap.Key(key, hashCode), value);
            return value;
        }

        @CompilerDirectives.TruffleBoundary
        private static void put(ConcurrentHashMap<RubyConcurrentMap.Key, Object> map, RubyConcurrentMap.Key key, Object value) {
            map.put(key, value);
        }
    }

    @CoreMethod(names={"[]"}, required=1)
    public static abstract class GetIndexNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object getIndex(RubyConcurrentMap self, Object key, @Cached HashingNodes.ToHashByHashCode hashNode) {
            int hashCode = hashNode.execute(this, key);
            return GetIndexNode.nullToNil(ConcurrentMapNodes.get(self.getMap(), new RubyConcurrentMap.Key(key, hashCode)));
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        RubyConcurrentMap initializeCopy(RubyConcurrentMap self, RubyConcurrentMap other, @Cached PropagateSharingNode propagateSharingKey, @Cached PropagateSharingNode propagateSharingValue) {
            if (self.getMap() == null) {
                self.allocateMap(other.getMap().size(), 0.0f);
            }
            for (Map.Entry<RubyConcurrentMap.Key, Object> entry : other.getMap().entrySet()) {
                RubyConcurrentMap.Key keyObject = entry.getKey();
                Object value = entry.getValue();
                propagateSharingKey.execute(this, self, keyObject.key);
                propagateSharingValue.execute(this, self, value);
                self.getMap().put(keyObject, value);
            }
            return self;
        }
    }

    @Primitive(name="concurrent_map_initialize", lowerFixnum={1, 2})
    public static abstract class InitializeNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyConcurrentMap initializeWithOptions(RubyConcurrentMap self, int initialCapacity, int loadFactor) {
            return this.initializeWithOptions(self, initialCapacity, (double)loadFactor);
        }

        @Specialization
        RubyConcurrentMap initializeWithOptions(RubyConcurrentMap self, int initialCapacity, double loadFactor) {
            self.allocateMap(initialCapacity, (float)loadFactor);
            return self;
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyConcurrentMap allocate(RubyClass rubyClass) {
            Shape shape = this.getLanguage().concurrentMapShape;
            RubyConcurrentMap instance = new RubyConcurrentMap(rubyClass, shape);
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }
}

