/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.debug;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleStackTrace;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.StopIterationException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnknownKeyException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.TriState;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.graalvm.collections.Pair;
import org.prism.Nodes;
import org.prism.ParseResult;
import org.truffleruby.Layouts;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Split;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.CoreMethodNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.RubyHandle;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.ArrayHelpers;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.core.binding.BindingNodes;
import org.truffleruby.core.binding.RubyBinding;
import org.truffleruby.core.cast.ToCallTargetNode;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.core.method.RubyMethod;
import org.truffleruby.core.method.RubyUnboundMethod;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.debug.TruffleASTPrinter;
import org.truffleruby.extra.ffi.Pointer;
import org.truffleruby.interop.BoxedValue;
import org.truffleruby.interop.FromJavaStringNode;
import org.truffleruby.interop.ToJavaStringNode;
import org.truffleruby.language.CallStackManager;
import org.truffleruby.language.ImmutableRubyObject;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.backtrace.BacktraceFormatter;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.loader.ByteBasedCharSequence;
import org.truffleruby.language.methods.DeclarationContext;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.objects.AllocationTracing;
import org.truffleruby.language.objects.shared.IsSharedNode;
import org.truffleruby.language.objects.shared.SharedObjects;
import org.truffleruby.language.yield.CallBlockNode;
import org.truffleruby.parser.ParserContext;
import org.truffleruby.parser.RubySource;
import org.truffleruby.parser.TranslatorEnvironment;
import org.truffleruby.parser.YARPTranslatorDriver;

@CoreModule(value="Truffle::Debug")
public abstract class TruffleDebugNodes {

    @CoreMethod(names={"parse_public"}, onSingleton=true, required=3)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class ParsePublicNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(limit="storageStrategyLimit()")
        Object parsePublic(Object sourceCode, RubyArray parameters, RubyArray arguments, @Bind(value="parameters.getStore()") Object parametersStore, @Bind(value="arguments.getStore()") Object argumentsStore, @CachedLibrary(value="parametersStore") ArrayStoreLibrary parametersStores, @CachedLibrary(value="argumentsStore") ArrayStoreLibrary argumentsStores) {
            int i;
            String sourceCodeString = RubyGuards.getJavaString(sourceCode);
            String[] names = new String[parameters.size];
            Object[] values = new Object[arguments.size];
            for (i = 0; i < names.length; ++i) {
                Object name = parametersStores.read(parametersStore, i);
                names[i] = RubyGuards.getJavaString(name);
            }
            for (i = 0; i < values.length; ++i) {
                values[i] = argumentsStores.read(argumentsStore, i);
            }
            Source source = Source.newBuilder((String)"ruby", (CharSequence)sourceCodeString, (String)"parse_public.rb").build();
            TruffleLanguage.Env env = this.getContext().getEnv();
            CallTarget method = env.parsePublic(source, names);
            return method.call(values);
        }
    }

    @CoreMethod(names={"parse_and_dump_truffle_ast"}, onSingleton=true, required=4, lowerFixnum={3})
    public static abstract class ParseAndDumpTruffleASTNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object parseAndDump(Object sourceCode, Object focusedNodeClassName, int index, boolean mainScript, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            String nodeClassNameString = RubyGuards.getJavaString(focusedNodeClassName);
            TStringWithEncoding code = new TStringWithEncoding(RubyGuards.asTruffleStringUncached(sourceCode), RubyStringLibrary.getUncached().getEncoding(this, sourceCode));
            RubyRootNode rootNode = this.parse(code, mainScript);
            String output = TruffleASTPrinter.dump(rootNode, nodeClassNameString, index);
            return this.createString(fromJavaStringNode, output, Encodings.UTF_8);
        }

        private RubyRootNode parse(TStringWithEncoding sourceCode, boolean mainScript) {
            Source source = Source.newBuilder((String)"ruby", (CharSequence)new ByteBasedCharSequence(sourceCode), (String)"<parse_ast>").build();
            TranslatorEnvironment.resetTemporaryVariablesIndex();
            ParserContext parserContext = mainScript ? ParserContext.TOP_LEVEL_FIRST : ParserContext.TOP_LEVEL;
            RootCallTarget callTarget = this.getContext().getCodeLoader().parse(new RubySource(source, source.getName()), parserContext, null, this.getContext().getRootLexicalScope(), null);
            return RubyRootNode.of(callTarget);
        }
    }

    @CoreMethod(names={"multithreaded?"}, onSingleton=true)
    public static abstract class IsMultiThreadedNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isMultiThreaded() {
            return this.getLanguage().isMultiThreaded();
        }
    }

    @CoreMethod(names={"cexts_to_native_count"}, onSingleton=true)
    public static abstract class HandleCreationCountNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        long handleCount() {
            return this.getContext().getValueWrapperManager().totalHandleAllocations();
        }
    }

    @CoreMethod(names={"primitive_names"}, onSingleton=true)
    public static abstract class PrimitiveNamesNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray primitiveNames() {
            Set<String> primitives = this.getLanguage().primitiveManager.getPrimitiveNames();
            Object[] primitiveNames = ArrayUtils.map(primitives, FromJavaStringNode::executeUncached);
            return this.createArray(primitiveNames);
        }
    }

    @CoreMethod(names={"create_polyglot_thread"}, onSingleton=true, required=1)
    public static abstract class CreatePolyglotThread
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object parseName(Object hostRunnable) {
            Runnable runnable = (Runnable)this.getContext().getEnv().asHostObject(hostRunnable);
            Thread thread = this.getContext().getEnv().newTruffleThreadBuilder(runnable).build();
            return this.getContext().getEnv().asGuestValue((Object)thread);
        }
    }

    @CoreMethod(names={"parse_name_of_method"}, onSingleton=true, required=1)
    public static abstract class ParseNameOfMethodNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @Specialization
        RubyString parseName(RubyMethod method) {
            return this.parseName(method.method);
        }

        @Specialization
        RubyString parseName(RubyUnboundMethod method) {
            return this.parseName(method.method);
        }

        protected RubyString parseName(InternalMethod method) {
            String parseName = method.getSharedMethodInfo().getParseName();
            return this.createString(this.fromJavaStringNode, parseName, Encodings.UTF_8);
        }
    }

    @CoreMethod(names={"get_frame_bindings"}, onSingleton=true)
    public static abstract class IterateFrameBindingsNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray getFrameBindings() {
            ArrayDeque stack = new ArrayDeque();
            this.getContext().getCallStack().iterateFrameBindings(5, frameInstance -> {
                SourceSection encapsulatingSourceSection;
                RootNode rootNode = ((RootCallTarget)frameInstance.getCallTarget()).getRootNode();
                Node callNode = frameInstance.getCallNode();
                SourceSection sourceSection = encapsulatingSourceSection = callNode == null ? null : callNode.getEncapsulatingSourceSection();
                if (rootNode instanceof RubyRootNode && BacktraceFormatter.isAvailable(encapsulatingSourceSection)) {
                    MaterializedFrame frame = frameInstance.getFrame(FrameInstance.FrameAccess.MATERIALIZE).materialize();
                    assert (frame.getFrameDescriptor().getDefaultValue() == nil);
                    assert (CallStackManager.isRubyFrame((Frame)frame));
                    stack.push(Pair.create((Object)frame, (Object)encapsulatingSourceSection));
                } else {
                    stack.push(Pair.empty());
                }
                return null;
            });
            while (!stack.isEmpty() && ((Pair)stack.peek()).getRight() == null) {
                stack.pop();
            }
            ArrayList<Object> frameBindings = new ArrayList<Object>();
            SourceSection lastAvailableSourceSection = null;
            while (!stack.isEmpty()) {
                Pair frameAndSource = (Pair)stack.pop();
                MaterializedFrame frame = (MaterializedFrame)frameAndSource.getLeft();
                SourceSection source = (SourceSection)frameAndSource.getRight();
                if (frame != null) {
                    SourceSection sourceSection;
                    if (source != null) {
                        sourceSection = source;
                        lastAvailableSourceSection = source;
                    } else {
                        sourceSection = lastAvailableSourceSection;
                    }
                    RubyBinding binding = BindingNodes.createBinding(this.getContext(), this.getLanguage(), frame, sourceSection);
                    frameBindings.add(binding);
                    continue;
                }
                frameBindings.add(nil);
            }
            Collections.reverse(frameBindings);
            return this.createArray(frameBindings.toArray());
        }
    }

    @Primitive(name="frame_declaration_context_to_string")
    public static abstract class FrameDeclarationContextToStringNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @Specialization
        RubyString getDeclarationContextToString(VirtualFrame frame) {
            DeclarationContext declarationContext = RubyArguments.getDeclarationContext((Frame)frame);
            return this.createString(this.fromJavaStringNode, declarationContext.toString(), Encodings.UTF_8);
        }
    }

    @CoreMethod(names={"drain_finalization_queue"}, onSingleton=true)
    public static abstract class DrainFinalizationQueueNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object drainFinalizationQueue() {
            this.getContext().getFinalizationService().drainFinalizationQueue(this.getContext());
            return nil;
        }
    }

    @CoreMethod(names={"associated"}, onSingleton=true, required=1)
    public static abstract class AssociatedNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray associated(RubyString string) {
            DynamicObjectLibrary objectLibrary = DynamicObjectLibrary.getUncached();
            Pointer[] associated = (Pointer[])objectLibrary.getOrDefault((DynamicObject)string, (Object)Layouts.ASSOCIATED_IDENTIFIER, null);
            if (associated == null) {
                associated = Pointer.EMPTY_ARRAY;
            }
            long[] associatedValues = new long[associated.length];
            for (int n = 0; n < associated.length; ++n) {
                associatedValues[n] = associated[n].getAddress();
            }
            return ArrayHelpers.createArray(this.getContext(), this.getLanguage(), associatedValues);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray associated(ImmutableRubyString string) {
            return ArrayHelpers.createEmptyArray(this.getContext(), this.getLanguage());
        }
    }

    @CoreMethod(names={"long"}, onSingleton=true, required=1)
    public static abstract class LongNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        long asLong(int value) {
            return value;
        }

        @Specialization
        long asLong(long value) {
            return value;
        }
    }

    @CoreMethod(names={"foreign_boxed_value"}, onSingleton=true, required=1)
    public static abstract class ForeignBoxedNumberNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object foreignBoxedNumber(Object number) {
            return new BoxedValue(number);
        }
    }

    @CoreMethod(names={"foreign_exception"}, required=1, onSingleton=true)
    public static abstract class ForeignExceptionNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"strings.isRubyString(this, message)"}, limit="1")
        Object foreignException(Object message, @Cached RubyStringLibrary strings) {
            return new ForeignException(RubyGuards.getJavaString(message));
        }

        @ExportLibrary(value=InteropLibrary.class)
        public static final class ForeignException
        extends AbstractTruffleException {
            public ForeignException(String message) {
                super(message);
            }

            @ExportMessage
            protected boolean isException() {
                return true;
            }

            @ExportMessage
            public RuntimeException throwException() {
                throw this;
            }

            @ExportMessage
            protected String toDisplayString(boolean allowSideEffects) {
                return "[foreign exception]";
            }
        }
    }

    @CoreMethod(names={"foreign_string"}, onSingleton=true, required=1)
    public static abstract class ForeignStringNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"strings.isRubyString(this, string)"}, limit="1")
        Object foreignString(Object string, @Cached RubyStringLibrary strings) {
            return new ForeignString(RubyGuards.getJavaString(string));
        }

        @ExportLibrary(value=InteropLibrary.class)
        public static final class ForeignString
        implements TruffleObject {
            private final String string;

            public ForeignString(String string) {
                this.string = string;
            }

            @ExportMessage
            protected boolean isString() {
                return true;
            }

            @ExportMessage
            protected String asString() {
                return this.string;
            }

            @ExportMessage
            protected String toDisplayString(boolean allowSideEffects) {
                return "[foreign string]";
            }
        }
    }

    @CoreMethod(names={"foreign_identity_function"}, onSingleton=true)
    public static abstract class ForeignIdentityFunctionNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object foreignIdentityFunction() {
            return new ForeignIdentityFunction();
        }

        @ExportLibrary(value=InteropLibrary.class)
        public static final class ForeignIdentityFunction
        implements TruffleObject {
            @ExportMessage
            protected final boolean isExecutable() {
                return true;
            }

            @ExportMessage
            protected final Object execute(Object[] args) {
                return args[0];
            }
        }
    }

    @CoreMethod(names={"foreign_executable"}, required=1, onSingleton=true)
    public static abstract class ForeignExecutableNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object foreignExecutable(Object value) {
            return new ForeignExecutable(value);
        }

        @ExportLibrary(value=InteropLibrary.class)
        public static final class ForeignExecutable
        implements TruffleObject {
            private final Object value;

            public ForeignExecutable(Object value) {
                this.value = value;
            }

            @ExportMessage
            protected boolean isExecutable() {
                return true;
            }

            @ExportMessage
            protected Object execute(Object ... arguments) {
                return this.value;
            }

            @ExportMessage
            protected String toDisplayString(boolean allowSideEffects) {
                return "[foreign executable]";
            }
        }
    }

    @CoreMethod(names={"foreign_hash"}, onSingleton=true)
    public static abstract class ForeignHashNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object foreignHash() {
            return new ForeignHash(this.getSymbol("a"), 1, this.getSymbol("b"), 2);
        }

        @ExportLibrary(value=InteropLibrary.class)
        public static final class ForeignHash
        implements TruffleObject {
            private final RubySymbol key1;
            private final int value1;
            private final RubySymbol key2;
            private final int value2;

            public ForeignHash(RubySymbol key1, int value1, RubySymbol key2, int value2) {
                this.key1 = key1;
                this.value1 = value1;
                this.key2 = key2;
                this.value2 = value2;
            }

            @ExportMessage
            protected boolean hasHashEntries() {
                return true;
            }

            @ExportMessage
            protected long getHashSize() {
                return 2L;
            }

            @CompilerDirectives.TruffleBoundary
            @ExportMessage
            protected boolean isHashEntryReadable(Object key) {
                return key == this.key1 || key == this.key2;
            }

            @CompilerDirectives.TruffleBoundary
            @ExportMessage
            protected Object readHashValue(Object key) throws UnknownKeyException {
                if (key == this.key1) {
                    return this.value1;
                }
                if (key == this.key2) {
                    return this.value2;
                }
                throw UnknownKeyException.create((Object)key);
            }

            @ExportMessage
            protected Object getHashEntriesIterator() {
                return new ForeignHashEntriesIterator(this);
            }

            @ExportMessage
            protected String toDisplayString(boolean allowSideEffects) {
                return "[foreign hash]";
            }
        }

        @ExportLibrary(value=InteropLibrary.class)
        public static final class ForeignHashEntriesIterator
        implements TruffleObject {
            final ForeignHash foreignHash;
            int index = 0;

            public ForeignHashEntriesIterator(ForeignHash foreignHash) {
                this.foreignHash = foreignHash;
            }

            @ExportMessage
            protected boolean isIterator() {
                return true;
            }

            @ExportMessage
            protected boolean hasIteratorNextElement() {
                return this.index < 2;
            }

            @CompilerDirectives.TruffleBoundary
            @ExportMessage
            protected Object getIteratorNextElement() throws StopIterationException {
                if (this.index == 0) {
                    ++this.index;
                    return new ForeignArrayNode.ForeignArray(this.foreignHash.key1, this.foreignHash.value1);
                }
                if (this.index == 1) {
                    ++this.index;
                    return new ForeignArrayNode.ForeignArray(this.foreignHash.key2, this.foreignHash.value2);
                }
                throw StopIterationException.create();
            }

            @ExportMessage
            protected String toDisplayString(boolean allowSideEffects) {
                return "[foreign hash entries iterator]";
            }
        }
    }

    @CoreMethod(names={"foreign_iterator_iterable"}, onSingleton=true)
    public static abstract class ForeignIteratorIterableNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object foreignIteratorIterable() {
            return new ForeignIteratorIterable();
        }

        @ExportLibrary(value=InteropLibrary.class)
        public static final class ForeignIteratorIterable
        implements TruffleObject {
            final int[] values = new int[]{1, 2, 3};
            int index = 0;

            @ExportMessage
            protected boolean hasIterator() {
                return true;
            }

            @ExportMessage
            protected Object getIterator() {
                return this;
            }

            @ExportMessage
            protected boolean isIterator() {
                return true;
            }

            @ExportMessage
            protected boolean hasIteratorNextElement() {
                return this.index < this.values.length;
            }

            @CompilerDirectives.TruffleBoundary
            @ExportMessage
            protected Object getIteratorNextElement() throws StopIterationException {
                if (this.hasIteratorNextElement()) {
                    Integer value = this.values[this.index];
                    ++this.index;
                    return value;
                }
                throw StopIterationException.create();
            }

            @ExportMessage
            protected String toDisplayString(boolean allowSideEffects) {
                return "[foreign iterator iterable]";
            }
        }
    }

    @CoreMethod(names={"foreign_iterable"}, onSingleton=true)
    public static abstract class ForeignIterableNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object foreignIterable() {
            return new ForeignIterable();
        }

        @ExportLibrary(value=InteropLibrary.class)
        public static final class ForeignIterable
        implements TruffleObject {
            @ExportMessage
            protected boolean hasIterator() {
                return true;
            }

            @ExportMessage
            protected Object getIterator() {
                return new ForeignIteratorNode.ForeignIterator();
            }

            @ExportMessage
            protected String toDisplayString(boolean allowSideEffects) {
                return "[foreign iterable]";
            }
        }
    }

    @CoreMethod(names={"foreign_iterator"}, onSingleton=true)
    public static abstract class ForeignIteratorNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object foreignIterator() {
            return new ForeignIterator();
        }

        @ExportLibrary(value=InteropLibrary.class)
        public static final class ForeignIterator
        implements TruffleObject {
            final int[] values = new int[]{1, 2, 3};
            int index = 0;

            @ExportMessage
            protected boolean isIterator() {
                return true;
            }

            @ExportMessage
            protected boolean hasIteratorNextElement() {
                return this.index < this.values.length;
            }

            @CompilerDirectives.TruffleBoundary
            @ExportMessage
            protected Object getIteratorNextElement() throws StopIterationException {
                if (this.hasIteratorNextElement()) {
                    Integer value = this.values[this.index];
                    ++this.index;
                    return value;
                }
                throw StopIterationException.create();
            }

            @ExportMessage
            protected String toDisplayString(boolean allowSideEffects) {
                return "[foreign iterator]";
            }
        }
    }

    @CoreMethod(names={"foreign_pointer_array"}, onSingleton=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class ForeignPointerArrayNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object foreignPointerArray() {
            return new ForeignPointerArray(1, 2, 3);
        }

        @ExportLibrary(value=InteropLibrary.class)
        public static final class ForeignPointerArray
        extends ForeignArrayNode.ForeignArray {
            public ForeignPointerArray(Object ... values) {
                super(values);
            }

            @ExportMessage
            protected boolean isPointer() {
                return true;
            }

            @ExportMessage
            protected long asPointer() {
                return 0L;
            }

            @Override
            @ExportMessage
            protected String toDisplayString(boolean allowSideEffects) {
                return "[foreign pointer array]";
            }
        }
    }

    @CoreMethod(names={"foreign_array"}, onSingleton=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class ForeignArrayNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object foreignArray() {
            return new ForeignArray(1, 2, 3);
        }

        @ExportLibrary(value=InteropLibrary.class)
        public static class ForeignArray
        implements TruffleObject {
            private final Object[] array;

            public ForeignArray(Object ... values) {
                this.array = values;
            }

            @ExportMessage
            protected boolean hasArrayElements() {
                return true;
            }

            @ExportMessage.Repeat(value={@ExportMessage(name="isArrayElementReadable"), @ExportMessage(name="isArrayElementModifiable")})
            protected boolean isArrayElement(long index) {
                return 0L >= index && index < (long)this.array.length;
            }

            @CompilerDirectives.TruffleBoundary
            @ExportMessage
            protected Object readArrayElement(long index) throws InvalidArrayIndexException {
                try {
                    return this.array[(int)index];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw InvalidArrayIndexException.create((long)index);
                }
            }

            @CompilerDirectives.TruffleBoundary
            @ExportMessage
            protected void writeArrayElement(long index, Object value) throws InvalidArrayIndexException {
                try {
                    this.array[(int)index] = value;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw InvalidArrayIndexException.create((long)index);
                }
            }

            @ExportMessage
            protected final boolean isArrayElementInsertable(long index) {
                return false;
            }

            @ExportMessage
            protected long getArraySize() {
                return this.array.length;
            }

            @ExportMessage
            protected String toDisplayString(boolean allowSideEffects) {
                return "[foreign array]";
            }
        }
    }

    @CoreMethod(names={"foreign_object_with_members"}, onSingleton=true)
    public static abstract class ForeignObjectWithMembersNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object foreignObjectWithMembers() {
            return new ForeignObjectWithMembers();
        }

        @ExportLibrary(value=InteropLibrary.class)
        public static final class ForeignObjectWithMembers
        implements TruffleObject {
            private final Map<String, Object> map = new HashMap<String, Object>();

            public ForeignObjectWithMembers() {
                this.map.put("a", 1);
                this.map.put("b", 2);
                this.map.put("c", 3);
            }

            @ExportMessage
            protected boolean hasMembers() {
                return true;
            }

            @ExportMessage
            @CompilerDirectives.TruffleBoundary
            protected Object getMembers(boolean includeInternal) {
                return new ForeignArrayNode.ForeignArray("a", "b", "c", "method1", "method2");
            }

            @CompilerDirectives.TruffleBoundary
            @ExportMessage
            protected boolean isMemberReadable(String member) {
                return this.map.containsKey(member) || this.isMemberInvocable(member);
            }

            @CompilerDirectives.TruffleBoundary
            @ExportMessage
            protected boolean isMemberInvocable(String member) {
                return "method1".equals(member) || "method2".equals(member);
            }

            @CompilerDirectives.TruffleBoundary
            @ExportMessage
            protected Object readMember(String member) throws UnknownIdentifierException {
                if (member.equals("method1")) {
                    return new ForeignExecutableNode.ForeignExecutable(42);
                }
                if (member.equals("method2")) {
                    return new ForeignExecutableNode.ForeignExecutable(44);
                }
                Object value = this.map.get(member);
                if (value == null) {
                    throw UnknownIdentifierException.create((String)member);
                }
                return value;
            }

            @CompilerDirectives.TruffleBoundary
            @ExportMessage
            protected Object invokeMember(String member, Object[] arguments) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                if (!this.isMemberInvocable(member)) {
                    throw UnknownIdentifierException.create((String)member);
                }
                return InteropLibrary.getUncached().execute(this.readMember("method1"), new Object[0]);
            }

            @ExportMessage
            protected String toDisplayString(boolean allowSideEffects) {
                return "[foreign object with members]";
            }
        }
    }

    @CoreMethod(names={"foreign_object"}, onSingleton=true)
    public static abstract class ForeignObjectNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object foreignObject() {
            return new ForeignObject();
        }

        @ExportLibrary(value=InteropLibrary.class)
        public static final class ForeignObject
        implements TruffleObject {
            @ExportMessage
            protected TriState isIdenticalOrUndefined(Object other) {
                return other instanceof ForeignObject ? TriState.valueOf((this == other ? 1 : 0) != 0) : TriState.UNDEFINED;
            }

            @ExportMessage
            protected int identityHashCode() {
                return System.identityHashCode(this);
            }

            @ExportMessage
            protected String toDisplayString(boolean allowSideEffects) {
                return "[foreign object]";
            }
        }
    }

    @CoreMethod(names={"foreign_pointer"}, required=1, onSingleton=true)
    public static abstract class ForeignPointerNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object foreignPointer(long address) {
            return new ForeignPointer(address);
        }

        @ExportLibrary(value=InteropLibrary.class)
        public static final class ForeignPointer
        implements TruffleObject {
            private final long address;

            public ForeignPointer(long address) {
                this.address = address;
            }

            @ExportMessage
            protected boolean isPointer() {
                return true;
            }

            @ExportMessage
            protected long asPointer() {
                return this.address;
            }

            @ExportMessage
            protected String toDisplayString(boolean allowSideEffects) {
                return "[foreign pointer]";
            }
        }
    }

    @CoreMethod(names={"foreign_null"}, onSingleton=true)
    public static abstract class ForeignNullNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object foreignNull() {
            return new ForeignNull();
        }

        @ExportLibrary(value=InteropLibrary.class)
        public static final class ForeignNull
        implements TruffleObject {
            @ExportMessage
            protected boolean isNull() {
                return true;
            }

            @ExportMessage
            protected String toDisplayString(boolean allowSideEffects) {
                return "[foreign null]";
            }
        }
    }

    @CoreMethod(names={"java_character"}, onSingleton=true)
    public static abstract class JavaCharacterNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Character javaCharacter() {
            return Character.valueOf('C');
        }
    }

    @CoreMethod(names={"java_null"}, onSingleton=true)
    public static abstract class JavaNullNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object javaNull() {
            return this.getContext().getEnv().asGuestValue(null);
        }
    }

    @CoreMethod(names={"java_object"}, onSingleton=true)
    public static abstract class JavaObjectNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object javaObject() {
            return this.getContext().getEnv().asGuestValue((Object)new BigInteger("14"));
        }
    }

    @CoreMethod(names={"java_class"}, onSingleton=true)
    public static abstract class JavaClassNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object javaObject() {
            return this.getContext().getEnv().asGuestValue(BigInteger.class);
        }
    }

    @Primitive(name="assert")
    public static abstract class AssertPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object doAssert(boolean condition) {
            assert (condition);
            return nil;
        }
    }

    @CoreMethod(names={"assert"}, onSingleton=true, required=1)
    public static abstract class AssertNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object doAssert(boolean condition) {
            assert (condition);
            return nil;
        }
    }

    @CoreMethod(names={"throw_assertion_error"}, onSingleton=true, required=1)
    public static abstract class ThrowAssertionErrorNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"strings.isRubyString(this, message)"}, limit="1")
        Object throwAssertionError(Object message, @Cached RubyStringLibrary strings) {
            throw new AssertionError((Object)RubyGuards.getJavaString(message));
        }
    }

    @CoreMethod(names={"throw_java_exception_with_cause"}, onSingleton=true, required=1)
    public static abstract class ThrowJavaExceptionWithCauseNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"strings.isRubyString(this, message)"}, limit="1")
        Object throwJavaExceptionWithCause(Object message, @Cached RubyStringLibrary strings) {
            RuntimeException cause2 = new RuntimeException("cause 2");
            RuntimeException cause1 = new RuntimeException("cause 1", cause2);
            TruffleStackTrace.fillIn((Throwable)cause2);
            TruffleStackTrace.fillIn((Throwable)cause1);
            throw new RuntimeException(RubyGuards.getJavaString(message), cause1);
        }
    }

    @CoreMethod(names={"throw_java_exception"}, onSingleton=true, required=1)
    public static abstract class ThrowJavaExceptionNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"strings.isRubyString(this, message)"}, limit="1")
        Object throwJavaException(Object message, @Cached RubyStringLibrary strings) {
            ThrowJavaExceptionNode.callingMethod(RubyGuards.getJavaString(message));
            return nil;
        }

        private static void callingMethod(String message) {
            ThrowJavaExceptionNode.throwingMethod(message);
        }

        private static void throwingMethod(String message) {
            throw new RuntimeException(message);
        }
    }

    @CoreMethod(names={"log_config"}, onSingleton=true, required=1)
    public static abstract class LogConfigNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object logConfig(Object value, @Cached ToJavaStringNode toJavaStringNode) {
            LogConfigNode.config(toJavaStringNode.execute(this, value));
            return nil;
        }

        @CompilerDirectives.TruffleBoundary
        static void config(String message) {
            RubyLanguage.LOGGER.config(message);
        }
    }

    @CoreMethod(names={"log_info"}, onSingleton=true, required=1)
    public static abstract class LogInfoNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object logInfo(Object value, @Cached ToJavaStringNode toJavaStringNode) {
            LogInfoNode.info(toJavaStringNode.execute(this, value));
            return nil;
        }

        @CompilerDirectives.TruffleBoundary
        static void info(String message) {
            RubyLanguage.LOGGER.info(message);
        }
    }

    @CoreMethod(names={"log_warning"}, onSingleton=true, required=1)
    public static abstract class LogWarningNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object logWarning(Object value, @Cached ToJavaStringNode toJavaStringNode) {
            LogWarningNode.warning(toJavaStringNode.execute(this, value));
            return nil;
        }

        @CompilerDirectives.TruffleBoundary
        static void warning(String message) {
            RubyLanguage.LOGGER.warning(message);
        }
    }

    @CoreMethod(names={"shared?"}, onSingleton=true, required=1)
    @ImportStatic(value={SharedObjects.class})
    public static abstract class IsSharedCoreMethodNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isShared(RubyDynamicObject object, @Cached IsSharedNode isSharedNode) {
            return isSharedNode.execute(this, object);
        }

        @Specialization
        boolean isSharedImmutable(ImmutableRubyObject object) {
            return true;
        }
    }

    @CoreMethod(names={"hash_storage"}, onSingleton=true, required=1)
    public static abstract class HashStorageNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyString hashStorage(RubyHash hash) {
            Object store = hash.store;
            String storage = store == null ? "null" : store.getClass().toString();
            return this.createString(this.fromJavaStringNode, storage, Encodings.US_ASCII);
        }
    }

    @CoreMethod(names={"array_capacity"}, onSingleton=true, required=1)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class ArrayCapacityNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="storageStrategyLimit()")
        long arrayStorage(RubyArray array, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores) {
            return stores.capacity(store);
        }
    }

    @CoreMethod(names={"array_storage"}, onSingleton=true, required=1)
    public static abstract class ArrayStorageNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyString arrayStorage(RubyArray array) {
            String storage = ArrayStoreLibrary.getUncached().toString(array.getStore());
            return this.createString(this.fromJavaStringNode, storage, Encodings.US_ASCII);
        }
    }

    @CoreMethod(names={"shape"}, onSingleton=true, required=1)
    public static abstract class ShapeNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyString shape(RubyDynamicObject object) {
            return this.createString(this.fromJavaStringNode, object.getShape().toString(), Encodings.UTF_8);
        }
    }

    @CoreMethod(names={"ast_size"}, onSingleton=true, required=1)
    public static abstract class ASTSizeNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        int astSize(Object executable, @Cached ToCallTargetNode toCallTargetNode) {
            RootCallTarget callTarget = toCallTargetNode.execute(this, executable);
            return NodeUtil.countNodes((Node)callTarget.getRootNode());
        }
    }

    @CoreMethod(names={"print_source_sections"}, onSingleton=true, required=1)
    public static abstract class PrintSourceSectionsNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object printSourceSections(Object executable, @Cached ToCallTargetNode toCallTargetNode) {
            RootCallTarget callTarget = toCallTargetNode.execute(this, executable);
            NodeUtil.printSourceAttributionTree((OutputStream)this.getContext().getEnvErrStream(), (Node)callTarget.getRootNode());
            return nil;
        }
    }

    @CoreMethod(names={"print_ast"}, onSingleton=true, required=1)
    public static abstract class PrintASTNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object printAST(Object executable, @Cached ToCallTargetNode toCallTargetNode) {
            RootCallTarget callTarget = toCallTargetNode.execute(this, executable);
            NodeUtil.printCompactTree((OutputStream)this.getContext().getEnvErrStream(), (Node)callTarget.getRootNode());
            return nil;
        }
    }

    @CoreMethod(names={"ast"}, onSingleton=true, required=1)
    public static abstract class ASTNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object ast(Object executable, @Cached ToCallTargetNode toCallTargetNode) {
            RootCallTarget callTarget = toCallTargetNode.execute(this, executable);
            return this.ast((Node)callTarget.getRootNode());
        }

        private Object ast(Node node) {
            if (node == null) {
                return nil;
            }
            ArrayList<Object> array = new ArrayList<Object>();
            array.add(this.getSymbol(node.getClass().getSimpleName()));
            for (Node child : node.getChildren()) {
                array.add(this.ast(child));
            }
            return this.createArray(array.toArray());
        }
    }

    @CoreMethod(names={"profile_translator"}, onSingleton=true, required=2, lowerFixnum={2})
    public static abstract class ProfileTranslatorNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object profileTranslator(Object code, int repeat) {
            TStringWithEncoding codeString = new TStringWithEncoding(RubyGuards.asTruffleStringUncached(code), RubyStringLibrary.getUncached().getEncoding(this, code));
            RubySource rubySource = ParseASTNode.createRubySource(codeString);
            ParseResult parseResult = ParseASTNode.getParseResult(this.getLanguage(), rubySource);
            YARPTranslatorDriver translator = new YARPTranslatorDriver(this.getContext());
            for (int i = 0; i < repeat; ++i) {
                translator.parse(rubySource, ParserContext.TOP_LEVEL, null, null, this.getContext().getRootLexicalScope(), this, parseResult);
            }
            return nil;
        }
    }

    @CoreMethod(names={"parse_ast"}, onSingleton=true, required=1)
    public static abstract class ParseASTNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"strings.isRubyString(node, code)"}, limit="1")
        static Object ast(Object code, @Bind(value="this") Node node, @Cached RubyStringLibrary strings, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            TStringWithEncoding codeString = new TStringWithEncoding(RubyGuards.asTruffleStringUncached(code), RubyStringLibrary.getUncached().getEncoding(node, code));
            RubySource rubySource = ParseASTNode.createRubySource(codeString);
            ParseResult parseResult = ParseASTNode.getParseResult(ParseASTNode.getLanguage(node), rubySource);
            Nodes.Node ast = parseResult.value;
            return ParseASTNode.createString(node, fromJavaStringNode, ast.toString(), Encodings.UTF_8);
        }

        private static RubySource createRubySource(TStringWithEncoding code) {
            String name = "<parse_ast>";
            Source source = Source.newBuilder((String)"ruby", (CharSequence)new ByteBasedCharSequence(code), (String)name).build();
            return new RubySource(source, name);
        }

        private static ParseResult getParseResult(RubyLanguage language, RubySource rubySource) {
            String sourcePath = rubySource.getSourcePath(language).intern();
            return YARPTranslatorDriver.parseToYARPAST(rubySource, sourcePath, rubySource.getBytes(), Collections.emptyList(), language.options.FROZEN_STRING_LITERALS, null, ParserContext.TOP_LEVEL_FIRST);
        }
    }

    @CoreMethod(names={"print_backtrace"}, onSingleton=true)
    public static abstract class PrintBacktraceNode
    extends CoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object printBacktrace() {
            this.getContext().getDefaultBacktraceFormatter().printBacktraceOnEnvStderr(this);
            return nil;
        }
    }

    @CoreMethod(names={"java_class_of"}, onSingleton=true, required=1)
    public static abstract class JavaClassOfNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyString javaClassOf(Object value) {
            return this.createString(this.fromJavaStringNode, value.getClass().getSimpleName(), Encodings.UTF_8);
        }
    }

    @CoreMethod(names={"remove_handle"}, onSingleton=true, required=1)
    public static abstract class RemoveNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object remove(RubyHandle handle) {
            ((EventBinding)handle.object).dispose();
            return nil;
        }
    }

    @CoreMethod(names={"break_handle"}, onSingleton=true, required=2, needsBlock=true, split=Split.NEVER, lowerFixnum={2})
    public static abstract class BreakNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"strings.isRubyString(this, file)"}, limit="1")
        RubyHandle setBreak(Object file, int line, final RubyProc block, @Cached RubyStringLibrary strings) {
            String fileString = RubyGuards.getJavaString(file);
            SourceSectionFilter filter = SourceSectionFilter.newBuilder().mimeTypeIs(RubyLanguage.MIME_TYPES).sourceIs(source -> source != null && this.getLanguage().getSourcePath(source).equals(fileString)).lineIs(line).tagIs(new Class[]{StandardTags.StatementTag.class}).build();
            EventBinding breakpoint = this.getContext().getInstrumenter().attachExecutionEventFactory(filter, eventContext -> new ExecutionEventNode(this){
                @Node.Child
                private CallBlockNode yieldNode = CallBlockNode.create();
                final /* synthetic */ BreakNode this$0;
                {
                    this.this$0 = this$0;
                }

                protected void onEnter(VirtualFrame frame) {
                    this.yieldNode.yieldCached(block, BindingNodes.createBinding(this.this$0.getContext(), this.this$0.getLanguage(), frame.materialize(), eventContext.getInstrumentedSourceSection()));
                }
            });
            RubyHandle instance = new RubyHandle(this.coreLibrary().handleClass, this.getLanguage().handleShape, breakpoint);
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }

    @CoreMethod(names={"flatten_string"}, onSingleton=true, required=1)
    public static abstract class FlattenStringNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"libString.isRubyString(node, string)"}, limit="1")
        static RubyString flattenString(Object string, @Bind(value="this") Node node, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached RubyStringLibrary libString) {
            RubyEncoding rubyEncoding = libString.getEncoding(node, string);
            AbstractTruffleString tstring = libString.getTString(node, string);
            byte[] byteArray = TStringUtils.getBytesOrCopy(tstring, rubyEncoding);
            return FlattenStringNode.createString(node, fromByteArrayNode, byteArray, rubyEncoding);
        }
    }

    @CoreMethod(names={"tstring_to_debug_string"}, onSingleton=true, required=1)
    public static abstract class TStringToDebugPrintNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"strings.isRubyString(node, string)"}, limit="1")
        static RubyString toStringDebug(Object string, @Bind(value="this") Node node, @Cached RubyStringLibrary strings, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            return TStringToDebugPrintNode.createString(node, fromJavaStringNode, strings.getTString(node, string).toStringDebug(), Encodings.US_ASCII);
        }
    }

    @CoreMethod(names={"print"}, onSingleton=true, required=1)
    public static abstract class DebugPrintNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object debugPrint(Object string, @Cached RubyStringLibrary strings) {
            String javaString = strings.isRubyString(this, string) ? RubyGuards.getJavaString(string) : string.toString();
            this.getContext().getEnvErrStream().println(javaString);
            return nil;
        }
    }
}

