/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.debug;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.truffleruby.debug.VariableNamesObject;

@ExportLibrary(value=InteropLibrary.class)
public final class SingleMemberDescriptor
implements TruffleObject {
    private final String member;
    private final Object value;

    public SingleMemberDescriptor(String member, Object value) {
        this.member = member;
        this.value = value;
    }

    @ExportMessage
    protected boolean hasMembers() {
        return true;
    }

    @ExportMessage
    protected Object getMembers(boolean includeInternal) {
        return new VariableNamesObject(new String[]{this.member});
    }

    @ExportMessage
    protected boolean isMemberReadable(String member) {
        return this.member.equals(member);
    }

    @ExportMessage
    protected Object readMember(String member, @Cached InlinedBranchProfile errorProfile, @Bind(value="$node") Node node) throws UnknownIdentifierException {
        if (this.isMemberReadable(member)) {
            return this.value;
        }
        errorProfile.enter(node);
        throw UnknownIdentifierException.create((String)member);
    }
}

