/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.time;

import org.truffleruby.core.string.StringUtils;
import org.truffleruby.core.time.RubyDateFormatter;

public final class RubyTimeOutputFormatter {
    final String flags;
    final int width;
    public static final RubyTimeOutputFormatter DEFAULT_FORMATTER = new RubyTimeOutputFormatter("", 0);
    private static final int SMALLBUF = 100;

    public RubyTimeOutputFormatter(String flags, int width) {
        this.flags = flags;
        this.width = width;
    }

    public int getWidth(int defaultWidth) {
        if (this.flags.indexOf(45) != -1) {
            return 0;
        }
        return this.getWidthAlwaysPad(defaultWidth);
    }

    public int getWidthAlwaysPad(int defaultWidth) {
        return this.width != 0 ? this.width : defaultWidth;
    }

    public char getPadder(char defaultPadder) {
        int padder = defaultPadder;
        block5: for (int i = 0; i < this.flags.length(); ++i) {
            switch (this.flags.charAt(i)) {
                case '_': {
                    padder = 32;
                    continue block5;
                }
                case '0': {
                    padder = 48;
                    continue block5;
                }
                case '-': {
                    padder = 0;
                }
            }
        }
        return (char)padder;
    }

    public char getPadderAlwaysPad(char defaultPadder) {
        int padder = defaultPadder;
        block4: for (int i = 0; i < this.flags.length(); ++i) {
            switch (this.flags.charAt(i)) {
                case '_': {
                    padder = 32;
                    continue block4;
                }
                case '0': {
                    padder = 48;
                }
            }
        }
        return (char)padder;
    }

    public String format(String sequence, long value, RubyDateFormatter.FieldType type) {
        int width = this.getWidth(type.defaultWidth);
        char padder = this.getPadder(type.defaultPadder);
        sequence = sequence == null ? RubyTimeOutputFormatter.formatNumber(value, width, padder) : RubyTimeOutputFormatter.padding(sequence, width, padder);
        block4: for (int i = 0; i < this.flags.length(); ++i) {
            switch (this.flags.charAt(i)) {
                case '^': {
                    sequence = StringUtils.toUpperCase(sequence);
                    continue block4;
                }
                case '#': {
                    char last = sequence.charAt(sequence.length() - 1);
                    sequence = Character.isLowerCase(last) ? StringUtils.toUpperCase(sequence) : StringUtils.toLowerCase(sequence);
                }
            }
        }
        return sequence;
    }

    public static String formatNumber(long value, int width, char padder) {
        if (value >= 0L || padder != '0') {
            return RubyTimeOutputFormatter.padding(Long.toString(value), width, padder);
        }
        return "-" + RubyTimeOutputFormatter.padding(Long.toString(-value), width - 1, padder);
    }

    public static String formatSignedNumber(long value, int width, char padder) {
        if (padder == '0') {
            if (value >= 0L) {
                return "+" + RubyTimeOutputFormatter.padding(Long.toString(value), width - 1, padder);
            }
            return "-" + RubyTimeOutputFormatter.padding(Long.toString(-value), width - 1, padder);
        }
        if (value >= 0L) {
            return RubyTimeOutputFormatter.padding("+" + Long.toString(value), width, padder);
        }
        return RubyTimeOutputFormatter.padding(Long.toString(value), width, padder);
    }

    public boolean hasNoPaddingFlag() {
        return this.flags.contains("-");
    }

    static String padding(String sequence, int width, char padder) {
        if (sequence.length() >= width) {
            return sequence;
        }
        if (width > 100) {
            throw new IndexOutOfBoundsException("padding width " + width + " too large");
        }
        StringBuilder buf = new StringBuilder(width + sequence.length());
        for (int i = sequence.length(); i < width; ++i) {
            buf.append(padder);
        }
        buf.append(sequence);
        return buf.toString();
    }
}

