/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.time;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.text.DateFormatSymbols;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.exception.ErrnoErrorNode;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringOperations;
import org.truffleruby.core.string.TStringBuilder;
import org.truffleruby.core.string.TStringConstants;
import org.truffleruby.core.time.RubyTimeOutputFormatter;
import org.truffleruby.core.time.StrftimeLexer;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.backtrace.Backtrace;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.library.RubyStringLibrary;

public abstract class RubyDateFormatter {
    private static final DateFormatSymbols FORMAT_SYMBOLS = new DateFormatSymbols(Locale.US);
    private static final Token[] CONVERSION2TOKEN = new Token[256];
    public static final Token[] EMPTY_TOKEN_ARRAY = new Token[0];

    private static void addToPattern(List<Token> compiledPattern, String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') {
                compiledPattern.add(Token.format(c));
                continue;
            }
            compiledPattern.add(Token.str(Character.toString(c)));
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static Token[] compilePattern(AbstractTruffleString pattern, RubyEncoding encoding, boolean dateLibrary, RubyContext context, Node currentNode) {
        Token token;
        LinkedList<Token> compiledPattern = new LinkedList<Token>();
        if (!encoding.isAsciiCompatible) {
            throw new RaiseException(context, context.getCoreExceptions().argumentError("format should have ASCII compatible encoding", currentNode));
        }
        if (encoding != Encodings.BINARY) {
            compiledPattern.add(new Token(Format.FORMAT_ENCODING, encoding));
        }
        StrftimeLexer lexer = new StrftimeLexer(TStringUtils.toJavaStringOrThrow(pattern, encoding));
        block14: while ((token = lexer.yylex()) != null) {
            if (token.format != Format.FORMAT_SPECIAL) {
                compiledPattern.add(token);
                continue;
            }
            char c = ((Character)token.data).charValue();
            switch (c) {
                case 'c': {
                    RubyDateFormatter.addToPattern(compiledPattern, "a b e H:M:S Y");
                    continue block14;
                }
                case 'D': 
                case 'x': {
                    RubyDateFormatter.addToPattern(compiledPattern, "m/d/y");
                    continue block14;
                }
                case 'F': {
                    RubyDateFormatter.addToPattern(compiledPattern, "Y-m-d");
                    continue block14;
                }
                case 'n': {
                    compiledPattern.add(Token.str("\n"));
                    continue block14;
                }
                case 'Q': {
                    if (dateLibrary) {
                        compiledPattern.add(new Token(Format.FORMAT_MICROSEC_EPOCH));
                        continue block14;
                    }
                    compiledPattern.add(Token.str("%Q"));
                    continue block14;
                }
                case 'R': {
                    RubyDateFormatter.addToPattern(compiledPattern, "H:M");
                    continue block14;
                }
                case 'r': {
                    RubyDateFormatter.addToPattern(compiledPattern, "I:M:S p");
                    continue block14;
                }
                case 'T': 
                case 'X': {
                    RubyDateFormatter.addToPattern(compiledPattern, "H:M:S");
                    continue block14;
                }
                case 't': {
                    compiledPattern.add(Token.str("\t"));
                    continue block14;
                }
                case 'v': {
                    RubyDateFormatter.addToPattern(compiledPattern, "e-");
                    if (!dateLibrary) {
                        compiledPattern.add(Token.formatter(new RubyTimeOutputFormatter("^", 0)));
                    }
                    RubyDateFormatter.addToPattern(compiledPattern, "b-Y");
                    continue block14;
                }
                case 'Z': {
                    if (dateLibrary) {
                        compiledPattern.add(Token.zoneOffsetColons(1));
                        continue block14;
                    }
                    compiledPattern.add(new Token(Format.FORMAT_ZONE_ID));
                    continue block14;
                }
                case '+': {
                    if (!dateLibrary) {
                        compiledPattern.add(Token.str("%+"));
                        continue block14;
                    }
                    RubyDateFormatter.addToPattern(compiledPattern, "a b e H:M:S ");
                    compiledPattern.add(Token.zoneOffsetColons(1));
                    RubyDateFormatter.addToPattern(compiledPattern, " Y");
                    continue block14;
                }
            }
            throw new Error("Unknown special char: " + c);
        }
        return compiledPattern.toArray(EMPTY_TOKEN_ARRAY);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CompilerDirectives.TruffleBoundary
    public static TStringBuilder formatToTStringBuilder(Token[] compiledPattern, ZonedDateTime dt, Object zone, boolean isUtc, RubyContext context, RubyLanguage language, Node currentNode, ErrnoErrorNode errnoErrorNode) {
        RubyTimeOutputFormatter formatter = RubyTimeOutputFormatter.DEFAULT_FORMATTER;
        TStringBuilder toAppendTo = new TStringBuilder();
        Token[] tokenArray = compiledPattern;
        int n = tokenArray.length;
        int n2 = 0;
        while (true) {
            block48: {
                if (n2 >= n) {
                    return toAppendTo;
                }
                Token token = tokenArray[n2];
                String output = null;
                long value = 0L;
                FieldType type = FieldType.TEXT;
                Format format = token.getFormat();
                switch (format.ordinal()) {
                    case 0: {
                        toAppendTo.setEncoding((RubyEncoding)token.getData());
                        break block48;
                    }
                    case 2: {
                        formatter = (RubyTimeOutputFormatter)token.getData();
                        break block48;
                    }
                    case 1: {
                        output = (String)token.getData();
                        break;
                    }
                    case 4: {
                        int v = (dt.getDayOfWeek().getValue() + 1) % 8;
                        if (v == 0) {
                            ++v;
                        }
                        output = FORMAT_SYMBOLS.getWeekdays()[v];
                        break;
                    }
                    case 5: {
                        int v = (dt.getDayOfWeek().getValue() + 1) % 8;
                        if (v == 0) {
                            ++v;
                        }
                        output = FORMAT_SYMBOLS.getShortWeekdays()[v];
                        break;
                    }
                    case 6: {
                        output = FORMAT_SYMBOLS.getMonths()[dt.getMonthValue() - 1];
                        break;
                    }
                    case 7: {
                        output = FORMAT_SYMBOLS.getShortMonths()[dt.getMonthValue() - 1];
                        break;
                    }
                    case 9: {
                        type = FieldType.NUMERIC2;
                        value = dt.getDayOfMonth();
                        break;
                    }
                    case 10: {
                        type = FieldType.NUMERIC2BLANK;
                        value = dt.getDayOfMonth();
                        break;
                    }
                    case 13: {
                        type = FieldType.NUMERIC2;
                        value = dt.getHour();
                        break;
                    }
                    case 16: {
                        type = FieldType.NUMERIC2BLANK;
                        value = dt.getHour();
                        break;
                    }
                    case 14: 
                    case 18: {
                        value = dt.getHour();
                        if (value == 0L) {
                            value = 12L;
                        } else if (value > 12L) {
                            value -= 12L;
                        }
                        type = format == Format.FORMAT_HOUR_M ? FieldType.NUMERIC2 : FieldType.NUMERIC2BLANK;
                        break;
                    }
                    case 15: {
                        type = FieldType.NUMERIC3;
                        value = dt.getDayOfYear();
                        break;
                    }
                    case 19: {
                        type = FieldType.NUMERIC2;
                        value = dt.getMinute();
                        break;
                    }
                    case 20: {
                        type = FieldType.NUMERIC2;
                        value = dt.getMonthValue();
                        break;
                    }
                    case 23: {
                        output = dt.getHour() < 12 ? "AM" : "PM";
                        break;
                    }
                    case 22: {
                        output = dt.getHour() < 12 ? "am" : "pm";
                        break;
                    }
                    case 24: {
                        type = FieldType.NUMERIC2;
                        value = dt.getSecond();
                        break;
                    }
                    case 29: {
                        type = FieldType.NUMERIC2;
                        value = RubyDateFormatter.formatWeekOfYear(dt, 2);
                        break;
                    }
                    case 26: {
                        type = FieldType.NUMERIC2;
                        value = RubyDateFormatter.formatWeekOfYear(dt, 1);
                        break;
                    }
                    case 30: {
                        type = FieldType.NUMERIC;
                        value = dt.getDayOfWeek().getValue() % 7;
                        break;
                    }
                    case 27: {
                        type = FieldType.NUMERIC;
                        value = dt.getDayOfWeek().getValue();
                        break;
                    }
                    case 31: {
                        value = dt.getYear();
                        type = value >= 0L ? FieldType.NUMERIC4 : FieldType.NUMERIC5;
                        break;
                    }
                    case 32: {
                        type = FieldType.NUMERIC2;
                        value = dt.getYear() % 100;
                        break;
                    }
                    case 33: {
                        value = dt.getOffset().getTotalSeconds();
                        int colons = (Integer)token.getData();
                        output = RubyDateFormatter.formatZone(colons, (int)value, isUtc, formatter);
                        break;
                    }
                    case 34: {
                        output = RubyDateFormatter.getRubyTimeZoneName(dt, zone);
                        break;
                    }
                    case 8: {
                        type = FieldType.NUMERIC;
                        value = dt.getYear() / 100;
                        break;
                    }
                    case 25: {
                        type = FieldType.NUMERIC;
                        value = dt.toInstant().getEpochSecond();
                        break;
                    }
                    case 28: {
                        type = FieldType.NUMERIC2;
                        value = GregorianCalendar.from(dt).get(3);
                        break;
                    }
                    case 17: 
                    case 21: {
                        int defaultWidth = format == Format.FORMAT_NANOSEC ? 9 : 3;
                        int width = formatter.getWidth(defaultWidth);
                        output = RubyTimeOutputFormatter.formatNumber(dt.getNano(), 9, '0');
                        if (width < output.length()) {
                            output = output.substring(0, width);
                        } else {
                            StringBuilder outputBuilder = new StringBuilder(output);
                            while (outputBuilder.length() < width) {
                                outputBuilder.append('0');
                            }
                            output = outputBuilder.toString();
                        }
                        formatter = RubyTimeOutputFormatter.DEFAULT_FORMATTER;
                        break;
                    }
                    case 11: {
                        value = GregorianCalendar.from(dt).getWeekYear();
                        type = value >= 0L ? FieldType.NUMERIC4 : FieldType.NUMERIC5;
                        break;
                    }
                    case 12: {
                        value = GregorianCalendar.from(dt).getWeekYear() % 100;
                        type = FieldType.NUMERIC2;
                        break;
                    }
                    case 35: {
                        type = FieldType.NUMERIC;
                        Instant instant = dt.toInstant();
                        value = instant.getEpochSecond() * 1000L + (long)(instant.getNano() / 1000000);
                        break;
                    }
                    case 3: {
                        throw new Error("FORMAT_SPECIAL is a special token only for the lexer.");
                    }
                }
                try {
                    output = formatter.format(output, value, type);
                }
                catch (IndexOutOfBoundsException ioobe) {
                    Backtrace backtrace = context.getCallStack().getBacktrace(currentNode);
                    RubyString message = StringOperations.createUTF8String(context, language, "strftime");
                    int errno = context.getCoreLibrary().getErrnoValue("ERANGE");
                    throw new RaiseException(context, (RubyException)errnoErrorNode.execute(null, errno, (Object)message, null, backtrace));
                }
                formatter = RubyTimeOutputFormatter.DEFAULT_FORMATTER;
                toAppendTo.append(TStringUtils.javaStringToBytes(output, toAppendTo.getRubyEncoding()));
            }
            ++n2;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean formatCanBeFast(Token[] compiledPattern) {
        int compiledPatternLength = compiledPattern.length;
        block6: for (int i = 0; i < compiledPatternLength; ++i) {
            Token token = compiledPattern[i];
            Format format = token.getFormat();
            switch (format.ordinal()) {
                case 0: {
                    if (token.getData() == Encodings.UTF_8) continue block6;
                    return false;
                }
                case 2: {
                    RubyTimeOutputFormatter formatter = (RubyTimeOutputFormatter)token.getData();
                    if (!formatter.flags.isEmpty()) {
                        return false;
                    }
                    if (formatter.width != 6) {
                        return false;
                    }
                    if (compiledPattern[i + 1].getFormat() == Format.FORMAT_NANOSEC) continue block6;
                    return false;
                }
                case 21: {
                    if (i - 1 >= 0 && compiledPattern[i - 1].getFormat() == Format.FORMAT_OUTPUT) continue block6;
                    return false;
                }
                case 1: 
                case 9: 
                case 13: 
                case 19: 
                case 20: 
                case 24: 
                case 31: {
                    continue block6;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    @ExplodeLoop
    public static TruffleString formatToTStringFast(Token[] compiledPattern, ZonedDateTime dt, TruffleString.ConcatNode concatNode, TruffleString.FromLongNode fromLongNode, TruffleString.CodePointLengthNode codePointLengthNode) {
        TruffleString.Encoding utf8 = Encodings.UTF_8.tencoding;
        TruffleString tstring = TStringConstants.EMPTY_UTF8;
        block11: for (Token token : compiledPattern) {
            TruffleString appendTString;
            switch (token.getFormat().ordinal()) {
                case 0: 
                case 2: {
                    continue block11;
                }
                case 1: {
                    appendTString = token.getTString();
                    break;
                }
                case 9: {
                    appendTString = TStringConstants.paddedNumber(dt.getDayOfMonth());
                    break;
                }
                case 13: {
                    appendTString = TStringConstants.paddedNumber(dt.getHour());
                    break;
                }
                case 19: {
                    appendTString = TStringConstants.paddedNumber(dt.getMinute());
                    break;
                }
                case 20: {
                    appendTString = TStringConstants.paddedNumber(dt.getMonthValue());
                    break;
                }
                case 24: {
                    appendTString = TStringConstants.paddedNumber(dt.getSecond());
                    break;
                }
                case 31: {
                    int value = dt.getYear();
                    assert (value >= 1000);
                    assert (value <= 9999);
                    appendTString = fromLongNode.execute((long)value, utf8, true);
                    break;
                }
                case 21: {
                    int nano = dt.getNano();
                    TruffleString microSecondTString = fromLongNode.execute((long)(nano / 1000), utf8, true);
                    int length = 6;
                    int padding = 6 - codePointLengthNode.execute((AbstractTruffleString)microSecondTString, utf8);
                    assert (padding >= 0) : microSecondTString;
                    if (padding == 0) {
                        appendTString = microSecondTString;
                        break;
                    }
                    appendTString = concatNode.execute((AbstractTruffleString)TStringConstants.paddingZeros(padding), (AbstractTruffleString)microSecondTString, utf8, true);
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            tstring = concatNode.execute((AbstractTruffleString)tstring, (AbstractTruffleString)appendTString, utf8, true);
        }
        return tstring;
    }

    private static int formatWeekOfYear(ZonedDateTime dt, int firstDayOfWeek) {
        GregorianCalendar dtCalendar = GregorianCalendar.from(dt);
        dtCalendar.setFirstDayOfWeek(firstDayOfWeek);
        dtCalendar.setMinimalDaysInFirstWeek(7);
        int value = dtCalendar.get(3);
        if ((value == 52 || value == 53) && dtCalendar.get(2) == 0) {
            value = 0;
        }
        return value;
    }

    private static String formatZone(int colons, int value, boolean isUtc, RubyTimeOutputFormatter formatter) {
        int seconds = Math.abs(value);
        int hours = seconds / 3600;
        int minutes = (seconds %= 3600) / 60;
        seconds %= 60;
        if (value < 0 && hours != 0) {
            hours = -hours;
        }
        String mm = RubyTimeOutputFormatter.formatNumber(minutes, 2, '0');
        String ss = RubyTimeOutputFormatter.formatNumber(seconds, 2, '0');
        char padder = formatter.getPadderAlwaysPad('0');
        int defaultWidth = -1;
        Object after = null;
        switch (colons) {
            case 0: {
                defaultWidth = 5;
                after = mm;
                break;
            }
            case 1: {
                defaultWidth = 6;
                after = ":" + mm;
                break;
            }
            case 2: {
                defaultWidth = 9;
                after = ":" + mm + ":" + ss;
                break;
            }
            case 3: {
                StringBuilder sb = new StringBuilder();
                if (minutes != 0 || seconds != 0) {
                    sb.append(":").append(mm);
                }
                if (seconds != 0) {
                    sb.append(":").append(ss);
                }
                after = sb.toString();
                defaultWidth = ((String)after).length() + 3;
                break;
            }
            default: {
                throw new UnsupportedOperationException(colons + " colons");
            }
        }
        int minWidth = defaultWidth - 1;
        int width = formatter.getWidthAlwaysPad(defaultWidth);
        if (width < minWidth) {
            width = minWidth;
        }
        String before = RubyTimeOutputFormatter.formatSignedNumber(hours, width -= ((String)after).length(), padder);
        if (value < 0 && hours == 0) {
            before = before.replace('+', '-');
        }
        if (isUtc && formatter.hasNoPaddingFlag()) {
            before = before.replace('+', '-');
        }
        return before + (String)after;
    }

    private static String getRubyTimeZoneName(ZonedDateTime dt, Object zone) {
        if (RubyStringLibrary.isRubyStringUncached(zone)) {
            return RubyGuards.getJavaString(zone);
        }
        return "";
    }

    public static final class Token {
        private final Format format;
        private final Object data;
        private final TruffleString tstring;

        protected Token(Format format) {
            this(format, null);
        }

        protected Token(Format formatString, Object data) {
            this(formatString, data, null);
        }

        protected Token(Format formatString, Object data, TruffleString tstring) {
            this.format = formatString;
            this.data = data;
            this.tstring = tstring;
        }

        public static Token str(String str) {
            return new Token(Format.FORMAT_STRING, str, TStringUtils.utf8TString(str));
        }

        public static Token format(char c) {
            return Format.findToken(c);
        }

        public static Token zoneOffsetColons(int colons) {
            return new Token(Format.FORMAT_COLON_ZONE_OFF, colons);
        }

        public static Token special(char c) {
            return new Token(Format.FORMAT_SPECIAL, Character.valueOf(c));
        }

        public static Token formatter(RubyTimeOutputFormatter formatter) {
            return new Token(Format.FORMAT_OUTPUT, formatter);
        }

        public Object getData() {
            return this.data;
        }

        public TruffleString getTString() {
            return this.tstring;
        }

        public Format getFormat() {
            return this.format;
        }

        public String toString() {
            return "<Token " + String.valueOf((Object)this.format) + " " + String.valueOf(this.data) + ">";
        }
    }

    static enum Format {
        FORMAT_ENCODING,
        FORMAT_STRING,
        FORMAT_OUTPUT,
        FORMAT_SPECIAL,
        FORMAT_WEEK_LONG('A'),
        FORMAT_WEEK_SHORT('a'),
        FORMAT_MONTH_LONG('B'),
        FORMAT_MONTH_SHORT('b', 'h'),
        FORMAT_CENTURY('C'),
        FORMAT_DAY('d'),
        FORMAT_DAY_S('e'),
        FORMAT_WEEKYEAR('G'),
        FORMAT_WEEKYEAR_SHORT('g'),
        FORMAT_HOUR('H'),
        FORMAT_HOUR_M('I'),
        FORMAT_DAY_YEAR('j'),
        FORMAT_HOUR_BLANK('k'),
        FORMAT_MILLISEC('L'),
        FORMAT_HOUR_S('l'),
        FORMAT_MINUTES('M'),
        FORMAT_MONTH('m'),
        FORMAT_NANOSEC('N'),
        FORMAT_MERIDIAN_LOWER_CASE('P'),
        FORMAT_MERIDIAN('p'),
        FORMAT_SECONDS('S'),
        FORMAT_EPOCH('s'),
        FORMAT_WEEK_YEAR_S('U'),
        FORMAT_DAY_WEEK2('u'),
        FORMAT_WEEK_WEEKYEAR('V'),
        FORMAT_WEEK_YEAR_M('W'),
        FORMAT_DAY_WEEK('w'),
        FORMAT_YEAR_LONG('Y'),
        FORMAT_YEAR_SHORT('y'),
        FORMAT_COLON_ZONE_OFF,
        FORMAT_ZONE_ID,
        FORMAT_MICROSEC_EPOCH;


        private Format() {
        }

        private Format(char conversion) {
            RubyDateFormatter.CONVERSION2TOKEN[conversion] = new Token(this);
        }

        private Format(char conversion, char alias) {
            this(conversion);
            RubyDateFormatter.CONVERSION2TOKEN[alias] = CONVERSION2TOKEN[conversion];
        }

        private static Token findToken(char c) {
            return CONVERSION2TOKEN[c];
        }
    }

    static enum FieldType {
        NUMERIC('0', 0),
        NUMERIC2('0', 2),
        NUMERIC2BLANK(' ', 2),
        NUMERIC3('0', 3),
        NUMERIC4('0', 4),
        NUMERIC5('0', 5),
        TEXT(' ', 0);

        char defaultPadder;
        int defaultWidth;

        private FieldType(char padder, int width) {
            this.defaultPadder = padder;
            this.defaultWidth = width;
        }
    }
}

