/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.thread;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.TruffleStackTrace;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.SuppressFBWarnings;
import org.truffleruby.collections.ConcurrentWeakSet;
import org.truffleruby.core.DummyNode;
import org.truffleruby.core.InterruptMode;
import org.truffleruby.core.basicobject.BasicObjectNodes;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.exception.RubySystemExit;
import org.truffleruby.core.fiber.FiberManager;
import org.truffleruby.core.fiber.RubyFiber;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.core.support.PRNGRandomizerNodes;
import org.truffleruby.core.thread.NativeCallInterrupter;
import org.truffleruby.core.thread.RubyThread;
import org.truffleruby.core.thread.ThreadNodes;
import org.truffleruby.core.thread.ThreadStatus;
import org.truffleruby.extra.ffi.Pointer;
import org.truffleruby.interop.InteropNodes;
import org.truffleruby.interop.TranslateInteropExceptionNode;
import org.truffleruby.language.Nil;
import org.truffleruby.language.SafepointAction;
import org.truffleruby.language.SafepointPredicate;
import org.truffleruby.language.control.DynamicReturnException;
import org.truffleruby.language.control.ExitException;
import org.truffleruby.language.control.KillException;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.objects.shared.SharedObjects;
import org.truffleruby.shared.Platform;
import org.truffleruby.signal.LibRubySignal;

public final class ThreadManager {
    public static final String NAME_PREFIX = "Ruby Thread";
    private final RubyContext context;
    private final RubyLanguage language;
    private final RubyThread rootThread;
    @CompilerDirectives.CompilationFinal
    private Thread rootJavaThread;
    private final Set<RubyThread> runningRubyThreads = ConcurrentHashMap.newKeySet();
    private final ConcurrentWeakSet<Thread> rubyManagedThreads = new ConcurrentWeakSet();
    private boolean nativeInterrupt;
    private boolean useLibRubySignal;
    private Timer nativeInterruptTimer;
    private ThreadLocal<TruffleSafepoint.Interrupter> nativeCallInterrupter;

    public ThreadManager(RubyContext context, RubyLanguage language) {
        this.context = context;
        this.language = language;
        this.rootThread = this.createBootThread("main");
    }

    public void initialize() {
        this.useLibRubySignal = this.context.getOptions().NATIVE_PLATFORM;
        boolean bl = this.nativeInterrupt = this.context.getOptions().NATIVE_INTERRUPT && this.useLibRubySignal;
        if (this.useLibRubySignal) {
            LibRubySignal.loadLibrary((String)this.language.getRubyHome(), (String)Platform.LIB_SUFFIX);
        }
        if (this.nativeInterrupt) {
            LibRubySignal.setupSIGVTALRMEmptySignalHandler();
            this.nativeInterruptTimer = new Timer("Ruby-NativeCallInterrupt-Timer", true);
            this.nativeCallInterrupter = ThreadLocal.withInitial(() -> new NativeCallInterrupter(this.nativeInterruptTimer, LibRubySignal.threadID()));
        }
    }

    public void dispose() {
        if (this.nativeInterrupt) {
            this.nativeInterruptTimer.cancel();
            this.nativeInterruptTimer = null;
        }
    }

    public void initializeMainThread(Thread mainJavaThread) {
        this.rootJavaThread = mainJavaThread;
        this.start(this.rootThread, this.rootJavaThread);
    }

    public void resetMainThread() {
        this.cleanup(this.rootThread, this.rootJavaThread);
        this.rootJavaThread = null;
    }

    public void restartMainThread(Thread mainJavaThread) {
        this.initializeMainThread(mainJavaThread);
        this.rootThread.status = ThreadStatus.RUN;
        this.rootThread.finishedLatch = new CountDownLatch(1);
        RubyFiber rootFiber = this.rootThread.getRootFiber();
        rootFiber.restart();
        PRNGRandomizerNodes.resetSeed(this.context, this.rootThread.randomizer);
    }

    public Thread createFiberJavaThread(RubyFiber fiber, SourceSection sourceSection, Runnable beforeEnter, Runnable body, Runnable afterLeave, Node node) {
        if (this.context.isPreInitializing()) {
            throw CompilerDirectives.shouldNotReachHere((String)"fibers should not be created while pre-initializing the context");
        }
        Thread thread = this.context.getEnv().newTruffleThreadBuilder(body).beforeEnter(beforeEnter).afterLeave(afterLeave).virtual(this.context.getOptions().VIRTUAL_THREAD_FIBERS).build();
        this.language.rubyThreadInitMap.put(thread, fiber.rubyThread);
        this.language.rubyFiberInitMap.put(thread, fiber);
        thread.setName("Ruby Fiber id=" + RubyLanguage.getThreadId(thread) + " from " + this.context.fileLine(sourceSection));
        thread.setDaemon(true);
        this.rubyManagedThreads.add(thread);
        thread.setUncaughtExceptionHandler(ThreadManager.uncaughtExceptionHandler(fiber));
        return thread;
    }

    private Thread createJavaThread(Runnable runnable, RubyThread rubyThread, String info, Node node) {
        if (this.context.getOptions().SINGLE_THREADED) {
            throw new RaiseException(this.context, this.context.getCoreExceptions().securityError("threads not allowed in single-threaded mode", node));
        }
        if (this.context.isPreInitializing()) {
            throw CompilerDirectives.shouldNotReachHere((String)"threads should not be created while pre-initializing the context");
        }
        Thread thread = this.context.getEnv().newTruffleThreadBuilder(runnable).build();
        this.language.rubyThreadInitMap.put(thread, rubyThread);
        this.language.rubyFiberInitMap.put(thread, rubyThread.getRootFiber());
        thread.setName("Ruby Thread id=" + RubyLanguage.getThreadId(thread) + " from " + info);
        this.rubyManagedThreads.add(thread);
        thread.setUncaughtExceptionHandler(ThreadManager.uncaughtExceptionHandler(rubyThread.getRootFiber()));
        return thread;
    }

    private static Thread.UncaughtExceptionHandler uncaughtExceptionHandler(RubyFiber fiber) {
        assert (fiber != null);
        return (javaThread, throwable) -> {
            if (throwable instanceof KillException) {
                return;
            }
            ThreadManager.printInternalError(throwable);
            try {
                fiber.uncaughtException = throwable;
                fiber.initializedLatch.countDown();
            }
            catch (Throwable t) {
                t.initCause(throwable);
                ThreadManager.printInternalError(t);
            }
        };
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isRubyManagedThread(Thread thread) {
        return this.rubyManagedThreads.contains(thread);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyThread createBootThread(String info) {
        return this.createThread(this.context.getCoreLibrary().threadClass, this.language.threadShape, this.language, Nil.INSTANCE, info);
    }

    public RubyThread createThread(RubyClass rubyClass, Shape shape, RubyLanguage language) {
        Object currentGroup = language.getCurrentThread().threadGroup;
        assert (currentGroup != null);
        return this.createThread(rubyClass, shape, language, currentGroup, "<uninitialized>");
    }

    @CompilerDirectives.TruffleBoundary
    public RubyThread createForeignThread() {
        Object currentGroup = this.rootThread.threadGroup;
        assert (currentGroup != null);
        return this.createThread(this.context.getCoreLibrary().threadClass, this.language.threadShape, this.language, currentGroup, "<foreign thread>");
    }

    private RubyThread createThread(RubyClass rubyClass, Shape shape, RubyLanguage language, Object currentGroup, String info) {
        return new RubyThread(rubyClass, shape, this.context, language, this.getGlobalReportOnException(), this.getGlobalAbortOnException(), currentGroup, info);
    }

    private boolean getGlobalReportOnException() {
        RubyClass threadClass = this.context.getCoreLibrary().threadClass;
        return (Boolean)DynamicObjectLibrary.getUncached().getOrDefault((DynamicObject)threadClass, (Object)"@report_on_exception", null);
    }

    private boolean getGlobalAbortOnException() {
        RubyClass threadClass = this.context.getCoreLibrary().threadClass;
        return (Boolean)DynamicObjectLibrary.getUncached().getOrDefault((DynamicObject)threadClass, (Object)"@abort_on_exception", null);
    }

    public void initialize(RubyThread rubyThread, Node currentNode, String info, String sharingReason, Supplier<Object> task) {
        Thread thread;
        this.startSharing(rubyThread, sharingReason);
        rubyThread.sourceLocation = info;
        RubyFiber rootFiber = rubyThread.getRootFiber();
        rubyThread.thread = thread = this.createJavaThread(() -> this.threadMain(rubyThread, currentNode, task), rubyThread, info, currentNode);
        thread.start();
        FiberManager.waitForInitializationEntered(this.context, rootFiber, currentNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadMain(RubyThread thread, Node currentNode, Supplier<Object> task) {
        try {
            Object result = task.get();
            this.setThreadValue(thread, result);
        }
        catch (KillException e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (RaiseException e) {
            this.setException(thread, e.getException(), currentNode);
        }
        catch (DynamicReturnException e) {
            this.setException(thread, this.context.getCoreExceptions().unexpectedReturn(currentNode), currentNode);
        }
        catch (ExitException e) {
            this.rethrowOnMainThread(currentNode, e);
        }
        catch (Throwable e) {
            RuntimeException runtimeException = ThreadManager.printInternalError(e);
            this.rethrowOnMainThread(currentNode, runtimeException);
        }
        finally {
            assert (thread.value != null || thread.exception != null);
            this.cleanupKillOtherFibers(thread);
        }
    }

    public static RuntimeException printInternalError(Throwable e) {
        String message = StringUtils.format("%s terminated with internal error:", Thread.currentThread().getName());
        RuntimeException runtimeException = new RuntimeException(message, e);
        runtimeException.printStackTrace();
        return runtimeException;
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"})
    private void rethrowOnMainThread(Node currentNode, final RuntimeException e) {
        this.context.getSafepointManager().pauseRubyThreadAndExecute(currentNode, new SafepointAction(this, "rethrow " + String.valueOf(e.getClass()) + " to main thread", this.getRootThread(), true, false){
            final /* synthetic */ ThreadManager this$0;
            {
                this.this$0 = this$0;
                super(reason, targetThread, hasSideEffects, synchronous);
            }

            @Override
            public void run(RubyThread rubyThread, Node currentNode) {
                throw e;
            }
        });
    }

    private void setThreadValue(RubyThread thread, Object value) {
        assert (value != null);
        SharedObjects.propagate(this.language, thread, value);
        thread.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setException(RubyThread thread, RubyException exception, Node currentNode) {
        RaiseException truffleException;
        RaiseException raiseException = truffleException = exception.backtrace == null ? null : exception.backtrace.getRaiseException();
        if (truffleException != null) {
            TruffleStackTrace.fillIn((Throwable)((Object)truffleException));
        }
        SharedObjects.propagate(this.language, thread, exception);
        thread.exception = exception;
        RubyThread mainThread = this.context.getThreadManager().getRootThread();
        if (thread != mainThread) {
            boolean isSystemExit = exception instanceof RubySystemExit;
            if (!isSystemExit && thread.reportOnException) {
                TruffleSafepoint safepoint = TruffleSafepoint.getCurrent();
                boolean sideEffects = safepoint.setAllowSideEffects(false);
                try {
                    DispatchNode.getUncached().call(this.context.getCoreLibrary().truffleThreadOperationsModule, "report_exception", thread, (Object)exception);
                }
                finally {
                    safepoint.setAllowSideEffects(sideEffects);
                }
            }
            if (isSystemExit || thread.abortOnException) {
                ThreadNodes.ThreadRaisePrimitiveNode.raiseInThread(this.language, this.context, mainThread, exception, currentNode);
            }
        }
    }

    public void startSharing(RubyThread rubyThread, String reason) {
        if (this.language.options.SHARED_OBJECTS_ENABLED) {
            this.context.getSharedObjects().startSharing(this.language, reason);
            SharedObjects.writeBarrier(this.language, rubyThread);
        }
    }

    public void startForeignThread(RubyThread rubyThread, Thread javaThread) {
        this.startSharing(rubyThread, "creating a foreign thread");
        this.start(rubyThread, javaThread);
    }

    public void start(RubyThread thread, Thread javaThread) {
        boolean isSameThread;
        boolean bl = isSameThread = javaThread == Thread.currentThread();
        if (isSameThread && this.useLibRubySignal) {
            thread.nativeThreadId = LibRubySignal.getNativeThreadID();
        }
        thread.thread = javaThread;
        thread.ioBuffer = this.context.getOptions().NATIVE_PLATFORM ? Pointer.getNullBuffer(this.context) : null;
        this.registerThread(thread);
        RubyFiber rootFiber = thread.getRootFiber();
        this.context.fiberManager.start(rootFiber, javaThread);
        rootFiber.initializedLatch.countDown();
    }

    public void cleanup(RubyThread thread, Thread javaThread) {
        this.cleanupKillOtherFibers(thread);
        this.cleanupThreadState(thread, javaThread);
    }

    private void cleanupKillOtherFibers(RubyThread thread) {
        thread.nativeThreadId = Nil.INSTANCE;
        thread.status = ThreadStatus.DEAD;
        this.context.fiberManager.killOtherFibers(thread);
    }

    public void cleanupThreadState(RubyThread thread, Thread javaThread) {
        this.context.fiberManager.cleanup(thread.getRootFiber(), javaThread);
        if (thread.ioBuffer != null) {
            thread.ioBuffer.freeAll(thread);
        }
        this.unregisterThread(thread);
        thread.thread = null;
        thread.getRootFiber().thread = null;
        if (Thread.currentThread() == javaThread) {
            for (ReentrantLock lock : thread.ownedLocks) {
                while (lock.isHeldByCurrentThread()) {
                    lock.unlock();
                }
            }
        } else if (!thread.ownedLocks.isEmpty()) {
            RubyLanguage.LOGGER.warning("could not release locks of " + String.valueOf(javaThread) + " as its cleanup happened on another Java Thread");
        }
        thread.finishedLatch.countDown();
    }

    public Thread getRootJavaThread() {
        return this.rootJavaThread;
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized Thread getOrInitializeRootJavaThread() {
        if (this.rootJavaThread == null) {
            this.rootJavaThread = Thread.currentThread();
        }
        return this.rootJavaThread;
    }

    public RubyThread getRootThread() {
        return this.rootThread;
    }

    @CompilerDirectives.TruffleBoundary
    public <T, R> R runUntilResultKeepStatus(Node currentNode, TruffleSafepoint.InterruptibleFunction<T, R> action, T object) {
        assert (this.context.getEnv().getContext().isEntered()) : "Use retryWhileInterrupted() when not entered";
        return (R)TruffleSafepoint.setBlockedThreadInterruptibleFunction((Node)currentNode, action, object);
    }

    public static Object executeBlockingCall(RubyThread thread, TruffleSafepoint.Interrupter interrupter, Object executable, Object[] args, BlockingCallInterruptible blockingCallInterruptible, Node currentNode) {
        TruffleSafepoint safepoint = TruffleSafepoint.getCurrent();
        BlockingCallInterruptible.State state = new BlockingCallInterruptible.State(thread, executable, args);
        return safepoint.setBlockedFunction(currentNode, interrupter, (TruffleSafepoint.InterruptibleFunction)blockingCallInterruptible, (Object)state, null, null);
    }

    @CompilerDirectives.TruffleBoundary
    public <T> T runUntilResult(Node currentNode, BlockingAction<T> action) {
        return this.runUntilResult(currentNode, action, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public <T> T runUntilResult(Node currentNode, BlockingAction<T> action, Runnable beforeInterrupt, Consumer<Throwable> afterInterrupt) {
        TruffleSafepoint safepoint = TruffleSafepoint.getCurrent();
        RubyThread runningThread = RubyLanguage.get(currentNode).getCurrentThread();
        boolean onBlocking = runningThread.interruptMode == InterruptMode.ON_BLOCKING;
        ThreadStatus status = runningThread.status;
        boolean sideEffects = false;
        if (onBlocking) {
            sideEffects = safepoint.setAllowSideEffects(true);
        }
        try {
            Object object = safepoint.setBlockedFunction(currentNode, TruffleSafepoint.Interrupter.THREAD_INTERRUPT, arg -> {
                runningThread.status = ThreadStatus.SLEEP;
                try {
                    Object t = action.block();
                    return t;
                }
                finally {
                    runningThread.status = status;
                }
            }, null, beforeInterrupt, afterInterrupt);
            return (T)object;
        }
        finally {
            if (onBlocking) {
                safepoint.setAllowSideEffects(sideEffects);
            }
        }
    }

    public <T, R> R leaveAndEnter(Node node, TruffleSafepoint.Interrupter interrupter, TruffleSafepoint.InterruptibleFunction<T, R> interruptible, T object) {
        TruffleContext truffleContext = this.context.getEnv().getContext();
        Object result = truffleContext.leaveAndEnter(node, interrupter, interruptible, object);
        return (R)Objects.requireNonNull(result);
    }

    @CompilerDirectives.TruffleBoundary
    TruffleSafepoint.Interrupter getNativeCallInterrupter() {
        if (this.nativeInterrupt) {
            return this.nativeCallInterrupter.get();
        }
        return TruffleSafepoint.Interrupter.THREAD_INTERRUPT;
    }

    public void registerThread(RubyThread thread) {
        if (!this.runningRubyThreads.add(thread)) {
            throw new UnsupportedOperationException(String.valueOf(thread) + " was already registered");
        }
    }

    public void unregisterThread(RubyThread thread) {
        if (!this.runningRubyThreads.remove(thread)) {
            throw new UnsupportedOperationException(String.valueOf(thread) + " was not registered");
        }
    }

    public void checkNoRunningThreads() {
        if (!this.runningRubyThreads.isEmpty()) {
            RubyLanguage.LOGGER.warning("threads are still registered with thread manager at shutdown:\n" + this.getThreadDebugInfo());
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void killAndWaitOtherThreads() {
        if (this.runningRubyThreads.size() > 1) {
            this.doKillOtherThreads();
        }
        this.context.fiberManager.killOtherFibers(this.language.getCurrentThread());
        for (Thread thread : this.rubyManagedThreads) {
            if (thread == Thread.currentThread()) continue;
            this.runUntilResultKeepStatus(DummyNode.INSTANCE, t -> {
                t.join();
                return true;
            }, thread);
        }
    }

    @CompilerDirectives.TruffleBoundary
    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"})
    private void doKillOtherThreads() {
        Thread initiatingJavaThread = Thread.currentThread();
        SafepointPredicate predicate = (context, thread, action) -> Thread.currentThread() != initiatingJavaThread && this.language.getCurrentFiber() == thread.getCurrentFiber();
        this.context.getSafepointManager().pauseAllThreadsAndExecute(DummyNode.INSTANCE, new SafepointAction("kill other threads for shutdown", predicate, true, true){

            @Override
            public void run(RubyThread rubyThread, Node currentNode) {
                rubyThread.status = ThreadStatus.ABORTING;
                throw new KillException(currentNode);
            }
        });
    }

    @CompilerDirectives.TruffleBoundary
    public Object[] getThreadList() {
        return this.runningRubyThreads.toArray();
    }

    @CompilerDirectives.TruffleBoundary
    public Iterable<RubyThread> iterateThreads() {
        return this.runningRubyThreads;
    }

    public String getThreadDebugInfo() {
        StringBuilder builder = new StringBuilder();
        for (RubyThread thread : this.runningRubyThreads) {
            builder.append("thread @");
            builder.append(BasicObjectNodes.ObjectIDNode.getUncached().execute(thread));
            if (thread == this.rootThread) {
                builder.append(" (root)");
            }
            if (thread == this.language.getCurrentThread()) {
                builder.append(" (current)");
            }
            builder.append("\n");
            builder.append(this.context.fiberManager.getFiberDebugInfo(thread));
        }
        if (builder.length() == 0) {
            return "no ruby threads\n";
        }
        return builder.toString();
    }

    public static class BlockingCallInterruptible
    implements TruffleSafepoint.CompiledInterruptibleFunction<State, Object> {
        final InteropLibrary receivers;
        final TranslateInteropExceptionNode translateInteropExceptionNode;
        final Node node;

        public BlockingCallInterruptible(Node node, InteropLibrary receivers, TranslateInteropExceptionNode translateInteropExceptionNode) {
            this.node = node;
            this.receivers = receivers;
            this.translateInteropExceptionNode = translateInteropExceptionNode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object apply(State state) {
            CompilerAsserts.partialEvaluationConstant((Object)this);
            RubyThread thread = state.thread;
            ThreadStatus status = thread.status;
            thread.status = ThreadStatus.SLEEP;
            try {
                CompilerAsserts.partialEvaluationConstant((Object)this.receivers);
                CompilerAsserts.partialEvaluationConstant((Object)((Object)this.translateInteropExceptionNode));
                Object object = InteropNodes.execute(this.node, state.executable, state.args, this.receivers, this.translateInteropExceptionNode);
                return object;
            }
            finally {
                thread.status = status;
            }
        }

        @CompilerDirectives.ValueType
        private static final class State {
            final RubyThread thread;
            final Object executable;
            final Object[] args;

            private State(RubyThread thread, Object executable, Object[] args) {
                this.thread = thread;
                this.executable = executable;
                this.args = args;
            }
        }
    }

    public static interface BlockingAction<T> {
        public static final boolean SUCCESS = true;

        public T block() throws InterruptedException;
    }
}

