/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.support;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.utilities.TruffleWeakReference;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.objects.WriteObjectFieldNode;

@CoreModule(value="Truffle::WeakRefOperations")
public abstract class WeakRefNodes {
    private static final TruffleWeakReference<Object> EMPTY_WEAK_REF = new TruffleWeakReference(null);
    private static final HiddenKey FIELD_NAME = new HiddenKey("weak_ref");

    @Primitive(name="weakref_object")
    public static abstract class WeakRefObjectPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(limit="getDynamicObjectCacheLimit()")
        Object weakRefObject(RubyDynamicObject weakRef, @CachedLibrary(value="weakRef") DynamicObjectLibrary objectLibrary) {
            TruffleWeakReference ref = (TruffleWeakReference)objectLibrary.getOrDefault((DynamicObject)weakRef, (Object)FIELD_NAME, EMPTY_WEAK_REF);
            Object object = ref.get();
            return object == null ? nil : object;
        }
    }

    @Primitive(name="weakref_set_object")
    public static abstract class WeakRefSetObjectPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object weakRefSetObject(RubyDynamicObject weakRef, Object object, @Cached WriteObjectFieldNode fieldNode) {
            fieldNode.execute(this, weakRef, FIELD_NAME, new TruffleWeakReference(object));
            return object;
        }
    }
}

