/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.support;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;
import org.truffleruby.algorithms.Randomizer;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.support.RubyRandomizer;

public final class RubyPRNGRandomizer
extends RubyRandomizer {
    private Randomizer randomizer;
    private final boolean threadSafe;

    public RubyPRNGRandomizer(RubyClass rubyClass, Shape shape, Randomizer randomizer, boolean threadSafe) {
        super(rubyClass, shape);
        this.randomizer = randomizer;
        this.threadSafe = threadSafe;
    }

    public void setRandomizer(Randomizer randomizer) {
        this.randomizer = randomizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public int genrandInt32() {
        if (this.threadSafe) {
            RubyPRNGRandomizer rubyPRNGRandomizer = this;
            synchronized (rubyPRNGRandomizer) {
                return this.randomizer.unsynchronizedGenrandInt32();
            }
        }
        return this.randomizer.unsynchronizedGenrandInt32();
    }

    public Object getSeed() {
        return this.randomizer.getSeed();
    }
}

