/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.string;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.collections.WeakValueCache;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.string.FrozenStrings;
import org.truffleruby.core.string.TBytesKey;
import org.truffleruby.core.string.TStringConstants;
import org.truffleruby.core.symbol.CoreSymbols;
import org.truffleruby.core.symbol.RubySymbol;

public final class TStringCache {
    private final WeakValueCache<TBytesKey, TruffleString> bytesToTString = new WeakValueCache();
    private int byteArrayReusedCount;
    private int tstringsReusedCount;
    private int tstringBytesSaved;

    public TStringCache(CoreSymbols coreSymbols) {
        this.addTStringConstants();
        this.addCoreSymbolTStrings(coreSymbols);
        this.addFrozenStrings();
    }

    private void addFrozenStrings() {
        for (TruffleString tstring : FrozenStrings.TSTRINGS) {
            this.register(tstring, Encodings.BINARY);
        }
    }

    private void addTStringConstants() {
        for (TruffleString tstring : TStringConstants.UTF8_SINGLE_BYTE) {
            this.register(tstring, Encodings.UTF_8);
        }
        for (TruffleString tstring : TStringConstants.US_ASCII_SINGLE_BYTE) {
            this.register(tstring, Encodings.US_ASCII);
        }
        for (TruffleString tstring : TStringConstants.BINARY_SINGLE_BYTE) {
            this.register(tstring, Encodings.BINARY);
        }
        for (TruffleString tstring : TStringConstants.TSTRING_CONSTANTS.values()) {
            this.register(tstring, Encodings.US_ASCII);
        }
    }

    private void addCoreSymbolTStrings(CoreSymbols coreSymbols) {
        for (RubySymbol symbol : coreSymbols.CORE_SYMBOLS) {
            this.register(symbol.tstring, symbol.encoding);
        }
    }

    private void register(TruffleString tstring, RubyEncoding encoding) {
        TBytesKey key = new TBytesKey(TStringUtils.getBytesOrFail((AbstractTruffleString)tstring, encoding), encoding);
        TruffleString existing = this.bytesToTString.put(key, tstring);
        if (existing != null && existing != tstring) {
            throw CompilerDirectives.shouldNotReachHere((String)("Duplicate TruffleString in TStringCache: " + String.valueOf(existing)));
        }
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleString getTString(TruffleString string, RubyEncoding rubyEncoding) {
        assert (rubyEncoding != null);
        InternalByteArray byteArray = string.getInternalByteArrayUncached(rubyEncoding.tencoding);
        TBytesKey key = new TBytesKey(byteArray, rubyEncoding);
        return this.getTString(key, TStringUtils.hasImmutableInternalByteArray((AbstractTruffleString)string));
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleString getTString(InternalByteArray byteArray, boolean isImmutable, RubyEncoding rubyEncoding) {
        assert (rubyEncoding != null);
        return this.getTString(new TBytesKey(byteArray, rubyEncoding), isImmutable);
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleString getTString(byte[] bytes, RubyEncoding rubyEncoding) {
        assert (rubyEncoding != null);
        return this.getTString(new TBytesKey(bytes, rubyEncoding), true);
    }

    @CompilerDirectives.TruffleBoundary
    private TruffleString getTString(TBytesKey lookupKey, boolean isLookupKeyImmutable) {
        TruffleString newTString;
        TruffleString tstring = this.bytesToTString.get(lookupKey);
        RubyEncoding rubyEncoding = lookupKey.getMatchedEncoding();
        if (tstring != null) {
            ++this.tstringsReusedCount;
            this.tstringBytesSaved += tstring.byteLength(lookupKey.getMatchedEncoding().tencoding);
            return tstring;
        }
        TBytesKey keyNoEncoding = lookupKey.withNewEncoding(null);
        TruffleString tstringWithSameBytesButDifferentEncoding = this.bytesToTString.get(keyNoEncoding);
        if (tstringWithSameBytesButDifferentEncoding != null) {
            TruffleString.Encoding prevEncoding = keyNoEncoding.getMatchedEncoding().tencoding;
            newTString = tstringWithSameBytesButDifferentEncoding.forceEncodingUncached(prevEncoding, rubyEncoding.tencoding);
            ++this.byteArrayReusedCount;
            this.tstringBytesSaved += newTString.byteLength(rubyEncoding.tencoding);
        } else {
            newTString = lookupKey.toTruffleString();
        }
        return this.bytesToTString.addInCacheIfAbsent(lookupKey.makeCacheable(isLookupKeyImmutable), newTString);
    }

    public boolean contains(TruffleString string, RubyEncoding encoding) {
        TBytesKey key = new TBytesKey(TStringUtils.getBytesOrCopy((AbstractTruffleString)string, encoding), encoding);
        return this.bytesToTString.get(key) != null;
    }

    public int getByteArrayReusedCount() {
        return this.byteArrayReusedCount;
    }

    public int getTStringsReusedCount() {
        return this.tstringsReusedCount;
    }

    public int getTStringBytesSaved() {
        return this.tstringBytesSaved;
    }

    public int totalTStrings() {
        return this.bytesToTString.size();
    }
}

