/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.string;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.core.cast.ToSNode;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringNodes;
import org.truffleruby.core.string.StringNodesFactory;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;

public final class InterpolatedStringNode
extends RubyContextSourceNode {
    @Node.Children
    private final ToSNode[] children;
    @Node.Child
    private StringNodes.StringAppendPrimitiveNode appendNode;
    private final RubyEncoding encoding;
    private final TruffleString emptyTString;

    public InterpolatedStringNode(ToSNode[] children, RubyEncoding encoding) {
        assert (children.length > 0);
        this.children = children;
        this.encoding = encoding;
        this.emptyTString = this.encoding.tencoding.getEmpty();
    }

    @Override
    @ExplodeLoop
    public Object execute(VirtualFrame frame) {
        RubyString builder = this.createString(this.emptyTString, this.encoding);
        for (ToSNode child : this.children) {
            Object toInterpolate = child.execute(frame);
            builder = this.executeStringAppend(builder, toInterpolate);
        }
        return builder;
    }

    private RubyString executeStringAppend(RubyString builder, Object string) {
        if (this.appendNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.appendNode = (StringNodes.StringAppendPrimitiveNode)this.insert(StringNodesFactory.StringAppendPrimitiveNodeFactory.create(null));
        }
        return this.appendNode.executeStringAppend(builder, string);
    }

    @Override
    public RubyNode cloneUninitialized() {
        InterpolatedStringNode copy = new InterpolatedStringNode(InterpolatedStringNode.cloneUninitialized(this.children), this.encoding);
        return copy.copyFlags(this);
    }

    protected static ToSNode[] cloneUninitialized(ToSNode[] nodes) {
        ToSNode[] copies = new ToSNode[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            copies[i] = (ToSNode)nodes[i].cloneUninitialized();
        }
        return copies;
    }
}

