/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.string;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Objects;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.SuppressFBWarnings;
import org.truffleruby.cext.CExtNodes;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.kernel.KernelNodes;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.string.StringGuards;
import org.truffleruby.core.string.StringHelperNodes;
import org.truffleruby.core.support.DetailedInspectingSupport;
import org.truffleruby.extra.ffi.Pointer;
import org.truffleruby.language.ImmutableRubyObjectCopyable;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.library.RubyStringLibrary;

@ExportLibrary(value=InteropLibrary.class)
public final class ImmutableRubyString
extends ImmutableRubyObjectCopyable
implements TruffleObject,
DetailedInspectingSupport {
    public final TruffleString tstring;
    public final RubyEncoding encoding;
    private Pointer nativeString = null;

    ImmutableRubyString(TruffleString tstring, RubyEncoding encoding) {
        assert (tstring.isCompatibleToUncached(encoding.tencoding));
        assert (tstring.isManaged());
        this.tstring = Objects.requireNonNull(tstring);
        this.encoding = Objects.requireNonNull(encoding);
    }

    public String toString() {
        return this.tstring.toString();
    }

    @Override
    public String toStringWithDetails() {
        return "\"" + String.valueOf(this.tstring) + "\" (" + String.valueOf(this.encoding.name) + ")";
    }

    public TruffleString asTruffleStringUncached() {
        CompilerAsserts.neverPartOfCompilation((String)"Only behind @TruffleBoundary");
        assert (!this.tstring.isNative());
        return this.tstring;
    }

    public String getJavaString() {
        CompilerAsserts.neverPartOfCompilation((String)"Only behind @TruffleBoundary");
        return TStringUtils.toJavaStringOrThrow((AbstractTruffleString)this.tstring, this.getEncodingUncached());
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"})
    public boolean isNative() {
        return this.nativeString != null;
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"})
    public Pointer getNativeString(RubyLanguage language, RubyContext context) {
        if (this.nativeString == null) {
            return this.createNativeString(language, context);
        }
        return this.nativeString;
    }

    @CompilerDirectives.TruffleBoundary
    private synchronized Pointer createNativeString(RubyLanguage language, RubyContext context) {
        if (this.nativeString == null) {
            TruffleString.Encoding tencoding = this.getEncodingUncached().tencoding;
            int byteLength = this.tstring.byteLength(tencoding);
            this.nativeString = CExtNodes.StringToNativeNode.allocateAndCopyToNative(language, context, (AbstractTruffleString)this.tstring, tencoding, byteLength, TruffleString.CopyToNativeMemoryNode.getUncached());
        }
        return this.nativeString;
    }

    public RubyEncoding getEncodingUncached() {
        CompilerAsserts.neverPartOfCompilation((String)"Only behind @TruffleBoundary");
        return this.encoding;
    }

    public RubyEncoding getEncodingUnprofiled() {
        return this.encoding;
    }

    @ExportMessage
    protected Object toDisplayString(boolean allowSideEffects, @Cached DispatchNode dispatchNode, @Cached KernelNodes.ToSNode kernelToSNode) {
        if (allowSideEffects) {
            return dispatchNode.call(this, "inspect");
        }
        return kernelToSNode.execute(this);
    }

    @ExportMessage
    protected boolean hasMetaObject() {
        return true;
    }

    @ExportMessage
    protected RubyClass getMetaObject(@CachedLibrary(value="this") InteropLibrary node) {
        return RubyContext.get((Node)node).getCoreLibrary().stringClass;
    }

    @ExportMessage
    protected boolean isString() {
        return true;
    }

    @ExportMessage
    protected TruffleString asTruffleString() {
        assert (!this.tstring.isNative());
        return this.tstring;
    }

    @ExportMessage
    @ReportPolymorphism
    @ImportStatic(value={RubyBaseNode.class})
    public static final class AsString {
        @Specialization(guards={"equalNode.execute(string.tstring, libString.getEncoding(node, string), cachedTString, cachedEncoding)"}, limit="getLimit()")
        static String asStringCached(ImmutableRubyString string, @Bind(value="this") Node node, @Cached @Cached.Shared RubyStringLibrary libString, @Cached(value="string.asTruffleStringUncached()") TruffleString cachedTString, @Cached(value="string.getEncodingUncached()") RubyEncoding cachedEncoding, @Cached(value="string.getJavaString()") String javaString, @Cached StringHelperNodes.EqualNode equalNode) {
            return javaString;
        }

        @Specialization(replaces={"asStringCached"})
        static String asStringUncached(ImmutableRubyString string, @Cached @Cached.Shared RubyStringLibrary libString, @Cached TruffleString.GetByteCodeRangeNode codeRangeNode, @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached InlinedConditionProfile binaryNonAsciiProfile, @Bind(value="this") Node node) {
            RubyEncoding encoding = libString.getEncoding(node, string);
            if (binaryNonAsciiProfile.profile(node, encoding == Encodings.BINARY && !StringGuards.is7Bit((AbstractTruffleString)string.tstring, encoding, codeRangeNode))) {
                return AsString.getJavaStringBoundary(string);
            }
            return toJavaStringNode.execute((AbstractTruffleString)string.tstring);
        }

        @CompilerDirectives.TruffleBoundary
        private static String getJavaStringBoundary(ImmutableRubyString string) {
            return string.getJavaString();
        }

        protected static int getLimit() {
            return RubyLanguage.getCurrentLanguage().options.INTEROP_CONVERT_CACHE;
        }
    }
}

