/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.string;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringOperations;

public final class CoreString {
    private final RubyLanguage language;
    private final String literal;
    @CompilerDirectives.CompilationFinal
    private volatile TruffleString tstring;

    public CoreString(RubyLanguage language, String literal) {
        assert (language != null);
        assert (CoreString.is7Bit(literal));
        this.language = language;
        this.literal = literal;
    }

    public TruffleString getTruffleString() {
        if (this.tstring == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.tstring = this.language.tstringCache.getTString(StringOperations.encodeAsciiBytes(this.literal), Encodings.BINARY);
        }
        return this.tstring;
    }

    public RubyString createInstance(RubyContext context) {
        return new RubyString(context.getCoreLibrary().stringClass, this.language.stringShape, false, (AbstractTruffleString)this.getTruffleString(), Encodings.BINARY);
    }

    private static boolean is7Bit(String literal) {
        for (int n = 0; n < literal.length(); ++n) {
            if (literal.charAt(n) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.literal;
    }
}

