/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.string;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import java.math.BigInteger;
import java.util.Arrays;
import org.truffleruby.RubyContext;
import org.truffleruby.core.CoreLibrary;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.numeric.FixnumOrBignumNode;
import org.truffleruby.core.string.StringOperations;
import org.truffleruby.core.string.TStringBuilder;
import org.truffleruby.language.control.RaiseException;

public final class ConvertBytes {
    private final RubyContext context;
    private final Node currentNode;
    private final AbstractTruffleString tstring;
    private int p;
    private int end;
    private byte[] data;
    private int base;
    private final boolean badcheck;
    private static final byte[][] MIN_VALUE_BYTES;
    private static final byte[] ZERO_BYTES;
    private static final byte[] LOWER_DIGITS;
    private static final byte[] UPPER_DIGITS;
    private static final byte[] conv_digit;
    private static final boolean[] digit;
    private static final boolean[] space;

    public ConvertBytes(RubyContext context, Node currentNode, AbstractTruffleString tstring, RubyEncoding encoding, int base, boolean badcheck) {
        assert (tstring != null);
        InternalByteArray byteArray = tstring.getInternalByteArrayUncached(encoding.tencoding);
        this.context = context;
        this.currentNode = currentNode;
        this.tstring = tstring;
        this.p = byteArray.getOffset();
        this.data = byteArray.getArray();
        this.end = byteArray.getEnd();
        this.badcheck = badcheck;
        this.base = base;
    }

    public static Object bytesToInum(RubyContext context, Node currentNode, AbstractTruffleString tstring, RubyEncoding encoding, int base, boolean badcheck) {
        return new ConvertBytes(context, currentNode, tstring, encoding, base, badcheck).bytesToInum();
    }

    private byte convertDigit(byte c) {
        if (c < 0) {
            return -1;
        }
        return conv_digit[c];
    }

    private boolean isSpace(int str) {
        byte c;
        if (str == this.end || (c = this.data[str]) < 0) {
            return false;
        }
        return space[c];
    }

    private boolean getSign() {
        boolean sign = true;
        if (this.p < this.end) {
            if (this.data[this.p] == 43) {
                ++this.p;
            } else if (this.data[this.p] == 45) {
                ++this.p;
                sign = false;
            }
        }
        return sign;
    }

    private void ignoreLeadingWhitespace() {
        while (this.isSpace(this.p)) {
            ++this.p;
        }
    }

    private void figureOutBase() {
        if (this.base <= 0) {
            if (this.p < this.end && this.data[this.p] == 48) {
                if (this.p + 1 < this.end) {
                    switch (this.data[this.p + 1]) {
                        case 88: 
                        case 120: {
                            this.base = 16;
                            break;
                        }
                        case 66: 
                        case 98: {
                            this.base = 2;
                            break;
                        }
                        case 79: 
                        case 111: {
                            this.base = 8;
                            break;
                        }
                        case 68: 
                        case 100: {
                            this.base = 10;
                            break;
                        }
                        default: {
                            this.base = 8;
                            break;
                        }
                    }
                } else {
                    this.base = 8;
                }
            } else {
                this.base = this.base < -1 ? -this.base : 10;
            }
        }
    }

    private int calculateLength() {
        int len;
        int second = this.p + 1 < this.end && this.data[this.p] == 48 ? this.data[this.p + 1] : 0;
        switch (this.base) {
            case 2: {
                len = 1;
                if (second != 98 && second != 66) break;
                this.p += 2;
                break;
            }
            case 3: {
                len = 2;
                break;
            }
            case 8: {
                if (second == 111 || second == 79) {
                    this.p += 2;
                }
                len = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                len = 3;
                break;
            }
            case 10: {
                if (second == 100 || second == 68) {
                    this.p += 2;
                }
                len = 4;
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                len = 4;
                break;
            }
            case 16: {
                len = 4;
                if (second != 120 && second != 88) break;
                this.p += 2;
                break;
            }
            default: {
                if (this.base < 2 || 36 < this.base) {
                    throw new RaiseException(this.context, this.context.getCoreExceptions().argumentErrorInvalidRadix(this.base, this.currentNode));
                }
                len = this.base <= 32 ? 5 : 6;
            }
        }
        return len;
    }

    private void squeezeZeroes() {
        if (this.p < this.end && this.data[this.p] == 48) {
            byte c;
            ++this.p;
            int us = 0;
            while (this.p < this.end && ((c = this.data[this.p]) == 48 || c == 95)) {
                if (c == 95) {
                    if (++us >= 2) {
                        break;
                    }
                } else {
                    us = 0;
                }
                ++this.p;
            }
            if (this.p == this.end || this.isSpace(this.p)) {
                --this.p;
            }
        }
    }

    private long stringToLong(int nptr, int[] endptr, int base) {
        if (base < 0 || base == 1 || base > 36) {
            return 0L;
        }
        int save = nptr;
        int s = nptr;
        boolean overflow = false;
        while (this.isSpace(s)) {
            ++s;
        }
        if (s != this.end) {
            byte c;
            boolean negative = false;
            if (this.data[s] == 45) {
                negative = true;
                ++s;
            } else if (this.data[s] == 43) {
                negative = false;
                ++s;
            }
            save = s;
            long i = 0L;
            long cutoff = Long.MAX_VALUE / (long)base;
            long cutlim = Long.MAX_VALUE % (long)base;
            while (s < this.end && (c = this.convertDigit(this.data[s])) != -1 && c < base) {
                ++s;
                if (i > cutoff || i == cutoff && (long)c > cutlim) {
                    overflow = true;
                    continue;
                }
                i *= (long)base;
                i += (long)c;
            }
            if (s != save) {
                if (endptr != null) {
                    endptr[0] = s;
                }
                if (overflow) {
                    throw new ERange(negative ? ERange.Kind.Underflow : ERange.Kind.Overflow);
                }
                if (negative) {
                    return -i;
                }
                return i;
            }
        }
        if (endptr != null) {
            endptr[0] = save - nptr >= 2 && (this.data[save - 1] == 120 || this.data[save - 1] == 88) && this.data[save - 2] == 48 ? save - 1 : nptr;
        }
        return 0L;
    }

    @CompilerDirectives.TruffleBoundary
    public Object bytesToInum() {
        this.ignoreLeadingWhitespace();
        boolean sign = this.getSign();
        if (this.p < this.end && (this.data[this.p] == 43 || this.data[this.p] == 45)) {
            if (this.badcheck) {
                this.invalidString();
            }
            return 0;
        }
        this.figureOutBase();
        int len = this.calculateLength();
        this.squeezeZeroes();
        int c = 0;
        if (this.p < this.end) {
            c = this.data[this.p];
        }
        if ((c = this.convertDigit((byte)c)) < 0 || c >= this.base) {
            if (this.badcheck) {
                this.invalidString();
            }
            return 0;
        }
        len = this.base <= 10 ? (len *= this.trailingLength()) : (len *= this.end - this.p);
        if (len < 63) {
            int[] endPlace = new int[]{this.p};
            long val = this.stringToLong(this.p, endPlace, this.base);
            if (endPlace[0] < this.end && this.data[endPlace[0]] == 95) {
                return this.bigParse(len, sign);
            }
            if (this.badcheck) {
                if (endPlace[0] == this.p) {
                    this.invalidString();
                }
                while (this.isSpace(endPlace[0])) {
                    endPlace[0] = endPlace[0] + 1;
                }
                if (endPlace[0] < this.end) {
                    this.invalidString();
                }
            }
            if (sign) {
                if (CoreLibrary.fitsIntoInteger(val)) {
                    return (int)val;
                }
                return val;
            }
            if (CoreLibrary.fitsIntoInteger(-val)) {
                return (int)(-val);
            }
            return -val;
        }
        return this.bigParse(len, sign);
    }

    private int trailingLength() {
        int newLen = 0;
        for (int i = this.p; i < this.end; ++i) {
            if (Character.isDigit(this.data[i])) {
                ++newLen;
                continue;
            }
            return newLen;
        }
        return newLen;
    }

    private Object bigParse(int len, boolean sign) {
        BigInteger z;
        if (this.badcheck && this.p < this.end && this.data[this.p] == 95) {
            this.invalidString();
        }
        char[] result = new char[this.end - this.p];
        int resultIndex = 0;
        int nondigit = -1;
        while (this.p < this.end) {
            int c;
            int cx = c = this.data[this.p++];
            if (c == 95) {
                if (nondigit != -1) {
                    if (!this.badcheck) break;
                    this.invalidString();
                    break;
                }
                nondigit = c;
                continue;
            }
            byte by = this.convertDigit((byte)c);
            c = by;
            if (by < 0 || c >= this.base) break;
            nondigit = -1;
            result[resultIndex++] = (char)cx;
        }
        if (resultIndex == 0) {
            return 0;
        }
        int tmpStr = this.p;
        if (this.badcheck) {
            if (1 < tmpStr && this.data[tmpStr - 1] == 95) {
                this.invalidString();
            }
            while (tmpStr < this.end && Character.isWhitespace(this.data[tmpStr])) {
                ++tmpStr;
            }
            if (tmpStr < this.end) {
                this.invalidString();
            }
        }
        String s = new String(result, 0, resultIndex);
        BigInteger bigInteger = z = this.base == 10 ? this.stringToBig(s) : new BigInteger(s, this.base);
        if (!sign) {
            z = z.negate();
        }
        if (this.badcheck) {
            if (1 < this.p && this.data[this.p - 1] == 95) {
                this.invalidString();
            }
            while (this.p < this.end && this.isSpace(this.p)) {
                ++this.p;
            }
            if (this.p < this.end) {
                this.invalidString();
            }
        }
        return FixnumOrBignumNode.executeUncached(z);
    }

    private BigInteger stringToBig(String str) {
        int nDigits;
        int size = (str = str.replaceAll("_", "")).length();
        if (size < (nDigits = 512)) {
            nDigits = size;
        }
        int j = size - 1;
        int i = j - nDigits + 1;
        BigInteger[] digits = new BigInteger[j / nDigits + 1];
        int z = 0;
        while (j >= 0) {
            digits[z] = new BigInteger(str.substring(i, j + 1).strip());
            j = i - 1;
            if ((i = j - nDigits + 1) < 0) {
                i = 0;
            }
            ++z;
        }
        BigInteger b10x = BigInteger.TEN.pow(nDigits);
        int n = digits.length;
        while (n > 1) {
            i = 0;
            j = 0;
            while (i < n / 2) {
                digits[i] = digits[j].add(digits[j + 1].multiply(b10x));
                ++i;
                j += 2;
            }
            if (j == n - 1) {
                digits[i] = digits[j];
            }
            n = ++i;
            b10x = b10x.multiply(b10x);
        }
        return digits[0];
    }

    private void invalidString() {
        String string = this.tstring.toJavaStringUncached();
        throw new RaiseException(this.context, this.context.getCoreExceptions().argumentErrorInvalidStringToInteger(string, this.currentNode));
    }

    public static final byte[] intToBinaryBytes(int i) {
        return ConvertBytes.intToUnsignedBytes(i, 1, LOWER_DIGITS).getBytes();
    }

    public static final byte[] intToOctalBytes(int i) {
        return ConvertBytes.intToUnsignedBytes(i, 3, LOWER_DIGITS).getBytes();
    }

    public static final byte[] intToHexBytes(int i, boolean upper) {
        TStringBuilder tstringBuilder = ConvertBytes.intToUnsignedBytes(i, 4, upper ? UPPER_DIGITS : LOWER_DIGITS);
        return tstringBuilder.getBytes();
    }

    public static final byte[] intToByteArray(int i, int radix, boolean upper) {
        return ConvertBytes.longToByteArray(i, radix, upper);
    }

    public static final byte[] intToCharBytes(int i) {
        return ConvertBytes.longToBytes(i, 10, LOWER_DIGITS).getBytes();
    }

    public static final byte[] longToBinaryBytes(long i) {
        return ConvertBytes.longToUnsignedBytes(i, 1, LOWER_DIGITS).getBytes();
    }

    public static final byte[] longToOctalBytes(long i) {
        return ConvertBytes.longToUnsignedBytes(i, 3, LOWER_DIGITS).getBytes();
    }

    public static final byte[] longToHexBytes(long i, boolean upper) {
        TStringBuilder tstringBuilder = ConvertBytes.longToUnsignedBytes(i, 4, upper ? UPPER_DIGITS : LOWER_DIGITS);
        return tstringBuilder.getBytes();
    }

    public static final byte[] longToByteArray(long i, int radix, boolean upper) {
        TStringBuilder tstringBuilder = ConvertBytes.longToBytes(i, radix, upper ? UPPER_DIGITS : LOWER_DIGITS);
        return tstringBuilder.getBytes();
    }

    public static final byte[] longToCharBytes(long i) {
        return ConvertBytes.longToBytes(i, 10, LOWER_DIGITS).getBytes();
    }

    public static final TStringBuilder longToBytes(long i, int radix, byte[] digitmap) {
        if (i == 0L) {
            return TStringBuilder.create(ZERO_BYTES);
        }
        if (i == Long.MIN_VALUE) {
            return TStringBuilder.create(MIN_VALUE_BYTES[radix]);
        }
        boolean neg = false;
        if (i < 0L) {
            i = -i;
            neg = true;
        }
        int len = 64;
        byte[] buf = new byte[len];
        int pos = len;
        do {
            buf[--pos] = digitmap[(int)(i % (long)radix)];
        } while ((i /= (long)radix) > 0L);
        if (neg) {
            buf[--pos] = 45;
        }
        return TStringBuilder.create(buf, pos, len - pos);
    }

    private static final TStringBuilder intToUnsignedBytes(int i, int shift, byte[] digitmap) {
        byte[] buf = new byte[32];
        int charPos = 32;
        int radix = 1 << shift;
        long mask = radix - 1;
        do {
            buf[--charPos] = digitmap[(int)((long)i & mask)];
        } while ((i >>>= shift) != 0);
        return TStringBuilder.create(buf, charPos, 32 - charPos);
    }

    private static final TStringBuilder longToUnsignedBytes(long i, int shift, byte[] digitmap) {
        byte[] buf = new byte[64];
        int charPos = 64;
        int radix = 1 << shift;
        long mask = radix - 1;
        do {
            buf[--charPos] = digitmap[(int)(i & mask)];
        } while ((i >>>= shift) != 0L);
        return TStringBuilder.create(buf, charPos, 64 - charPos);
    }

    public static final byte[] twosComplementToBinaryBytes(byte[] in) {
        return ConvertBytes.twosComplementToUnsignedBytes(in, 1, false);
    }

    public static final byte[] twosComplementToOctalBytes(byte[] in) {
        return ConvertBytes.twosComplementToUnsignedBytes(in, 3, false);
    }

    public static final byte[] twosComplementToHexBytes(byte[] in, boolean upper) {
        return ConvertBytes.twosComplementToUnsignedBytes(in, 4, upper);
    }

    public static final byte[] twosComplementToUnsignedBytes(byte[] in, int shift, boolean upper) {
        if (shift < 1 || shift > 4) {
            throw CompilerDirectives.shouldNotReachHere((String)"shift value must be 1-4");
        }
        int ilen = in.length;
        int olen = (ilen * 8 + shift - 1) / shift;
        byte[] out = new byte[olen];
        int mask = (1 << shift) - 1;
        byte[] digits = upper ? UPPER_DIGITS : LOWER_DIGITS;
        int bitbuf = 0;
        int bitcnt = 0;
        int i = ilen;
        int o = olen;
        while (--o >= 0) {
            if (bitcnt < shift) {
                bitbuf |= (in[--i] & 0xFF) << bitcnt;
                bitcnt += 8;
            }
            out[o] = digits[bitbuf & mask];
            bitbuf >>= shift;
            bitcnt -= shift;
        }
        return out;
    }

    static {
        int c;
        MIN_VALUE_BYTES = new byte[37][];
        for (int i = 2; i <= 36; ++i) {
            ConvertBytes.MIN_VALUE_BYTES[i] = StringOperations.encodeAsciiBytes(Long.toString(Long.MIN_VALUE, i));
        }
        ZERO_BYTES = new byte[]{48};
        LOWER_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
        UPPER_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};
        conv_digit = new byte[128];
        digit = new boolean[128];
        space = new boolean[128];
        Arrays.fill(conv_digit, (byte)-1);
        Arrays.fill(digit, false);
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            ConvertBytes.conv_digit[c] = (byte)(c - 48);
            ConvertBytes.digit[c] = true;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            ConvertBytes.conv_digit[c] = (byte)(c - 97 + 10);
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            ConvertBytes.conv_digit[c] = (byte)(c - 65 + 10);
        }
        Arrays.fill(space, false);
        ConvertBytes.space[9] = true;
        ConvertBytes.space[10] = true;
        ConvertBytes.space[11] = true;
        ConvertBytes.space[12] = true;
        ConvertBytes.space[13] = true;
        ConvertBytes.space[32] = true;
    }

    public static final class ERange
    extends RuntimeException {
        private final Kind kind;

        public ERange(Kind kind) {
            this.kind = kind;
        }

        public Kind getKind() {
            return this.kind;
        }

        public static enum Kind {
            Overflow,
            Underflow;

        }
    }
}

