/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.regexp;

import com.oracle.truffle.api.strings.TruffleString;
import java.util.Objects;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.regexp.ClassicRegexp;
import org.truffleruby.core.regexp.RegexpOptions;
import org.truffleruby.core.regexp.RegexpSupport;
import org.truffleruby.core.string.TStringBuilder;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.language.control.DeferredRaiseException;

public final class RegexpCacheKey {
    public final TruffleString tstring;
    public final RubyEncoding encoding;
    public final RegexpOptions options;

    public static RegexpCacheKey calculate(TStringWithEncoding source, RegexpOptions options) throws DeferredRaiseException {
        RubyEncoding[] fixedEnc = new RubyEncoding[]{null};
        TStringBuilder processed = ClassicRegexp.preprocess(source, source.getEncoding(), fixedEnc, RegexpSupport.ErrorMode.RAISE);
        RegexpOptions[] optionsArray = new RegexpOptions[]{options};
        RubyEncoding enc = ClassicRegexp.computeRegexpEncoding(optionsArray, source.getEncoding(), fixedEnc);
        return new RegexpCacheKey(processed.toTString(), enc, optionsArray[0]);
    }

    private RegexpCacheKey(TruffleString tstring, RubyEncoding encoding, RegexpOptions options) {
        this.tstring = tstring;
        this.encoding = encoding;
        this.options = options;
    }

    public RegexpOptions getOptions() {
        return this.options;
    }

    public RubyEncoding getEncoding() {
        return this.encoding;
    }

    public int hashCode() {
        return Objects.hash(this.encoding, this.tstring, this.options);
    }

    public boolean equals(Object o) {
        if (o instanceof RegexpCacheKey) {
            RegexpCacheKey other = (RegexpCacheKey)o;
            return this.encoding == other.encoding && this.tstring.equals((Object)other.tstring) && this.options.equals(other.options);
        }
        return false;
    }

    public String toString() {
        return "/" + this.tstring.toString() + "/" + this.options.toOptionsString() + " -- " + String.valueOf(this.encoding.name);
    }
}

