/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.proc;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.object.Shape;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.proc.ProcCallTargets;
import org.truffleruby.core.proc.ProcType;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.arguments.ArgumentsDescriptor;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.control.FrameOnStackMarker;
import org.truffleruby.language.methods.DeclarationContext;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.methods.SharedMethodInfo;
import org.truffleruby.language.threadlocal.SpecialVariableStorage;

public abstract class ProcOperations {
    private static Object[] packArguments(RubyProc proc, ArgumentsDescriptor descriptor, Object ... args) {
        return RubyArguments.pack(proc.declarationFrame, null, proc.declaringMethod, proc.frameOnStackMarker, ProcOperations.getSelf(proc), RubyBaseNode.nil, descriptor, args);
    }

    public static Object rootCall(RubyProc proc, ArgumentsDescriptor descriptor, Object ... args) {
        FrameOnStackMarker frameOnStackMarker = proc.frameOnStackMarker;
        if (frameOnStackMarker != null) {
            frameOnStackMarker.setNoLongerOnStack();
        }
        return proc.callTarget.call(ProcOperations.packArguments(proc, descriptor, args));
    }

    public static RubyProc createRubyProc(RubyClass rubyClass, Shape procShape, ProcType type, SharedMethodInfo sharedMethodInfo, ProcCallTargets holder, MaterializedFrame declarationFrame, SpecialVariableStorage variables, InternalMethod method, FrameOnStackMarker frameOnStackMarker, DeclarationContext declarationContext) {
        return new RubyProc(rubyClass, procShape, type, sharedMethodInfo.getArity(), sharedMethodInfo.getRawArgumentDescriptors(), holder, switch (type) {
            case ProcType.PROC -> holder.getCallTargetForProc();
            case ProcType.LAMBDA -> holder.getCallTargetForLambda();
            default -> throw CompilerDirectives.shouldNotReachHere();
        }, declarationFrame, variables, method, frameOnStackMarker, declarationContext);
    }

    public static RubyProc convertBlock(RubyContext context, RubyLanguage language, RubyProc block, ProcType type) {
        return ProcOperations.createRubyProc(context.getCoreLibrary().procClass, language.procShape, type, block.getSharedMethodInfo(), block.callTargets, block.declarationFrame, block.declarationVariables, block.declaringMethod, type == ProcType.PROC ? block.frameOnStackMarker : null, block.declarationContext);
    }

    public static RubyProc createLambdaFromBlock(RubyContext context, RubyLanguage language, RubyProc block) {
        assert (block.type == ProcType.PROC);
        return ProcOperations.convertBlock(context, language, block, ProcType.LAMBDA);
    }

    public static RubyProc createProcFromBlock(RubyContext context, RubyLanguage language, RubyProc block) {
        assert (block.type == ProcType.LAMBDA);
        return ProcOperations.convertBlock(context, language, block, ProcType.PROC);
    }

    public static Object getSelf(RubyProc proc) {
        return RubyArguments.getSelf((Frame)proc.declarationFrame);
    }
}

