/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.module;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.collections.Memo;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.module.ConstantLookupResult;
import org.truffleruby.core.module.MethodLookupResult;
import org.truffleruby.core.module.ModuleChain;
import org.truffleruby.core.module.ModuleFields;
import org.truffleruby.core.module.PrependMarker;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.RubyConstant;
import org.truffleruby.language.constants.ConstantEntry;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.methods.DeclarationContext;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.objects.classvariables.ClassVariableStorage;
import org.truffleruby.language.objects.shared.SharedObjects;
import org.truffleruby.parser.Identifiers;

public abstract class ModuleOperations {
    public static final Assumption[] EMPTY_ASSUMPTION_ARRAY = new Assumption[0];

    @CompilerDirectives.TruffleBoundary
    public static boolean includesModule(RubyModule module, RubyModule other) {
        for (RubyModule ancestor : module.fields.ancestors()) {
            if (ancestor != other) continue;
            return true;
        }
        return false;
    }

    public static boolean assignableTo(RubyModule thisClass, RubyModule otherClass) {
        return ModuleOperations.includesModule(thisClass, otherClass);
    }

    public static boolean inAncestorsOf(RubyModule module, RubyModule ancestors) {
        return ModuleOperations.includesModule(ancestors, module);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean canBindMethodTo(InternalMethod method, RubyModule module) {
        RubyModule origin = method.getDeclaringModule();
        if (!(origin instanceof RubyClass)) {
            return true;
        }
        if (module.fields.isRefinement()) {
            RubyModule refinedModule = module.fields.getRefinedModule();
            return refinedModule instanceof RubyClass && ModuleOperations.assignableTo(refinedModule, origin);
        }
        return module instanceof RubyClass && ModuleOperations.assignableTo(module, origin);
    }

    @CompilerDirectives.TruffleBoundary
    public static String constantName(RubyContext context, RubyModule module, String name) {
        if (module == context.getCoreLibrary().objectClass) {
            return "::" + name;
        }
        return module.fields.getName() + "::" + name;
    }

    public static String constantNameNoLeadingColon(RubyContext context, RubyModule module, String name) {
        if (module == context.getCoreLibrary().objectClass) {
            return name;
        }
        return module.fields.getName() + "::" + name;
    }

    @CompilerDirectives.TruffleBoundary
    public static Iterable<Map.Entry<String, ConstantEntry>> getAllConstants(RubyModule module) {
        HashMap<String, ConstantEntry> constants = new HashMap<String, ConstantEntry>();
        for (Map.Entry<String, ConstantEntry> constant : module.fields.getConstants()) {
            if (constant.getValue().getConstant() == null) continue;
            constants.put(constant.getKey(), constant.getValue());
        }
        for (RubyModule ancestor : module.fields.prependedAndIncludedModules()) {
            for (Map.Entry<String, ConstantEntry> constant : ancestor.fields.getConstants()) {
                if (constant.getValue().getConstant() == null) continue;
                constants.putIfAbsent(constant.getKey(), constant.getValue());
            }
        }
        return constants.entrySet();
    }

    public static boolean isConstantDefined(RubyConstant constant) {
        return constant != null && !constant.isUndefined() && (!constant.isAutoload() || !constant.getAutoloadConstant().isAutoloadingThread());
    }

    private static boolean constantExists(RubyConstant constant, ArrayList<Assumption> assumptions) {
        if (constant != null) {
            if (constant.isAutoload() && constant.getAutoloadConstant().isAutoloading()) {
                if (assumptions != null) {
                    assumptions.add(Assumption.NEVER_VALID);
                }
                return !constant.getAutoloadConstant().isAutoloadingThread();
            }
            return true;
        }
        return false;
    }

    private static boolean constantExists(ConstantEntry constantEntry, ArrayList<Assumption> assumptions) {
        return ModuleOperations.constantExists(constantEntry.getConstant(), assumptions);
    }

    @CompilerDirectives.TruffleBoundary
    public static ConstantLookupResult lookupConstant(RubyContext context, RubyModule module, String name) {
        return ModuleOperations.lookupConstant(context, module, name, new ArrayList<Assumption>());
    }

    @CompilerDirectives.TruffleBoundary
    private static ConstantLookupResult lookupConstant(RubyContext context, RubyModule module, String name, ArrayList<Assumption> assumptions) {
        ConstantEntry constantEntry = module.fields.getOrComputeConstantEntry(name);
        assumptions.add(constantEntry.getAssumption());
        if (ModuleOperations.constantExists(constantEntry, assumptions)) {
            return new ConstantLookupResult(constantEntry.getConstant(), ModuleOperations.toArray(assumptions));
        }
        for (RubyModule ancestor : module.fields.ancestors()) {
            if (ancestor == module) continue;
            constantEntry = ancestor.fields.getOrComputeConstantEntry(name);
            assumptions.add(constantEntry.getAssumption());
            if (!ModuleOperations.constantExists(constantEntry, assumptions)) continue;
            return new ConstantLookupResult(constantEntry.getConstant(), ModuleOperations.toArray(assumptions));
        }
        return new ConstantLookupResult(null, ModuleOperations.toArray(assumptions));
    }

    @CompilerDirectives.TruffleBoundary
    public static ConstantLookupResult lookupConstantInObject(RubyContext context, String name, ArrayList<Assumption> assumptions) {
        RubyClass objectClass = context.getCoreLibrary().objectClass;
        ConstantEntry constantEntry = objectClass.fields.getOrComputeConstantEntry(name);
        assumptions.add(constantEntry.getAssumption());
        if (ModuleOperations.constantExists(constantEntry, assumptions)) {
            return new ConstantLookupResult(constantEntry.getConstant(), ModuleOperations.toArray(assumptions));
        }
        for (RubyModule ancestor : objectClass.fields.prependedAndIncludedModules()) {
            constantEntry = ancestor.fields.getOrComputeConstantEntry(name);
            assumptions.add(constantEntry.getAssumption());
            if (!ModuleOperations.constantExists(constantEntry, assumptions)) continue;
            return new ConstantLookupResult(constantEntry.getConstant(), ModuleOperations.toArray(assumptions));
        }
        return new ConstantLookupResult(null, ModuleOperations.toArray(assumptions));
    }

    @CompilerDirectives.TruffleBoundary
    public static RubyConstant lookupConstantInObjectUncached(RubyContext context, String name) {
        RubyClass objectClass = context.getCoreLibrary().objectClass;
        RubyConstant constant = objectClass.fields.getConstant(name);
        if (ModuleOperations.constantExists(constant, null)) {
            return constant;
        }
        for (RubyModule ancestor : objectClass.fields.prependedAndIncludedModules()) {
            constant = ancestor.fields.getConstant(name);
            if (!ModuleOperations.constantExists(constant, null)) continue;
            return constant;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public static ConstantLookupResult lookupConstantAndObject(RubyContext context, RubyModule module, String name, ArrayList<Assumption> assumptions) {
        ConstantLookupResult constant = ModuleOperations.lookupConstant(context, module, name, assumptions);
        if (constant.isFound()) {
            return constant;
        }
        if (!(module instanceof RubyClass)) {
            return ModuleOperations.lookupConstantInObject(context, name, assumptions);
        }
        return constant;
    }

    @CompilerDirectives.TruffleBoundary
    public static ConstantLookupResult lookupConstantWithLexicalScope(RubyContext context, LexicalScope lexicalScope, String name) {
        RubyModule module = lexicalScope.getLiveModule();
        ArrayList<Assumption> assumptions = new ArrayList<Assumption>();
        while (lexicalScope != context.getRootLexicalScope()) {
            ConstantEntry constantEntry = lexicalScope.getLiveModule().fields.getOrComputeConstantEntry(name);
            assumptions.add(constantEntry.getAssumption());
            if (ModuleOperations.constantExists(constantEntry, assumptions)) {
                return new ConstantLookupResult(constantEntry.getConstant(), ModuleOperations.toArray(assumptions));
            }
            lexicalScope = lexicalScope.getParent();
        }
        return ModuleOperations.lookupConstantAndObject(context, module, name, assumptions);
    }

    @CompilerDirectives.TruffleBoundary
    public static ConstantLookupResult lookupScopedConstant(RubyContext context, RubyModule module, String fullName, boolean inherit, Node currentNode, boolean checkName) {
        int next;
        int start = 0;
        if (fullName.startsWith("::")) {
            module = context.getCoreLibrary().objectClass;
            start += 2;
        }
        while ((next = fullName.indexOf("::", start)) != -1) {
            String segment = fullName.substring(start, next);
            ConstantLookupResult constant = ModuleOperations.lookupConstantWithInherit(context, module, segment, inherit, currentNode, checkName);
            if (!constant.isFound()) {
                return constant;
            }
            if (!(constant.getConstant().getValue() instanceof RubyModule)) {
                throw new RaiseException(context, context.getCoreExceptions().typeError(fullName.substring(0, next) + " does not refer to class/module", currentNode));
            }
            module = (RubyModule)constant.getConstant().getValue();
            start = next + 2;
        }
        String lastSegment = fullName.substring(start);
        if (checkName && !Identifiers.isValidConstantName(lastSegment)) {
            throw new RaiseException(context, (RubyException)context.getCoreExceptions().nameError(StringUtils.format("wrong constant name %s", fullName), module, fullName, currentNode));
        }
        return ModuleOperations.lookupConstantWithInherit(context, module, lastSegment, inherit, currentNode, checkName);
    }

    public static ConstantLookupResult lookupConstantWithInherit(RubyContext context, RubyModule module, String name, boolean inherit, Node currentNode, boolean checkName) {
        return ModuleOperations.lookupConstantWithInherit(context, module, name, inherit, currentNode, checkName, true);
    }

    @CompilerDirectives.TruffleBoundary
    public static ConstantLookupResult lookupConstantWithInherit(RubyContext context, RubyModule module, String name, boolean inherit, Node currentNode, boolean checkName, boolean lookInObject) {
        if (checkName && !Identifiers.isValidConstantName(name)) {
            throw new RaiseException(context, (RubyException)context.getCoreExceptions().nameError(StringUtils.format("wrong constant name %s", name), module, name, currentNode));
        }
        ArrayList<Assumption> assumptions = new ArrayList<Assumption>();
        if (inherit) {
            if (lookInObject) {
                return ModuleOperations.lookupConstantAndObject(context, module, name, assumptions);
            }
            return ModuleOperations.lookupConstant(context, module, name, assumptions);
        }
        ConstantEntry constantEntry = module.fields.getOrComputeConstantEntry(name);
        assumptions.add(constantEntry.getAssumption());
        if (ModuleOperations.constantExists(constantEntry, assumptions)) {
            return new ConstantLookupResult(constantEntry.getConstant(), ModuleOperations.toArray(assumptions));
        }
        return new ConstantLookupResult(null, ModuleOperations.toArray(assumptions));
    }

    @CompilerDirectives.TruffleBoundary
    public static Map<String, InternalMethod> getAllMethods(RubyModule module) {
        HashMap<String, InternalMethod> methods = new HashMap<String, InternalMethod>();
        for (RubyModule ancestor : module.fields.ancestors()) {
            for (InternalMethod method : ancestor.fields.getMethods()) {
                methods.putIfAbsent(method.getName(), method);
            }
        }
        if (module.fields.isRefinement()) {
            for (RubyModule ancestor : module.fields.getRefinedModule().fields.ancestors()) {
                for (InternalMethod method : ancestor.fields.getMethods()) {
                    methods.putIfAbsent(method.getName(), method);
                }
            }
        }
        return methods;
    }

    @CompilerDirectives.TruffleBoundary
    public static Map<String, InternalMethod> getMethodsBeforeLogicalClass(RubyModule module) {
        HashMap<String, InternalMethod> methods = new HashMap<String, InternalMethod>();
        ModuleChain chain = module.fields.getFirstModuleChain();
        while (true) {
            RubyModule ancestor;
            if (chain instanceof PrependMarker) {
                RubyModule origin = ((PrependMarker)chain).getOrigin().getActualModule();
                if (origin instanceof RubyClass && !((RubyClass)origin).isSingleton) break;
                chain = chain.getParentModule();
            }
            if ((ancestor = chain.getActualModule()) instanceof RubyClass && !((RubyClass)ancestor).isSingleton) break;
            for (InternalMethod method : ancestor.fields.getMethods()) {
                methods.putIfAbsent(method.getName(), method);
            }
            chain = chain.getParentModule();
        }
        return methods;
    }

    @CompilerDirectives.TruffleBoundary
    public static Map<String, InternalMethod> getMethodsUntilLogicalClass(RubyModule module) {
        HashMap<String, InternalMethod> methods = new HashMap<String, InternalMethod>();
        for (RubyModule ancestor : module.fields.ancestors()) {
            for (InternalMethod method : ancestor.fields.getMethods()) {
                methods.putIfAbsent(method.getName(), method);
            }
            if (!(ancestor instanceof RubyClass) || ((RubyClass)ancestor).isSingleton) continue;
            break;
        }
        return methods;
    }

    @CompilerDirectives.TruffleBoundary
    public static Map<String, InternalMethod> withoutUndefinedMethods(Map<String, InternalMethod> methods) {
        HashMap<String, InternalMethod> definedMethods = new HashMap<String, InternalMethod>();
        for (Map.Entry<String, InternalMethod> method : methods.entrySet()) {
            if (method.getValue().isUndefined()) continue;
            definedMethods.put(method.getKey(), method.getValue());
        }
        return definedMethods;
    }

    @CompilerDirectives.TruffleBoundary
    public static MethodLookupResult lookupMethodCached(RubyModule module, String name, DeclarationContext declarationContext) {
        ArrayList<Assumption> assumptions = new ArrayList<Assumption>();
        for (RubyModule ancestor : module.fields.ancestors()) {
            InternalMethod method;
            RubyModule[] refinements = ModuleOperations.getRefinementsFor(declarationContext, ancestor);
            if (refinements != null) {
                for (RubyModule refinement : refinements) {
                    InternalMethod refinedMethod = refinement.fields.getMethodAndAssumption(name, assumptions);
                    if (refinedMethod == null) continue;
                    InternalMethod method2 = ModuleOperations.rememberUsedRefinements(refinedMethod, declarationContext);
                    return new MethodLookupResult(method2, ModuleOperations.toArray(assumptions));
                }
            }
            if ((method = ancestor.fields.getMethodAndAssumption(name, assumptions)) == null) continue;
            return new MethodLookupResult(method, ModuleOperations.toArray(assumptions));
        }
        return new MethodLookupResult(null, ModuleOperations.toArray(assumptions));
    }

    @CompilerDirectives.TruffleBoundary
    public static InternalMethod lookupMethodUncached(RubyModule module, String name, DeclarationContext declarationContext) {
        for (RubyModule ancestor : module.fields.ancestors()) {
            InternalMethod method;
            RubyModule[] refinements = ModuleOperations.getRefinementsFor(declarationContext, ancestor);
            if (refinements != null) {
                for (RubyModule refinement : refinements) {
                    InternalMethod refinedMethod = refinement.fields.getMethod(name);
                    if (refinedMethod == null) continue;
                    return ModuleOperations.rememberUsedRefinements(refinedMethod, declarationContext);
                }
            }
            if ((method = ancestor.fields.getMethod(name)) == null) continue;
            return method;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public static MethodLookupResult lookupSuperMethod(InternalMethod currentMethod, RubyModule objectMetaClass) {
        String name = currentMethod.getSharedMethodInfo().getMethodNameForNotBlock();
        Memo<Boolean> foundDeclaringModule = new Memo<Boolean>(false);
        RubyModule declaringModule = currentMethod.getDeclaringModule();
        DeclarationContext declarationContext = currentMethod.getDeclarationContext();
        ArrayList<Assumption> assumptions = new ArrayList<Assumption>();
        for (RubyModule ancestor : objectMetaClass.fields.ancestors()) {
            InternalMethod method;
            RubyModule[] refinements = ModuleOperations.getRefinementsFor(declarationContext, currentMethod.getActiveRefinements(), ancestor);
            if (refinements != null) {
                for (RubyModule refinement : refinements) {
                    InternalMethod refinedMethod = ModuleOperations.lookupSuperMethodInModule(declaringModule, name, foundDeclaringModule, refinement, assumptions);
                    if (refinedMethod != null) {
                        return new MethodLookupResult(ModuleOperations.rememberUsedRefinements(refinedMethod, declarationContext, refinements, ancestor), ModuleOperations.toArray(assumptions));
                    }
                    if (foundDeclaringModule.get().booleanValue() && declaringModule.fields.isRefinement()) break;
                }
            }
            if ((method = ModuleOperations.lookupSuperMethodInModule(declaringModule, name, foundDeclaringModule, ancestor, assumptions)) == null) continue;
            return new MethodLookupResult(method, ModuleOperations.toArray(assumptions));
        }
        return new MethodLookupResult(null, ModuleOperations.toArray(assumptions));
    }

    private static InternalMethod lookupSuperMethodInModule(RubyModule declaringModule, String name, Memo<Boolean> foundDeclaringModule, RubyModule module, ArrayList<Assumption> assumptions) {
        if (!foundDeclaringModule.get().booleanValue()) {
            if (module == declaringModule) {
                module.fields.getMethodAndAssumption(name, assumptions);
                foundDeclaringModule.set(true);
            }
            return null;
        }
        return module.fields.getMethodAndAssumption(name, assumptions);
    }

    private static InternalMethod rememberUsedRefinements(InternalMethod method, DeclarationContext declarationContext) {
        return method.withActiveRefinements(declarationContext);
    }

    private static InternalMethod rememberUsedRefinements(InternalMethod method, DeclarationContext declarationContext, RubyModule[] refinements, RubyModule ancestor) {
        assert (refinements != null);
        HashMap<RubyModule, RubyModule[]> currentRefinements = new HashMap<RubyModule, RubyModule[]>(declarationContext.getRefinements());
        currentRefinements.put(ancestor, refinements);
        return method.withActiveRefinements(declarationContext.withRefinements(currentRefinements));
    }

    private static RubyModule[] getRefinementsFor(DeclarationContext declarationContext, DeclarationContext callerDeclaringContext, RubyModule module) {
        RubyModule[] lexicalRefinements = ModuleOperations.getRefinementsFor(declarationContext, module);
        RubyModule[] callerRefinements = ModuleOperations.getRefinementsFor(callerDeclaringContext, module);
        if (lexicalRefinements == null) {
            return callerRefinements;
        }
        if (callerRefinements == null) {
            return lexicalRefinements;
        }
        ArrayList<RubyModule> list = new ArrayList<RubyModule>(Arrays.asList(callerRefinements));
        for (RubyModule refinement : lexicalRefinements) {
            if (ArrayUtils.contains(callerRefinements, refinement)) continue;
            list.add(refinement);
        }
        return list.toArray(RubyModule.EMPTY_ARRAY);
    }

    private static RubyModule[] getRefinementsFor(DeclarationContext declarationContext, RubyModule module) {
        if (declarationContext == null) {
            return null;
        }
        return declarationContext.getRefinementsFor(module);
    }

    private static Assumption[] toArray(ArrayList<Assumption> assumptions) {
        return assumptions.toArray(EMPTY_ASSUMPTION_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public static void setClassVariable(RubyLanguage language, RubyContext context, RubyModule module, String name, Object value, Node currentNode) {
        ModuleFields moduleFields = module.fields;
        moduleFields.checkFrozen(context, currentNode);
        SharedObjects.propagate(language, module, value);
        if (!ModuleOperations.trySetClassVariable(module, name, value)) {
            Object object = context.getClassVariableDefinitionLock();
            synchronized (object) {
                if (!ModuleOperations.trySetClassVariable(module, name, value)) {
                    moduleFields.getClassVariables().put(name, value, DynamicObjectLibrary.getUncached());
                }
            }
        }
    }

    private static boolean trySetClassVariable(RubyModule topModule, String name, Object value) {
        return ModuleOperations.classVariableLookup(topModule, true, module -> module.fields.getClassVariables().putIfPresent(name, value, DynamicObjectLibrary.getUncached()) ? module : null) != null;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object removeClassVariable(ModuleFields fields, RubyContext context, Node currentNode, String name) {
        fields.checkFrozen(context, currentNode);
        ClassVariableStorage classVariables = fields.getClassVariables();
        Object found = classVariables.remove(name, DynamicObjectLibrary.getUncached());
        if (found == null) {
            throw new RaiseException(context, (RubyException)context.getCoreExceptions().nameErrorClassVariableNotDefined(name, fields.rubyModule, currentNode));
        }
        return found;
    }

    @CompilerDirectives.TruffleBoundary
    public static <R> R classVariableLookup(RubyModule module, boolean inherit, Function<RubyModule, R> action) {
        R result = action.apply(module);
        if (result != null) {
            return result;
        }
        if (!inherit) {
            return null;
        }
        if (module instanceof RubyClass) {
            RubyClass klass = (RubyClass)module;
            if (klass.isSingleton && klass.attached instanceof RubyModule && (result = action.apply(module = (RubyModule)klass.attached)) != null) {
                return result;
            }
        }
        for (RubyModule ancestor : module.fields.ancestors()) {
            if (ancestor == module || (result = action.apply(ancestor)) == null) continue;
            return result;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isMethodPrivateFromName(String name) {
        return name.equals("initialize") || name.equals("initialize_copy") || name.equals("initialize_clone") || name.equals("initialize_dup") || name.equals("respond_to_missing?");
    }
}

