/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.module;

import java.util.Iterator;
import org.truffleruby.core.module.IncludedModule;
import org.truffleruby.core.module.ModuleChain;
import org.truffleruby.core.module.ModuleFields;
import org.truffleruby.core.module.PrependMarker;
import org.truffleruby.core.module.RubyModule;

public final class IncludedModulesIterator
implements Iterator<RubyModule> {
    private final ModuleFields currentModule;
    ModuleChain nextModule;

    public IncludedModulesIterator(PrependMarker start, ModuleFields currentModule) {
        this.currentModule = currentModule;
        this.nextModule = this.computeNext(start);
    }

    @Override
    public boolean hasNext() {
        return this.nextModule != null;
    }

    @Override
    public RubyModule next() {
        assert (this.hasNext());
        ModuleChain returned = this.nextModule;
        this.nextModule = this.computeNext(this.nextModule);
        return returned.getActualModule();
    }

    private ModuleChain computeNext(ModuleChain current) {
        ModuleChain mod = current.getParentModule();
        if (mod == this.currentModule) {
            mod = mod.getParentModule();
        }
        if (mod instanceof IncludedModule) {
            return mod;
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

