/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.method;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Set;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.interop.ForeignToRubyArgumentsNode;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.arguments.NoKeywordArgumentsDescriptor;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.methods.CallInternalMethodNode;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.objects.ObjectGraph;
import org.truffleruby.language.objects.ObjectGraphNode;

@ExportLibrary(value=InteropLibrary.class)
public final class RubyMethod
extends RubyDynamicObject
implements ObjectGraphNode {
    public final Object receiver;
    public final InternalMethod method;

    public RubyMethod(RubyClass metaClass, Shape shape, Object receiver, InternalMethod method) {
        super(metaClass, shape);
        this.receiver = receiver;
        this.method = method;
    }

    @Override
    public void getAdjacentObjects(Set<Object> reachable) {
        ObjectGraph.addProperty(reachable, this.receiver);
        ObjectGraph.addProperty(reachable, this.method);
    }

    @ExportMessage
    public boolean hasSourceLocation() {
        return true;
    }

    @ExportMessage
    public SourceSection getSourceLocation() {
        return this.method.getSharedMethodInfo().getSourceSection();
    }

    @ExportMessage
    public boolean isExecutable() {
        return true;
    }

    @ExportMessage
    public Object execute(Object[] arguments, @Cached ForeignToRubyArgumentsNode foreignToRubyArgumentsNode, @Cached CallInternalMethodNode callInternalMethodNode, @Bind(value="$node") Node node) {
        Object[] convertedArguments = foreignToRubyArgumentsNode.executeConvert(node, arguments);
        Object[] frameArgs = RubyArguments.pack(null, null, this.method, null, this.receiver, RubyBaseNode.nil, NoKeywordArgumentsDescriptor.INSTANCE, convertedArguments);
        return callInternalMethodNode.execute(null, this.method, this.receiver, frameArgs);
    }
}

