/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.kernel;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.util.ArrayList;
import java.util.Collection;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.binding.BindingNodes;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.core.tracepoint.TraceBaseEventNode;
import org.truffleruby.language.Nil;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.objects.LogicalClassNode;

public final class TraceManager {
    private final RubyContext context;
    private final RubyLanguage language;
    private final Instrumenter instrumenter;
    private Collection<EventBinding<?>> instruments;
    private boolean isInTraceFunc = false;

    public TraceManager(RubyLanguage language, RubyContext context, Instrumenter instrumenter) {
        this.language = language;
        this.context = context;
        this.instrumenter = instrumenter;
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized void setTraceFunc(RubyProc traceFunc) {
        if (this.instruments != null) {
            for (EventBinding<?> instrument : this.instruments) {
                instrument.dispose();
            }
        }
        if (traceFunc == null) {
            this.language.traceFuncUnusedAssumption.invalidate();
            this.instruments = null;
            return;
        }
        this.language.traceFuncUnusedAssumption.getAssumption().invalidate();
        this.instruments = new ArrayList();
        this.instruments.add(this.instrumenter.attachExecutionEventFactory(SourceSectionFilter.newBuilder().mimeTypeIs(RubyLanguage.MIME_TYPES).tagIs(new Class[]{LineTag.class}).build(), eventContext -> new BaseEventEventNode(this.context, this.language, eventContext, traceFunc, (Object)this.language.coreStrings.LINE.createInstance(this.context))));
        this.instruments.add(this.instrumenter.attachExecutionEventFactory(SourceSectionFilter.newBuilder().mimeTypeIs(RubyLanguage.MIME_TYPES).tagIs(new Class[]{ClassTag.class}).build(), eventContext -> new BaseEventEventNode(this.context, this.language, eventContext, traceFunc, (Object)this.language.coreStrings.CLASS.createInstance(this.context))));
        if (this.context.getOptions().TRACE_CALLS) {
            this.instruments.add(this.instrumenter.attachExecutionEventFactory(SourceSectionFilter.newBuilder().mimeTypeIs(RubyLanguage.MIME_TYPES).tagIs(new Class[]{CallTag.class}).includeInternal(false).build(), eventContext -> new CallEventEventNode(this.context, this.language, eventContext, traceFunc, (Object)this.language.coreStrings.CALL.createInstance(this.context))));
        }
    }

    @CompilerDirectives.TruffleBoundary
    private RubySymbol getSymbol(RubyContext context, String string) {
        return context.getLanguageSlow().getSymbol(string);
    }

    public static final class LineTag
    extends Tag {
    }

    public static final class ClassTag
    extends Tag {
    }

    public static final class CallTag
    extends Tag {
    }

    private final class CallEventEventNode
    extends BaseEventEventNode {
        @Node.Child
        private LogicalClassNode logicalClassNode;

        public CallEventEventNode(RubyContext context, RubyLanguage language, EventContext eventContext, RubyProc traceFunc, Object event) {
            super(context, language, eventContext, traceFunc, event);
        }

        @Override
        protected void onEnter(VirtualFrame frame) {
            if (this.inTraceFuncProfile.profile(TraceManager.this.isInTraceFunc)) {
                return;
            }
            TraceManager.this.isInTraceFunc = true;
            try {
                this.callBlock(this.traceFunc, new Object[]{this.event, this.getFile(), this.getLine(), TraceManager.this.getSymbol(this.context, RubyArguments.getMethod((Frame)frame).getName()), BindingNodes.createBinding(this.context, TraceManager.this.language, frame.materialize(), this.eventContext.getInstrumentedSourceSection()), this.getLogicalClass(RubyArguments.getSelf((Frame)frame))});
            }
            finally {
                TraceManager.this.isInTraceFunc = false;
            }
        }

        private RubyClass getLogicalClass(Object object) {
            if (this.logicalClassNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.logicalClassNode = (LogicalClassNode)this.insert(LogicalClassNode.create());
            }
            return this.logicalClassNode.execute(object);
        }
    }

    private class BaseEventEventNode
    extends TraceBaseEventNode {
        protected final ConditionProfile inTraceFuncProfile;
        protected final RubyProc traceFunc;
        protected final Object event;

        public BaseEventEventNode(RubyContext context, RubyLanguage language, EventContext eventContext, RubyProc traceFunc, Object event) {
            super(context, language, eventContext);
            this.inTraceFuncProfile = ConditionProfile.create();
            this.traceFunc = traceFunc;
            this.event = event;
        }

        protected void onEnter(VirtualFrame frame) {
            if (this.inTraceFuncProfile.profile(TraceManager.this.isInTraceFunc)) {
                return;
            }
            TraceManager.this.isInTraceFunc = true;
            try {
                this.callBlock(this.traceFunc, new Object[]{this.event, this.getFile(), this.getLine(), Nil.INSTANCE, BindingNodes.createBinding(this.context, TraceManager.this.language, frame.materialize(), this.eventContext.getInstrumentedSourceSection()), Nil.INSTANCE});
            }
            finally {
                TraceManager.this.isInTraceFunc = false;
            }
        }
    }

    public static final class NeverTag
    extends Tag {
    }
}

