/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.inlined;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.inlined.InlinedIsNilNodeGen;
import org.truffleruby.core.inlined.UnaryInlinedOperationNode;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.dispatch.RubyCallNodeParameters;
import org.truffleruby.language.methods.LookupMethodOnSelfNode;

public abstract class InlinedIsNilNode
extends UnaryInlinedOperationNode {
    protected static final String METHOD = "nil?";

    public InlinedIsNilNode(RubyLanguage language, RubyCallNodeParameters callNodeParameters) {
        super(language, callNodeParameters, language.coreMethodAssumptions.nilClassIsNilAssumption);
    }

    @Specialization(assumptions={"assumptions"})
    boolean nil(Nil self) {
        return true;
    }

    @Specialization(guards={"lookup.lookupProtected(frame, self, METHOD) == coreMethods().KERNEL_IS_NIL"}, assumptions={"assumptions"}, limit="1")
    boolean notNil(VirtualFrame frame, Object self, @Cached LookupMethodOnSelfNode lookup) {
        return false;
    }

    @Specialization
    Object fallback(VirtualFrame frame, Object self) {
        return this.rewriteAndCall(frame, self, new Object[0]);
    }

    @Override
    public RubyNode cloneUninitialized() {
        InlinedIsNilNode copy = InlinedIsNilNodeGen.create(this.getLanguage(), this.parameters, this.getSelfNode().cloneUninitialized());
        return copy.copyFlags(this);
    }
}

