/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.inlined;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.inlined.BinaryInlinedOperationNode;
import org.truffleruby.core.inlined.InlinedAddNodeGen;
import org.truffleruby.core.numeric.BigIntegerOps;
import org.truffleruby.core.numeric.FixnumOrBignumNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.dispatch.RubyCallNodeParameters;

public abstract class InlinedAddNode
extends BinaryInlinedOperationNode {
    public InlinedAddNode(RubyLanguage language, RubyCallNodeParameters callNodeParameters) {
        super(language, callNodeParameters, language.coreMethodAssumptions.integerAddAssumption, language.coreMethodAssumptions.floatAddAssumption);
    }

    @Specialization(rewriteOn={ArithmeticException.class}, assumptions={"assumptions"})
    int intAdd(int a, int b) {
        return Math.addExact(a, b);
    }

    @Specialization(assumptions={"assumptions"})
    long intAddWithOverflow(int a, int b) {
        return (long)a + (long)b;
    }

    @Specialization(rewriteOn={ArithmeticException.class}, assumptions={"assumptions"})
    long longAdd(long a, long b) {
        return Math.addExact(a, b);
    }

    @Specialization(assumptions={"assumptions"})
    Object longAddWithOverflow(long a, long b, @Cached FixnumOrBignumNode fixnumOrBignum) {
        return fixnumOrBignum.execute(this, BigIntegerOps.add(a, b));
    }

    @Specialization(assumptions={"assumptions"})
    double floatAdd(double a, double b) {
        return a + b;
    }

    @Specialization(assumptions={"assumptions"})
    double longDouble(long a, double b) {
        return (double)a + b;
    }

    @Specialization(assumptions={"assumptions"})
    double doubleLong(double a, long b) {
        return a + (double)b;
    }

    @Specialization
    Object fallback(VirtualFrame frame, Object a, Object b) {
        return this.rewriteAndCall(frame, a, b);
    }

    @Override
    public RubyNode cloneUninitialized() {
        InlinedAddNode copy = InlinedAddNodeGen.create(this.getLanguage(), this.parameters, this.getLeftNode().cloneUninitialized(), this.getRightNode().cloneUninitialized());
        return copy.copyFlags(this);
    }
}

