/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.hash;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.truffleruby.core.hash.HashGuards;
import org.truffleruby.core.hash.ReHashable;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.language.dispatch.DispatchNode;

public final class PreInitializationManager {
    private final List<ReHashable> reHashables = new ArrayList<ReHashable>();
    private final Set<RubyHash> hashesCreatedDuringPreInit = Collections.newSetFromMap(new WeakHashMap());

    public void addReHashable(ReHashable reHashable) {
        for (ReHashable existing : this.reHashables) {
            if (reHashable != existing) continue;
            return;
        }
        this.reHashables.add(reHashable);
    }

    @CompilerDirectives.TruffleBoundary
    public void addPreInitHash(RubyHash hash) {
        this.hashesCreatedDuringPreInit.add(hash);
    }

    public void rehash() {
        for (ReHashable reHashable : this.reHashables) {
            reHashable.rehash();
        }
        this.reHashables.clear();
        this.rehashRubyHashes();
    }

    private void rehashRubyHashes() {
        for (RubyHash hash : this.hashesCreatedDuringPreInit) {
            if (HashGuards.isCompareByIdentity(hash)) continue;
            DispatchNode.getUncached().call(hash, "rehash");
        }
        this.hashesCreatedDuringPreInit.clear();
    }
}

