/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.hash;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.hash.library.BucketsHashStore;
import org.truffleruby.core.hash.library.CompactHashStore;
import org.truffleruby.core.hash.library.EmptyHashStore;
import org.truffleruby.core.hash.library.PackedHashStoreLibraryFactory;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyContextSourceNodeCustomExecuteVoid;
import org.truffleruby.language.RubyNode;

public abstract class HashLiteralNode
extends RubyContextSourceNodeCustomExecuteVoid {
    @Node.Children
    protected final RubyNode[] keyValues;

    protected HashLiteralNode(RubyNode[] keyValues) {
        assert (keyValues.length % 2 == 0);
        this.keyValues = keyValues;
    }

    protected int getNumberOfEntries() {
        return this.keyValues.length >> 1;
    }

    public static HashLiteralNode create(RubyNode[] keyValues, RubyLanguage language) {
        if (keyValues.length == 0) {
            return new EmptyHashStore.EmptyHashLiteralNode();
        }
        if (keyValues.length <= 6) {
            return PackedHashStoreLibraryFactory.SmallHashLiteralNodeGen.create(keyValues);
        }
        return language.options.BIG_HASH_STRATEGY_IS_BUCKETS ? new BucketsHashStore.BucketHashLiteralNode(keyValues) : new CompactHashStore.CompactHashLiteralNode(keyValues);
    }

    @Override
    @ExplodeLoop
    public final Nil executeVoid(VirtualFrame frame) {
        for (RubyNode child : this.keyValues) {
            child.executeVoid(frame);
        }
        return nil;
    }
}

