/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.hash;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.dispatch.DispatchNode;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class FreezeHashKeyIfNeededNode
extends RubyBaseNode {
    public abstract Object executeFreezeIfNeeded(Node var1, Object var2, boolean var3);

    @Specialization
    static Object immutable(ImmutableRubyString string, boolean compareByIdentity) {
        return string;
    }

    @Specialization(guards={"string.isFrozen()"})
    static Object alreadyFrozen(RubyString string, boolean compareByIdentity) {
        return string;
    }

    @Specialization(guards={"!string.isFrozen()", "!compareByIdentity"})
    static Object dupAndFreeze(RubyString string, boolean compareByIdentity, @Cached(inline=false) DispatchNode dupNode) {
        RubyString copy = (RubyString)((Object)dupNode.call((Object)string, "dup"));
        copy.freeze();
        return copy;
    }

    @Specialization(guards={"!string.isFrozen()", "compareByIdentity"})
    static Object compareByIdentity(RubyString string, boolean compareByIdentity) {
        return string;
    }

    @Specialization(guards={"isNotRubyString(value)"})
    static Object passThrough(Object value, boolean compareByIdentity) {
        return value;
    }
}

