/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.hash;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.core.hash.HashOperations;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.dispatch.DispatchNode;

public final class ConcatHashLiteralNode
extends RubyContextSourceNode {
    @Node.Children
    private final RubyNode[] children;
    @Node.Child
    private DispatchNode hashMergeNode;

    public ConcatHashLiteralNode(RubyNode[] children) {
        assert (children.length > 1);
        this.children = children;
    }

    @Override
    @ExplodeLoop
    public Object execute(VirtualFrame frame) {
        RubyHash hash = HashOperations.newEmptyHash(this.getContext(), this.getLanguage());
        if (this.hashMergeNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.hashMergeNode = (DispatchNode)this.insert(DispatchNode.create());
        }
        for (int i = 0; i < this.children.length; ++i) {
            this.hashMergeNode.call((Object)hash, "merge!", this.children[i].execute(frame));
        }
        return hash;
    }

    @Override
    public RubyNode cloneUninitialized() {
        ConcatHashLiteralNode copy = new ConcatHashLiteralNode(ConcatHashLiteralNode.cloneUninitialized(this.children));
        return copy.copyFlags(this);
    }
}

