/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.write.bytes;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.language.Nil;
import org.truffleruby.language.library.RubyStringLibrary;

@NodeChild(value="value")
public abstract class WriteBinaryStringNode
extends FormatNode {
    private final boolean pad;
    private final boolean padOnNil;
    private final int width;
    private final byte padding;
    private final boolean takeAll;
    private final boolean appendNull;

    public WriteBinaryStringNode(boolean pad, boolean padOnNil, int width, byte padding, boolean takeAll, boolean appendNull) {
        this.pad = pad;
        this.padOnNil = padOnNil;
        this.width = width;
        this.padding = padding;
        this.takeAll = takeAll;
        this.appendNull = appendNull;
    }

    @Specialization
    Object write(VirtualFrame frame, Nil nil) {
        if (this.padOnNil) {
            for (int n = 0; n < this.width; ++n) {
                this.writeByte(frame, this.padding);
            }
        } else if (this.appendNull) {
            this.writeByte(frame, (byte)0);
        }
        return null;
    }

    @Fallback
    Object write(VirtualFrame frame, Object string, @Cached RubyStringLibrary libString, @Cached TruffleString.GetInternalByteArrayNode getInternalByteArrayNode) {
        AbstractTruffleString tstring = libString.getTString(this, string);
        InternalByteArray byteArray = getInternalByteArrayNode.execute(tstring, libString.getTEncoding(this, string));
        this.write(frame, byteArray.getArray(), byteArray.getOffset(), byteArray.getLength());
        return null;
    }

    private void write(VirtualFrame frame, byte[] bytes, int offset, int length) {
        int lengthFromBytes = this.takeAll ? length : Math.min(this.width, length);
        if (this.pad) {
            int lengthFromPadding = this.width - lengthFromBytes;
            WriteBinaryStringNode.writeBytes(frame, bytes, offset, lengthFromBytes);
            for (int n = 0; n < lengthFromPadding; ++n) {
                this.writeByte(frame, this.padding);
            }
        } else {
            WriteBinaryStringNode.writeBytes(frame, bytes, offset, lengthFromBytes);
        }
        if (this.appendNull) {
            this.writeByte(frame, (byte)0);
        }
    }
}

