/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.read.bytes;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Arrays;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.format.read.SourceNode;
import org.truffleruby.core.string.RubyString;

@NodeChild(value="source", type=SourceNode.class)
public abstract class ReadBinaryStringNode
extends FormatNode {
    final boolean readToEnd;
    final boolean readToNull;
    final int count;
    final boolean trimTrailingSpaces;
    final boolean trimTrailingNulls;
    final boolean trimToFirstNull;

    public ReadBinaryStringNode(boolean readToEnd, boolean readToNull, int count, boolean trimTrailingSpaces, boolean trimTrailingNulls, boolean trimToFirstNull) {
        this.readToEnd = readToEnd;
        this.readToNull = readToNull;
        this.count = count;
        this.trimTrailingSpaces = trimTrailingSpaces;
        this.trimTrailingNulls = trimTrailingNulls;
        this.trimToFirstNull = trimToFirstNull;
    }

    @Specialization(guards={"isNull(source)"})
    void read(VirtualFrame frame, Object source) {
        this.advanceSourcePosition(frame, this.count);
        throw new IllegalStateException();
    }

    @Specialization
    RubyString read(VirtualFrame frame, byte[] source, @Cached TruffleString.FromByteArrayNode fromByteArrayNode) {
        int firstNull;
        int usedLength;
        int length;
        int start = this.getSourcePosition(frame);
        int end = this.getSourceEnd(frame);
        if (this.readToEnd) {
            length = 0;
            while (start + length < end && (!this.readToNull || start + length < end && source[start + length] != 0)) {
                ++length;
            }
            if (start + length < end && source[start + length] == 0) {
                ++length;
            }
        } else if (this.readToNull) {
            for (length = 0; start + length < end && length < this.count && source[start + length] != 0; ++length) {
            }
        } else {
            length = this.count;
            if (start + length >= end) {
                length = end - start;
            }
        }
        for (usedLength = length; usedLength > 0 && (this.trimTrailingSpaces && source[start + usedLength - 1] == 32 || this.trimTrailingNulls && source[start + usedLength - 1] == 0); --usedLength) {
        }
        if (this.trimToFirstNull && (firstNull = this.indexOfFirstNull(source, start, usedLength)) != -1 && this.trimTrailingNulls) {
            usedLength = firstNull;
        }
        this.setSourcePosition(frame, start + length);
        return this.createString(fromByteArrayNode, Arrays.copyOfRange(source, start, start + usedLength), Encodings.BINARY);
    }

    private int indexOfFirstNull(byte[] bytes, int start, int length) {
        for (int n = 0; n < length; ++n) {
            if (bytes[start + n] != 0) continue;
            return n;
        }
        return -1;
    }
}

