/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.read.bytes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.format.read.SourceNode;
import org.truffleruby.core.numeric.FixnumOrBignumNode;

@NodeChild(value="source", type=SourceNode.class)
public abstract class ReadBERNode
extends FormatNode {
    private static final long UL_MASK = -33554432L;
    private static final BigInteger BIG_128 = BigInteger.valueOf(128L);
    private final ConditionProfile simpleProfile = ConditionProfile.create();

    @Specialization
    Object encode(VirtualFrame frame, byte[] source, @Cached FixnumOrBignumNode fixnumOrBignumNode) {
        ByteBuffer encode = this.wrapByteBuffer(frame, source);
        int position = encode.position();
        long ul = encode.get(position) & 0x7F;
        if (this.simpleProfile.profile((encode.get(position) & 0x80) == 0)) {
            this.setSourcePosition(frame, ++position);
            return ul;
        }
        ++position;
        assert ((ul & 0xFFFFFFFFFE000000L) == 0L);
        BigIntegerAndPos bigIntegerAndPos = this.runLoop(encode, ul, position);
        this.setSourcePosition(frame, bigIntegerAndPos.getPos());
        return fixnumOrBignumNode.execute(this, bigIntegerAndPos.getBigInteger());
    }

    @CompilerDirectives.TruffleBoundary
    private BigIntegerAndPos runLoop(ByteBuffer encode, long ul, int pos) {
        BigInteger big = BigInteger.valueOf(ul);
        do {
            assert (pos < encode.limit());
            big = big.multiply(BIG_128);
            big = big.add(BigInteger.valueOf(encode.get(pos) & 0x7F));
        } while ((encode.get(pos++) & 0x80) != 0);
        return new BigIntegerAndPos(big, pos);
    }

    private static final class BigIntegerAndPos {
        private final BigInteger bigInteger;
        private final int pos;

        public BigIntegerAndPos(BigInteger bigInteger, int pos) {
            this.bigInteger = bigInteger;
            this.pos = pos;
        }

        public BigInteger getBigInteger() {
            return this.bigInteger;
        }

        public int getPos() {
            return this.pos;
        }
    }
}

