/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.pack;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.format.FormatEncoding;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.format.LiteralFormatNode;
import org.truffleruby.core.format.SharedTreeBuilder;
import org.truffleruby.core.format.control.ReverseOutputPositionNode;
import org.truffleruby.core.format.control.SetOutputPositionNode;
import org.truffleruby.core.format.convert.Integer16BigToBytesNodeGen;
import org.truffleruby.core.format.convert.Integer16LittleToBytesNodeGen;
import org.truffleruby.core.format.convert.Integer32BigToBytesNodeGen;
import org.truffleruby.core.format.convert.Integer32LittleToBytesNodeGen;
import org.truffleruby.core.format.convert.Integer64BigToBytesNodeGen;
import org.truffleruby.core.format.convert.Integer64LittleToBytesNodeGen;
import org.truffleruby.core.format.convert.ReinterpretAsLongNodeGen;
import org.truffleruby.core.format.convert.StringToPointerNodeGen;
import org.truffleruby.core.format.convert.ToLongNode;
import org.truffleruby.core.format.convert.ToLongNodeGen;
import org.truffleruby.core.format.convert.ToStringObjectNodeGen;
import org.truffleruby.core.format.pack.SimplePackListener;
import org.truffleruby.core.format.read.SourceNode;
import org.truffleruby.core.format.read.array.ReadDoubleNode;
import org.truffleruby.core.format.read.array.ReadDoubleNodeGen;
import org.truffleruby.core.format.read.array.ReadLongOrBigIntegerNodeGen;
import org.truffleruby.core.format.read.array.ReadStringNodeGen;
import org.truffleruby.core.format.read.array.ReadValueNodeGen;
import org.truffleruby.core.format.write.bytes.WriteBERNodeGen;
import org.truffleruby.core.format.write.bytes.WriteBase64StringNodeGen;
import org.truffleruby.core.format.write.bytes.WriteBinaryStringNodeGen;
import org.truffleruby.core.format.write.bytes.WriteBitStringNodeGen;
import org.truffleruby.core.format.write.bytes.WriteByteNodeGen;
import org.truffleruby.core.format.write.bytes.WriteBytesNodeGen;
import org.truffleruby.core.format.write.bytes.WriteHexStringNodeGen;
import org.truffleruby.core.format.write.bytes.WriteMIMEStringNodeGen;
import org.truffleruby.core.format.write.bytes.WriteUTF8CharacterNodeGen;
import org.truffleruby.core.format.write.bytes.WriteUUStringNodeGen;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.WarningNode;
import org.truffleruby.language.control.DeferredRaiseException;

public final class SimplePackTreeBuilder
implements SimplePackListener {
    private final Node currentNode;
    private final SharedTreeBuilder sharedTreeBuilder;
    private FormatEncoding encoding = FormatEncoding.DEFAULT;
    private final Deque<List<FormatNode>> sequenceStack = new ArrayDeque<List<FormatNode>>();

    public SimplePackTreeBuilder(RubyLanguage language, Node currentNode) {
        this.currentNode = currentNode;
        this.sharedTreeBuilder = new SharedTreeBuilder(language);
        this.pushSequence();
    }

    public void enterSequence() {
        this.pushSequence();
    }

    public void exitSequence() {
        List<FormatNode> sequence = this.sequenceStack.pop();
        this.appendNode(SharedTreeBuilder.createSequence(sequence.toArray(FormatNode.EMPTY_ARRAY)));
    }

    @Override
    public void integer(int size, boolean signed, ByteOrder byteOrder, int count) {
        this.appendIntegerNode(size, byteOrder, count);
    }

    @Override
    public void floatingPoint(int size, ByteOrder byteOrder, int count) {
        this.appendFloatNode(size, byteOrder, count);
    }

    @Override
    public void utf8Character(int count) {
        this.unify(FormatEncoding.UTF_8);
        this.appendNode(this.sharedTreeBuilder.applyCount(count, WriteUTF8CharacterNodeGen.create(ToLongNodeGen.create(false, ReadValueNodeGen.create(new SourceNode())))));
    }

    @Override
    public void berInteger(int count) {
        this.appendNode(this.sharedTreeBuilder.applyCount(count, WriteBERNodeGen.create(ReadLongOrBigIntegerNodeGen.create(new SourceNode()))));
    }

    @Override
    public void binaryStringSpacePadded(int count) {
        this.binaryString((byte)32, true, false, count);
    }

    @Override
    public void binaryStringNullPadded(int count) {
        this.binaryString((byte)0, true, false, count);
    }

    @Override
    public void binaryStringNullStar(int count) {
        this.binaryString((byte)0, true, count == -2, count);
    }

    @Override
    public void bitStringMSBFirst(int count) {
        this.bitString(ByteOrder.BIG_ENDIAN, count);
    }

    @Override
    public void bitStringMSBLast(int count) {
        this.bitString(ByteOrder.LITTLE_ENDIAN, count);
    }

    @Override
    public void hexStringHighFirst(int count) {
        this.hexString(ByteOrder.BIG_ENDIAN, count);
    }

    @Override
    public void hexStringLowFirst(int count) {
        this.hexString(ByteOrder.LITTLE_ENDIAN, count);
    }

    @Override
    public void uuString(int count) {
        this.unify(FormatEncoding.US_ASCII);
        SharedTreeBuilder.StarLength starLength = this.sharedTreeBuilder.parseCountContext(count);
        this.appendNode(WriteUUStringNodeGen.create(starLength.getLength(), starLength.isStar(), ReadStringNodeGen.create(false, "to_str", false, Nil.INSTANCE, new SourceNode())));
    }

    @Override
    public void mimeString(int count) {
        int length;
        this.unify(FormatEncoding.US_ASCII);
        if (count == -2) {
            length = 72;
        } else {
            length = count;
            if (length <= 1) {
                length = 72;
            }
        }
        this.appendNode(WriteMIMEStringNodeGen.create(length, ReadStringNodeGen.create(true, "to_s", true, RubyBaseNode.nil, new SourceNode())));
    }

    @Override
    public void base64String(int count) {
        this.unify(FormatEncoding.US_ASCII);
        SharedTreeBuilder.StarLength starLength = this.sharedTreeBuilder.parseCountContext(count);
        this.appendNode(WriteBase64StringNodeGen.create(starLength.getLength(), starLength.isStar(), ReadStringNodeGen.create(false, "to_str", false, Nil.INSTANCE, new SourceNode())));
    }

    @Override
    public void pointer(int count, int limit) {
        this.appendNode(this.sharedTreeBuilder.applyCount(count, this.writeInteger(64, ByteOrder.nativeOrder(), StringToPointerNodeGen.create(ToStringObjectNodeGen.create(ReadValueNodeGen.create(new SourceNode()))))));
    }

    @Override
    public void at(int position) {
        if (position == -1) {
            position = 1;
        } else if (position == -2) {
            throw new UnsupportedOperationException();
        }
        this.appendNode(new SetOutputPositionNode(position));
    }

    @Override
    public void back(int count) {
        if (count == -1 || count >= 0) {
            this.appendNode(this.sharedTreeBuilder.applyCount(count, new ReverseOutputPositionNode()));
        }
    }

    @Override
    public void nullByte(int count) {
        if (count != -2) {
            this.appendNode(this.sharedTreeBuilder.applyCount(count, WriteByteNodeGen.create(new LiteralFormatNode((byte)0))));
        }
    }

    @Override
    public void startSubSequence() {
        this.pushSequence();
    }

    @Override
    public void finishSubSequence(int count) {
        this.appendNode(this.sharedTreeBuilder.finishSubSequence(this.sequenceStack, count));
    }

    @Override
    public void error(String message) throws DeferredRaiseException {
        throw new DeferredRaiseException(c -> c.getCoreExceptions().argumentError(message, this.currentNode));
    }

    @Override
    public void warn(String message) {
        WarningNode.UncachedWarningNode warningNode = WarningNode.UncachedWarningNode.INSTANCE;
        if (warningNode.shouldWarn()) {
            warningNode.warningMessage(this.currentNode.getSourceSection(), message);
        }
    }

    @Override
    public String packListenerMode() {
        return "pack";
    }

    public FormatNode getNode() {
        return this.sequenceStack.peek().get(0);
    }

    public FormatEncoding getEncoding() {
        return this.encoding;
    }

    private void pushSequence() {
        this.sequenceStack.push(new ArrayList());
    }

    private void appendNode(FormatNode node) {
        this.sequenceStack.peek().add(node);
    }

    private void appendIntegerNode(int size, ByteOrder byteOrder, int count) {
        this.appendNode(this.sharedTreeBuilder.applyCount(count, this.writeInteger(size, byteOrder)));
    }

    private void appendFloatNode(int size, ByteOrder byteOrder, int count) {
        ReadDoubleNode readNode = ReadDoubleNodeGen.create(new SourceNode());
        this.appendNode(this.sharedTreeBuilder.applyCount(count, this.writeInteger(size, byteOrder, ReinterpretAsLongNodeGen.create(size, readNode))));
    }

    private FormatNode writeInteger(int size, ByteOrder byteOrder) {
        ToLongNode readNode = ToLongNodeGen.create(false, ReadValueNodeGen.create(new SourceNode()));
        return this.writeInteger(size, byteOrder, readNode);
    }

    private FormatNode writeInteger(int size, ByteOrder byteOrder, FormatNode readNode) {
        FormatNode convertNode;
        switch (size) {
            case 8: {
                return WriteByteNodeGen.create(readNode);
            }
            case 16: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    convertNode = Integer16LittleToBytesNodeGen.create(readNode);
                    break;
                }
                convertNode = Integer16BigToBytesNodeGen.create(readNode);
                break;
            }
            case 32: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    convertNode = Integer32LittleToBytesNodeGen.create(readNode);
                    break;
                }
                convertNode = Integer32BigToBytesNodeGen.create(readNode);
                break;
            }
            case 64: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    convertNode = Integer64LittleToBytesNodeGen.create(readNode);
                    break;
                }
                convertNode = Integer64BigToBytesNodeGen.create(readNode);
                break;
            }
            default: {
                throw CompilerDirectives.shouldNotReachHere((String)Integer.toString(size));
            }
        }
        return WriteBytesNodeGen.create(convertNode);
    }

    private void binaryString(byte padding, boolean padOnNull, boolean appendNull, int count) {
        int width;
        boolean pad;
        this.unify(FormatEncoding.ASCII_8BIT);
        if (count >= 0) {
            pad = true;
            width = count;
        } else {
            pad = false;
            if (count == -2) {
                padOnNull = false;
            }
            width = 1;
        }
        boolean takeAll = count == -2;
        this.appendNode(WriteBinaryStringNodeGen.create(pad, padOnNull, width, padding, takeAll, appendNull, ReadStringNodeGen.create(false, "to_str", false, Nil.INSTANCE, new SourceNode())));
    }

    private void bitString(ByteOrder byteOrder, int count) {
        SharedTreeBuilder.StarLength starLength = this.sharedTreeBuilder.parseCountContext(count);
        this.appendNode(WriteBitStringNodeGen.create(byteOrder, starLength.isStar(), starLength.getLength(), ReadStringNodeGen.create(false, "to_str", false, Nil.INSTANCE, new SourceNode())));
    }

    private void hexString(ByteOrder byteOrder, int count) {
        int length = count == -1 ? 1 : (count == -2 ? -1 : count);
        this.appendNode(WriteHexStringNodeGen.create(byteOrder, length, ReadStringNodeGen.create(false, "to_str", false, Nil.INSTANCE, new SourceNode())));
    }

    private void unify(FormatEncoding other) {
        this.encoding = this.encoding.unifyWith(other);
    }
}

