/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.format;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.truffleruby.core.format.format.FormatFloatGenericNode;
import org.truffleruby.core.string.StringOperations;

@ImportStatic(value={Double.class})
public abstract class FormatEFloatNode
extends FormatFloatGenericNode {
    private final char expSeparator;

    public FormatEFloatNode(char expSeparator, boolean hasSpaceFlag, boolean hasZeroFlag, boolean hasPlusFlag, boolean hasMinusFlag, boolean hasFSharpFlag) {
        super(hasSpaceFlag, hasZeroFlag, hasPlusFlag, hasMinusFlag, hasFSharpFlag);
        this.expSeparator = expSeparator;
    }

    @Specialization(guards={"nonSpecialValue(dval)"})
    byte[] formatFGeneric(int width, int precision, Object dval) {
        return this.formatNumber(width, precision, dval);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected byte[] doFormat(int precision, Object value) {
        DecimalFormat format;
        if (precision == Integer.MIN_VALUE) {
            precision = 6;
        }
        if ((format = this.getLanguage().getCurrentThread().formatEFloat) == null) {
            DecimalFormatSymbols formatSymbols = new DecimalFormatSymbols(Locale.ENGLISH);
            this.getLanguage().getCurrentThread().formatEFloat = format = new DecimalFormat("0.0E00", formatSymbols);
        }
        if (this.hasPlusFlag) {
            format.setPositivePrefix("+");
        } else if (this.hasSpaceFlag) {
            format.setPositivePrefix(" ");
        } else {
            format.setPositivePrefix("");
        }
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        if (precision == 0 && this.hasFSharpFlag) {
            format.setDecimalSeparatorAlwaysShown(true);
        } else {
            format.setDecimalSeparatorAlwaysShown(false);
        }
        Object separator = Character.toString(this.expSeparator);
        if (this.hasPositiveExponent(value)) {
            separator = (String)separator + "+";
        }
        symbols.setExponentSeparator((String)separator);
        format.setDecimalFormatSymbols(symbols);
        format.setMinimumFractionDigits(precision);
        format.setMaximumFractionDigits(precision);
        byte[] digits = StringOperations.encodeAsciiBytes(format.format(value));
        return digits;
    }

    private boolean hasPositiveExponent(Object value) {
        if (value instanceof Double) {
            double dval = (Double)value;
            return Math.abs(dval) >= 1.0 || dval == 0.0;
        }
        return true;
    }
}

