/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import org.truffleruby.core.cast.ToFNode;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.format.convert.ToDoubleNodeGen;
import org.truffleruby.core.numeric.RubyBignum;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.objects.IsANode;

@NodeChild(value="value")
public abstract class ToDoubleNode
extends FormatNode {
    @NeverDefault
    public static ToDoubleNode create() {
        return ToDoubleNodeGen.create(null);
    }

    public abstract double executeToDouble(Object var1);

    @Specialization
    double toDouble(int value) {
        return value;
    }

    @Specialization
    double toDouble(long value) {
        return value;
    }

    @Specialization
    double toDouble(double value) {
        return value;
    }

    @Specialization
    @CompilerDirectives.TruffleBoundary
    double toDouble(RubyBignum bignum) {
        return bignum.value.doubleValue();
    }

    @Specialization(guards={"!isRubyNumber(object)", "isNumeric(object, isANode)"})
    double toDouble(RubyDynamicObject object, @Cached @Cached.Shared IsANode isANode, @Cached ToFNode toFNode) {
        return toFNode.executeToDouble((Object)object);
    }

    @Specialization(guards={"!isRubyNumber(object)", "!isNumeric(object, isANode)"})
    double toDouble(Object object, @Cached @Cached.Shared IsANode isANode) {
        throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorCantConvertInto(object, "Float", this));
    }

    protected boolean isNumeric(Object object, IsANode isANode) {
        return isANode.executeIsA(object, this.coreLibrary().numericClass);
    }
}

