/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.ArrayList;
import java.util.List;
import org.truffleruby.cext.CExtNodes;
import org.truffleruby.core.format.FormatFrameDescriptor;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.extra.ffi.Pointer;
import org.truffleruby.language.Nil;
import org.truffleruby.language.library.RubyStringLibrary;

@NodeChild(value="value")
public abstract class StringToPointerNode
extends FormatNode {
    @Specialization
    long toPointer(Nil nil) {
        return 0L;
    }

    @Specialization(guards={"strings.isRubyString(this, string)"}, limit="1")
    static long toPointer(VirtualFrame frame, Object string, @Cached CExtNodes.StringToNativeNode stringToNativeNode, @Cached RubyStringLibrary strings, @Bind(value="this") Node node) {
        Pointer pointer = stringToNativeNode.executeToNative(node, string, true);
        ArrayList associated = (ArrayList)frame.getObject(FormatFrameDescriptor.ASSOCIATED_SLOT);
        if (associated == null) {
            associated = new ArrayList();
            frame.setObject(FormatFrameDescriptor.ASSOCIATED_SLOT, associated);
        }
        StringToPointerNode.add(associated, pointer);
        return pointer.getAddress();
    }

    @CompilerDirectives.TruffleBoundary
    private static void add(List<Pointer> list, Pointer ptr) {
        list.add(ptr);
    }
}

