/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.convert;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.memory.ByteArraySupport;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.format.MissingValue;
import org.truffleruby.core.numeric.BigIntegerOps;
import org.truffleruby.language.Nil;

@NodeChild(value="bytes")
public abstract class BytesToInteger64BigNode
extends FormatNode {
    private final boolean signed;

    protected BytesToInteger64BigNode(boolean signed) {
        this.signed = signed;
    }

    @Specialization
    MissingValue decode(MissingValue missingValue) {
        return missingValue;
    }

    @Specialization
    Object decode(Nil nil) {
        return nil;
    }

    @Specialization
    Object decode(byte[] bytes) {
        long value = ByteArraySupport.bigEndian().getLong(bytes, 0);
        if (this.signed) {
            return value;
        }
        return BigIntegerOps.asUnsignedFixnumOrBignum(value);
    }
}

