/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.fiber;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.cast.SingleValueCastNode;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.fiber.FiberManager;
import org.truffleruby.core.fiber.FiberOperation;
import org.truffleruby.core.fiber.RubyFiber;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.thread.RubyThread;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.arguments.ArgumentsDescriptor;
import org.truffleruby.language.arguments.NoKeywordArgumentsDescriptor;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.objects.AllocationTracing;

@CoreModule(value="Fiber", isClass=true)
public abstract class FiberNodes {

    @Primitive(name="fiber_set_error_info")
    public static abstract class FiberSetErrorInfoNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object setErrorInfo(Object exception) {
            this.getLanguage().getCurrentFiber().errorInfo = exception;
            return exception;
        }
    }

    @Primitive(name="fiber_get_error_info")
    public static abstract class FiberGetErrorInfoNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object getErrorInfo() {
            return this.getLanguage().getCurrentFiber().errorInfo;
        }
    }

    @Primitive(name="fiber_c_global_variables")
    public static abstract class FiberCGlobalVariablesNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object cGlobalVariables() {
            RubyFiber currentFiber = this.getLanguage().getCurrentFiber();
            RubyArray cGlobalVariablesDuringInitFunction = currentFiber.cGlobalVariablesDuringInitFunction;
            if (cGlobalVariablesDuringInitFunction == null) {
                return nil;
            }
            return cGlobalVariablesDuringInitFunction;
        }
    }

    @CoreMethod(names={"blocking?"}, onSingleton=true)
    public static abstract class IsBlockingNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object isBlocking() {
            RubyFiber currentFiber = this.getLanguage().getCurrentFiber();
            if (currentFiber.blocking) {
                return 1;
            }
            return false;
        }
    }

    @CoreMethod(names={"blocking?"})
    public static abstract class IsBlockingInstanceNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isBlocking(RubyFiber fiber) {
            return fiber.blocking;
        }
    }

    @Primitive(name="fiber_get_catch_tags")
    public static abstract class FiberGetCatchTagsNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyArray getCatchTags() {
            RubyFiber currentFiber = this.getLanguage().getCurrentFiber();
            return currentFiber.catchTags;
        }
    }

    @Primitive(name="fiber_get_exception")
    public static abstract class FiberGetExceptionNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object getException() {
            return FiberGetExceptionNode.getLastException(this.getLanguage());
        }

        public static Object getLastException(RubyLanguage language) {
            return language.getCurrentFiber().getLastException();
        }
    }

    @Primitive(name="fiber_thread")
    public static abstract class FiberThreadNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyThread thread(RubyFiber fiber) {
            return fiber.rubyThread;
        }
    }

    @Primitive(name="fiber_status")
    public static abstract class FiberStatusNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyString status(RubyFiber fiber, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            return this.createString(fromJavaStringNode, fiber.status.label, Encodings.UTF_8);
        }
    }

    @Primitive(name="fiber_source_location")
    public static abstract class FiberSourceLocationNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyString sourceLocation(RubyFiber fiber, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            return this.createString(fromJavaStringNode, fiber.sourceLocation, Encodings.UTF_8);
        }
    }

    @CoreMethod(names={"current"}, onSingleton=true)
    public static abstract class CurrentNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyFiber current() {
            return this.getLanguage().getCurrentFiber();
        }
    }

    @CoreMethod(names={"alive?"})
    public static abstract class AliveNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean alive(RubyFiber fiber) {
            return fiber.status != RubyFiber.FiberStatus.TERMINATED;
        }
    }

    @CoreMethod(names={"yield"}, onSingleton=true, rest=true)
    public static abstract class YieldNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object fiberYield(VirtualFrame frame, Object[] rawArgs, @Cached FiberTransferNode fiberTransferNode, @Cached InlinedBranchProfile errorProfile) {
            RubyFiber currentFiber = this.getLanguage().getCurrentFiber();
            RubyFiber fiberYieldedTo = this.getContext().fiberManager.getReturnFiber(currentFiber, this, errorProfile);
            return fiberTransferNode.execute(this, currentFiber, fiberYieldedTo, FiberOperation.YIELD, RubyArguments.getDescriptor((Frame)frame), rawArgs);
        }
    }

    @CoreMethod(names={"resume"}, rest=true)
    public static abstract class ResumeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object resume(VirtualFrame frame, RubyFiber fiber, Object[] rawArgs, @Cached FiberResumeNode fiberResumeNode) {
            return fiberResumeNode.execute(this, FiberOperation.RESUME, fiber, RubyArguments.getDescriptor((Frame)frame), rawArgs);
        }
    }

    @Primitive(name="fiber_raise")
    public static abstract class FiberRaiseNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object raise(RubyFiber fiber, RubyException exception, @Cached FiberResumeNode fiberResumeNode, @Cached FiberTransferNode fiberTransferNode, @Cached InlinedBranchProfile errorProfile) {
            if (fiber.resumingFiber != null) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().fiberError("attempt to raise a resuming fiber", this));
            }
            if (fiber.status == RubyFiber.FiberStatus.CREATED) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().fiberError("cannot raise exception on unborn fiber", this));
            }
            if (fiber.status == RubyFiber.FiberStatus.SUSPENDED && !fiber.yielding) {
                RubyFiber currentFiber = this.getLanguage().getCurrentFiber();
                return fiberTransferNode.execute(this, currentFiber, fiber, FiberOperation.RAISE, NoKeywordArgumentsDescriptor.INSTANCE, new Object[]{exception});
            }
            return fiberResumeNode.execute(this, FiberOperation.RAISE, fiber, NoKeywordArgumentsDescriptor.INSTANCE, new Object[]{exception});
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class FiberResumeNode
    extends RubyBaseNode {
        public abstract Object execute(Node var1, FiberOperation var2, RubyFiber var3, ArgumentsDescriptor var4, Object[] var5);

        @Specialization
        static Object resume(Node node, FiberOperation operation, RubyFiber toFiber, ArgumentsDescriptor descriptor, Object[] args, @Cached FiberTransferNode fiberTransferNode, @Cached InlinedBranchProfile errorProfile) {
            RubyFiber currentFiber = FiberResumeNode.getLanguage(node).getCurrentFiber();
            if (toFiber.isTerminated()) {
                errorProfile.enter(node);
                throw new RaiseException(FiberResumeNode.getContext(node), FiberResumeNode.coreExceptions(node).fiberError("attempt to resume a terminated fiber", node));
            }
            if (toFiber == currentFiber) {
                errorProfile.enter(node);
                throw new RaiseException(FiberResumeNode.getContext(node), FiberResumeNode.coreExceptions(node).fiberError("attempt to resume the current fiber", node));
            }
            if (toFiber.lastResumedByFiber != null) {
                errorProfile.enter(node);
                throw new RaiseException(FiberResumeNode.getContext(node), FiberResumeNode.coreExceptions(node).fiberError("attempt to resume a resumed fiber (double resume)", node));
            }
            if (toFiber.resumingFiber != null) {
                errorProfile.enter(node);
                throw new RaiseException(FiberResumeNode.getContext(node), FiberResumeNode.coreExceptions(node).fiberError("attempt to resume a resuming fiber", node));
            }
            if (toFiber.lastResumedByFiber == null && !toFiber.yielding && toFiber.status != RubyFiber.FiberStatus.CREATED) {
                errorProfile.enter(node);
                throw new RaiseException(FiberResumeNode.getContext(node), FiberResumeNode.coreExceptions(node).fiberError("attempt to resume a transferring fiber", node));
            }
            return fiberTransferNode.execute(node, currentFiber, toFiber, operation, descriptor, args);
        }
    }

    @CoreMethod(names={"transfer"}, rest=true)
    public static abstract class TransferNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object transfer(VirtualFrame frame, RubyFiber toFiber, Object[] rawArgs, @Cached FiberTransferNode fiberTransferNode, @Cached SingleValueCastNode singleValueCastNode, @Cached InlinedConditionProfile sameFiberProfile, @Cached InlinedBranchProfile errorProfile) {
            if (toFiber.resumingFiber != null) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().fiberError("attempt to transfer to a resuming fiber", this));
            }
            if (toFiber.yielding) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().fiberError("attempt to transfer to a yielding fiber", this));
            }
            RubyFiber currentFiber = this.getLanguage().getCurrentFiber();
            if (sameFiberProfile.profile((Node)this, currentFiber == toFiber)) {
                return singleValueCastNode.execute(this, rawArgs);
            }
            return fiberTransferNode.execute(this, currentFiber, toFiber, FiberOperation.TRANSFER, RubyArguments.getDescriptor((Frame)frame), rawArgs);
        }
    }

    @Primitive(name="fiber_initialize")
    public static abstract class InitializeNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object initialize(RubyFiber fiber, boolean blocking, RubyProc block) {
            if (!this.getContext().getEnv().isCreateThreadAllowed()) {
                throw new RaiseException(this.getContext(), this.coreExceptions().securityError("fibers not allowed with allowCreateThread(false)", this));
            }
            fiber.initialize(this.getLanguage(), this.getContext(), blocking, block, this);
            return nil;
        }

        @Specialization
        Object noBlock(RubyFiber fiber, boolean blocking, Nil block) {
            throw new RaiseException(this.getContext(), this.coreExceptions().argumentErrorProcWithoutBlock(this));
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyFiber allocate(RubyClass rubyClass) {
            if (this.getContext().getOptions().BACKTRACE_ON_NEW_FIBER) {
                this.getContext().getDefaultBacktraceFormatter().printBacktraceOnEnvStderr("fiber: ", this);
            }
            RubyThread thread = this.getLanguage().getCurrentThread();
            RubyFiber fiber = new RubyFiber(rubyClass, this.getLanguage().fiberShape, this.getContext(), this.getLanguage(), thread, RubyFiber.FiberStatus.CREATED, "<uninitialized>");
            AllocationTracing.trace(fiber, this);
            return fiber;
        }
    }

    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class FiberTransferNode
    extends RubyBaseNode {
        public abstract Object execute(Node var1, RubyFiber var2, RubyFiber var3, FiberOperation var4, ArgumentsDescriptor var5, Object[] var6);

        @Specialization
        static Object transfer(Node node, RubyFiber currentFiber, RubyFiber toFiber, FiberOperation operation, ArgumentsDescriptor descriptor, Object[] args, @Cached SingleValueCastNode singleValueCastNode, @Cached InlinedBranchProfile errorProfile) {
            if (toFiber.isTerminated()) {
                errorProfile.enter(node);
                throw new RaiseException(FiberTransferNode.getContext(node), FiberTransferNode.coreExceptions(node).deadFiberCalledError(node));
            }
            if (toFiber.rubyThread != currentFiber.rubyThread) {
                errorProfile.enter(node);
                throw new RaiseException(FiberTransferNode.getContext(node), FiberTransferNode.coreExceptions(node).fiberError("fiber called across threads", node));
            }
            FiberManager.DescriptorAndArgs descriptorAndArgs = FiberTransferNode.getContext((Node)node).fiberManager.transferControlTo(currentFiber, toFiber, operation, descriptor, args, node);
            return singleValueCastNode.execute(node, descriptorAndArgs.args);
        }
    }
}

