/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.exception;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.Shape;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.exception.RubySystemExit;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.language.objects.AllocationTracing;

@CoreModule(value="SystemExit", isClass=true)
public abstract class SystemExitNodes {

    @Primitive(name="system_exit_set_status", lowerFixnum={1})
    public static abstract class StatusSetNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object setStatus(RubySystemExit error, int exitStatus) {
            error.exitStatus = exitStatus;
            return exitStatus;
        }
    }

    @CoreMethod(names={"status"})
    public static abstract class StatusNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int status(RubySystemExit self) {
            return self.exitStatus;
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubySystemExit allocateSytemExit(RubyClass rubyClass) {
            Shape shape = this.getLanguage().systemExitShape;
            RubySystemExit instance = new RubySystemExit(rubyClass, shape, nil, null, nil, 0);
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }
}

