/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.encoding;

import com.oracle.truffle.api.TruffleOptions;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.graalvm.shadowed.org.jcodings.transcode.TranscoderDB;
import org.graalvm.shadowed.org.jcodings.unicode.UnicodeCodeRange;
import org.graalvm.shadowed.org.jcodings.unicode.UnicodeEncoding;
import org.graalvm.shadowed.org.jcodings.util.CaseInsensitiveBytesHash;
import org.graalvm.shadowed.org.jcodings.util.Hash;
import org.truffleruby.core.string.StringUtils;

public final class TranscodingManager {
    static final Map<String, Set<String>> allDirectTranscoderPaths = new HashMap<String, Set<String>>();

    private static void loadTablesEagerly() {
        for (UnicodeCodeRange unicodeCodeRange : UnicodeCodeRange.values()) {
            UnicodeEncoding.isInCodeRange((UnicodeCodeRange)unicodeCodeRange, (int)0);
        }
    }

    static {
        for (CaseInsensitiveBytesHash sourceEntry : TranscoderDB.transcoders) {
            for (Hash.HashEntry destinationEntry : sourceEntry.entryIterator()) {
                TranscoderDB.Entry e = (TranscoderDB.Entry)destinationEntry.value;
                String sourceName = StringUtils.toUpperCase(new String(e.getSource(), StandardCharsets.US_ASCII));
                String destinationName = StringUtils.toUpperCase(new String(e.getDestination(), StandardCharsets.US_ASCII));
                if (TruffleOptions.AOT) {
                    e.getTranscoder();
                }
                allDirectTranscoderPaths.putIfAbsent(sourceName, new HashSet());
                Set<String> fromSource = allDirectTranscoderPaths.get(sourceName);
                fromSource.add(destinationName);
            }
        }
        if (TruffleOptions.AOT) {
            TranscodingManager.loadTablesEagerly();
        }
    }
}

