/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.encoding;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.language.RubyBaseNode;

public abstract class IsCharacterHeadNode
extends RubyBaseNode {
    public abstract boolean execute(RubyEncoding var1, AbstractTruffleString var2, int var3);

    @Specialization(guards={"enc.isSingleByte"})
    boolean singleByte(RubyEncoding enc, AbstractTruffleString string, int byteOffset) {
        return true;
    }

    @Specialization(guards={"!enc.isSingleByte", "enc.jcoding.isUTF8()"})
    boolean utf8(RubyEncoding enc, AbstractTruffleString string, int byteOffset, @Cached TruffleString.ReadByteNode readByteNode) {
        return IsCharacterHeadNode.utf8IsLead(readByteNode.execute(string, byteOffset, enc.tencoding));
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"!enc.isSingleByte", "!enc.jcoding.isUTF8()"})
    boolean other(RubyEncoding enc, AbstractTruffleString string, int byteOffset, @Cached TruffleString.GetInternalByteArrayNode getInternalByteArrayNode) {
        InternalByteArray byteArray = getInternalByteArrayNode.execute(string, enc.tencoding);
        int addedOffsets = byteArray.getOffset() + byteOffset;
        return enc.jcoding.leftAdjustCharHead(byteArray.getArray(), byteArray.getOffset(), addedOffsets, byteArray.getEnd()) == addedOffsets;
    }

    private static boolean utf8IsLead(int c) {
        return (c & 0xC0 & 0xFF) != 128;
    }
}

