/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.cast;

import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import java.util.Map;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.cast.ToProcNodeGen;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.core.symbol.SymbolNodes;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.methods.DeclarationContext;

@NodeChild(value="childNode", type=RubyNode.class)
@ImportStatic(value={DeclarationContext.class})
public abstract class ToProcNode
extends RubyContextSourceNode {
    abstract RubyNode getChildNode();

    @Specialization
    Nil doNil(Nil nil) {
        return nil;
    }

    @Specialization
    RubyProc doRubyProc(RubyProc proc) {
        return proc;
    }

    @Specialization(guards={"isSingleContext()", "symbol == cachedSymbol"}, assumptions={"getLanguage().coreMethodAssumptions.symbolToProcAssumption"}, limit="1")
    Object doRubySymbolASTInlined(VirtualFrame frame, RubySymbol symbol, @Cached(value="symbol") RubySymbol cachedSymbol, @Cached(value="getProcForSymbol(getRefinements(frame), cachedSymbol)") RubyProc cachedProc) {
        return cachedProc;
    }

    @Specialization(guards={"getRefinements(frame) == NO_REFINEMENTS", "symbol == cachedSymbol"}, assumptions={"getLanguage().coreMethodAssumptions.symbolToProcAssumption"}, limit="1")
    Object doRubySymbolASTInlined(VirtualFrame frame, RubySymbol symbol, @Cached(value="symbol") RubySymbol cachedSymbol, @Cached(value="getOrCreateCallTarget(getContext(), getLanguage(), cachedSymbol, NO_REFINEMENTS)") RootCallTarget callTarget) {
        return SymbolNodes.ToProcNode.createProc(this.getContext(), this.getLanguage(), DeclarationContext.NO_REFINEMENTS, callTarget);
    }

    @Specialization(guards={"!isNil(object)", "!isRubyProc(object)"}, replaces={"doRubySymbolASTInlined"})
    RubyProc doObject(VirtualFrame frame, Object object, @Cached DispatchNode toProc, @Cached InlinedBranchProfile errorProfile) {
        Object coerced;
        try {
            coerced = toProc.callWithFrame((Frame)frame, object, "to_proc");
        }
        catch (RaiseException e) {
            errorProfile.enter((Node)this);
            if (e.getException().getLogicalClass() == this.coreLibrary().noMethodErrorClass) {
                throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorNoImplicitConversion(object, "Proc", this));
            }
            throw e;
        }
        if (coerced instanceof RubyProc) {
            return (RubyProc)coerced;
        }
        errorProfile.enter((Node)this);
        throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorBadCoercion(object, "Proc", "to_proc", coerced, this));
    }

    protected RootCallTarget getOrCreateCallTarget(RubyContext context, RubyLanguage language, RubySymbol symbol, Map<RubyModule, RubyModule[]> refinements) {
        return SymbolNodes.ToProcNode.getOrCreateCallTarget(this.getContext(), this.getLanguage(), symbol, refinements);
    }

    @NeverDefault
    protected RubyProc getProcForSymbol(Map<RubyModule, RubyModule[]> refinements, RubySymbol symbol) {
        RootCallTarget callTarget = this.getOrCreateCallTarget(this.getContext(), this.getLanguage(), symbol, refinements);
        return SymbolNodes.ToProcNode.createProc(this.getContext(), this.getLanguage(), refinements, callTarget);
    }

    protected static Map<RubyModule, RubyModule[]> getRefinements(VirtualFrame frame) {
        return RubyArguments.getDeclarationContext((Frame)frame).getRefinements();
    }

    @Override
    public RubyNode cloneUninitialized() {
        ToProcNode copy = ToProcNodeGen.create(this.getChildNode().cloneUninitialized());
        return copy.copyFlags(this);
    }
}

